/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.dev.resource.impl.ResourceFilter;
import com.google.gwt.thirdparty.apache.ant.types.ZipScanner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PathPrefix {
    private final Set<String> exclusions;
    private ZipScanner exclusionScanner;
    private final List<ResourceFilter> filters;
    private final String prefix;
    private int priority = -1;
    private final boolean shouldReroot;
    private final String moduleName;

    public PathPrefix(String prefix, ResourceFilter filter) {
        this("", prefix, filter, false, null);
    }

    public PathPrefix(String prefix, ResourceFilter filter, boolean shouldReroot) {
        this("", prefix, filter, shouldReroot, null);
    }

    public PathPrefix(String moduleName, String prefix, ResourceFilter filter, boolean shouldReroot, String[] excludeList) {
        this.assertValidPrefix(prefix);
        this.moduleName = moduleName;
        this.prefix = prefix;
        this.filters = new ArrayList<ResourceFilter>(1);
        this.filters.add(filter);
        this.shouldReroot = shouldReroot;
        this.exclusions = new HashSet<String>();
        if (excludeList != null) {
            for (String exclude : excludeList) {
                this.exclusions.add(exclude);
            }
        }
    }

    public Judgement getJudgement(String path) {
        if (!path.startsWith(this.prefix)) {
            return Judgement.IMPLICIT_EXCLUDE;
        }
        if (this.filters.size() == 0 && this.exclusions.size() == 0) {
            return Judgement.FILTER_INCLUDE;
        }
        if (this.shouldReroot) {
            path = this.getRerootedPath(path);
        }
        this.createExcludeFilter();
        if (this.exclusionScanner != null && this.exclusionScanner.match(path)) {
            return Judgement.EXCLUSION_EXCLUDE;
        }
        for (ResourceFilter filter : this.filters) {
            if (filter != null && !filter.allows(path)) continue;
            return Judgement.FILTER_INCLUDE;
        }
        return Judgement.IMPLICIT_EXCLUDE;
    }

    public boolean equals(Object obj) {
        return obj instanceof PathPrefix && this.prefix.equals(((PathPrefix)obj).prefix);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getRerootedPath(String path) {
        assert (path.startsWith(this.prefix));
        if (this.shouldReroot) {
            return path.substring(this.prefix.length());
        }
        return path;
    }

    public int hashCode() {
        return this.prefix.hashCode();
    }

    public void merge(PathPrefix pathPrefix) {
        assert (this.prefix.equals(pathPrefix.prefix));
        for (ResourceFilter filter : pathPrefix.filters) {
            this.filters.add(filter);
        }
        this.exclusions.addAll(pathPrefix.exclusions);
        if (this.exclusionScanner != null && !this.exclusions.isEmpty()) {
            this.exclusionScanner = null;
        }
    }

    public boolean shouldReroot() {
        return this.shouldReroot;
    }

    public String toString() {
        return this.prefix + (this.shouldReroot ? "**" : "*") + (this.filters.size() == 0 ? "" : "?");
    }

    public String getModuleName() {
        return this.moduleName;
    }

    int getPriority() {
        return this.priority;
    }

    void setPriority(int priority) {
        assert (this.priority == -1);
        this.priority = priority;
    }

    private void assertValidPrefix(String prefix) {
        assert (prefix != null);
        assert (("".equals(prefix) || !prefix.startsWith("/") && prefix.endsWith("/")) && !prefix.endsWith("//")) : "malformed prefix";
    }

    private void createExcludeFilter() {
        if (this.exclusionScanner == null && !this.exclusions.isEmpty()) {
            this.exclusionScanner = new ZipScanner();
            this.exclusionScanner.setIncludes(this.exclusions.toArray(new String[this.exclusions.size()]));
            this.exclusionScanner.init();
            this.exclusions.clear();
        }
    }

    public static enum Judgement {
        EXCLUSION_EXCLUDE(false, 3),
        FILTER_INCLUDE(true, 2),
        IMPLICIT_EXCLUDE(false, 1);

        private final boolean include;
        private final int priority;

        private Judgement(boolean include, int priority) {
            this.include = include;
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isInclude() {
            return this.include;
        }
    }
}

