/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.dev.resource.impl.AbstractResource;
import com.google.gwt.thirdparty.guava.common.collect.MapMaker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentMap;

public class FileResource
extends AbstractResource {
    private static final ConcurrentMap<String, FileResource> canonicalFileResources = new MapMaker().weakValues().makeMap();
    private final String abstractPathName;
    private final File file;

    public static FileResource of(String abstractPathName, File file) {
        FileResource sample;
        String key = abstractPathName + "@" + file.getAbsolutePath();
        FileResource canonical = canonicalFileResources.putIfAbsent(key, sample = new FileResource(abstractPathName, file));
        return canonical == null ? sample : canonical;
    }

    private FileResource(String abstractPathName, File file) {
        this.abstractPathName = abstractPathName;
        this.file = file;
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public String getLocation() {
        return this.file.toURI().toString();
    }

    @Override
    public String getPath() {
        return this.abstractPathName;
    }

    @Override
    public InputStream openContents() throws IOException {
        return new FileInputStream(this.file);
    }
}

