/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.resource.impl.AbstractResource;
import com.google.gwt.dev.resource.impl.ClassPathEntry;
import com.google.gwt.dev.resource.impl.PathPrefixSet;
import com.google.gwt.dev.resource.impl.ResourceAccumulatorManager;
import com.google.gwt.dev.resource.impl.ResourceResolution;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DirectoryClassPathEntry
extends ClassPathEntry {
    private final File dir;
    private final String location;

    public DirectoryClassPathEntry(File dir) {
        assert (dir.isAbsolute());
        this.dir = dir;
        this.location = dir.toURI().toString();
    }

    @Override
    public Map<AbstractResource, ResourceResolution> findApplicableResources(TreeLogger logger, PathPrefixSet pathPrefixSet) {
        try {
            return ResourceAccumulatorManager.getResources(this, pathPrefixSet);
        }
        catch (IOException e) {
            System.err.println("The attempt to retrieve files in " + this.dir + " failed.");
            e.printStackTrace();
            return Maps.newLinkedHashMap();
        }
    }

    public File getDirectory() {
        return this.dir;
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

