/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.dev.resource.impl.ResourceFilter;
import com.google.gwt.thirdparty.apache.ant.types.ZipScanner;
import java.util.regex.Pattern;

public class DefaultFilters {
    private static final Pattern antPattern = Pattern.compile("^[\\w\\.\\$/\\-\\*~#%]*$");
    private static final ResourceFilter defaultAntIncludes = new ResourceFilter(){

        @Override
        public boolean allows(String path) {
            return path.charAt(0) != '/';
        }
    };
    private final ResourceFilter rejectAll = new ResourceFilter(){

        @Override
        public boolean allows(String path) {
            return false;
        }
    };

    private static boolean isDefaultExcluded(String path) {
        if (path.endsWith("/CVS") || path.contains("/CVS/") || path.startsWith("CVS/") || path.endsWith("/.cvsignore")) {
            return true;
        }
        if (path.endsWith("/.svn") || path.contains("/.svn/") || path.startsWith(".svn/") || path.endsWith("/.svnignore")) {
            return true;
        }
        if (path.endsWith("/.git") || path.contains("/.git/") || path.startsWith(".git/") || path.endsWith("/.gitignore")) {
            return true;
        }
        if (path.endsWith("/SCCS") || path.contains("/SCCS/")) {
            return true;
        }
        if (path.endsWith("/vssver.scc")) {
            return true;
        }
        return path.endsWith("/.DS_Store");
    }

    static String getPatternFromAntPattern(String antPatternString) {
        if (!antPattern.matcher(antPatternString).matches()) {
            return null;
        }
        if (antPatternString.indexOf("***") != -1) {
            return null;
        }
        if (antPatternString.endsWith("/")) {
            antPatternString = antPatternString + "**";
        }
        StringBuilder sb = new StringBuilder();
        int length = antPatternString.length();
        block6: for (int i = 0; i < length; ++i) {
            char c = antPatternString.charAt(i);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block6;
                }
                case '$': {
                    sb.append("\\$");
                    continue block6;
                }
                case '/': {
                    if (i != 0 && i + 2 < length && antPatternString.charAt(i + 1) == '*' && antPatternString.charAt(i + 2) == '*') {
                        sb.append("(/[^/]*)*");
                        i += 2;
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                case '*': {
                    if (i + 1 < length && antPatternString.charAt(i + 1) == '*') {
                        if (i + 2 < length && antPatternString.charAt(i + 2) == '/') {
                            if (i == 0) {
                                sb.append("([^/]+/)*");
                            } else {
                                sb.append("([^/]*/)*");
                            }
                            i += 2;
                            continue block6;
                        }
                        if (i == 0) {
                            sb.append("([^/].*)*");
                        } else {
                            sb.append(".*");
                        }
                        ++i;
                        continue block6;
                    }
                    sb.append("[^/]*");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static ZipScanner getScanner(String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive) {
        ZipScanner scanner = new ZipScanner();
        if (includeList.length > 0) {
            scanner.setIncludes(includeList);
        }
        if (excludeList.length > 0 || skipList.length > 0) {
            String[] excludeOrSkip = DefaultFilters.concatenate(excludeList, skipList);
            scanner.setExcludes(excludeOrSkip);
        }
        if (defaultExcludes) {
            scanner.addDefaultExcludes();
        }
        scanner.setCaseSensitive(caseSensitive);
        scanner.init();
        return scanner;
    }

    private static String[] concatenate(String[] array1, String[] array2) {
        String[] answer = new String[array1.length + array2.length];
        int i = 0;
        for (String entry : array1) {
            answer[i++] = entry;
        }
        for (String entry : array2) {
            answer[i++] = entry;
        }
        return answer;
    }

    private static Pattern getPatternFromStrings(String ... patterns) {
        StringBuilder entirePattern = new StringBuilder("^");
        int length = patterns.length;
        int count = 0;
        for (String pattern : patterns) {
            entirePattern.append("(" + pattern + ")");
            if (count < length - 1) {
                entirePattern.append("|");
            }
            ++count;
        }
        entirePattern.append("$");
        return Pattern.compile(entirePattern.toString());
    }

    public ResourceFilter customClassFilesFilter(String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive) {
        return this.getCustomFilter(includeList, excludeList, skipList, defaultExcludes, caseSensitive, FilterFileType.CLASS_FILES);
    }

    public ResourceFilter customJavaFilter(String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive) {
        return this.getCustomFilter(includeList, excludeList, skipList, defaultExcludes, caseSensitive, FilterFileType.JAVA_FILES);
    }

    public ResourceFilter customResourceFilter(String[] includeList, String[] excludeList, String[] skipList, boolean defaultExcludes, boolean caseSensitive) {
        return this.getCustomFilter(includeList, excludeList, skipList, defaultExcludes, caseSensitive, FilterFileType.RESOURCE_FILES);
    }

    ResourceFilter customFilterWithCatchAll(String[] includeList, String[] excludeList, String[] skipList, final boolean defaultExcludes, final ResourceFilter catchAll, final FilterFileType filterFileType) {
        assert (includeList.length > 0 || excludeList.length > 0 || skipList.length > 0);
        final ResourceFilter includeFilter = this.getIncludesFilterPart(includeList);
        final ResourceFilter excludeFilter = this.getExcludesFilterPart(DefaultFilters.concatenate(excludeList, skipList));
        if (includeFilter == null || excludeFilter == null) {
            return catchAll;
        }
        ResourceFilter filter = new ResourceFilter(){

            @Override
            public boolean allows(String path) {
                if (path.endsWith("/")) {
                    return catchAll.allows(path);
                }
                return this.isPathAllowedByDefaults(path, defaultExcludes, filterFileType) && includeFilter.allows(path) && !excludeFilter.allows(path);
            }

            private boolean isPathAllowedByDefaults(String path, boolean defaultExcludes2, FilterFileType filterFileType2) {
                boolean fileTypeMatch = filterFileType2.matches(path);
                if (!fileTypeMatch) {
                    return false;
                }
                if (defaultExcludes2) {
                    return !DefaultFilters.isDefaultExcluded(path);
                }
                return true;
            }
        };
        return filter;
    }

    ResourceFilter getCustomFilter(final String[] includeList, final String[] excludeList, final String[] skipList, final boolean defaultExcludes, final boolean caseSensitive, final FilterFileType filterFileType) {
        if (includeList.length == 0 && excludeList.length == 0 && skipList.length == 0 && caseSensitive) {
            return this.getMatchingDefaultFilter(defaultExcludes, filterFileType);
        }
        ResourceFilter catchAll = new ResourceFilter(){
            ZipScanner scanner;
            {
                this.scanner = DefaultFilters.getScanner(includeList, excludeList, skipList, defaultExcludes, caseSensitive);
            }

            @Override
            public boolean allows(String path) {
                return filterFileType.matches(path) && this.scanner.match(path);
            }
        };
        if (!caseSensitive) {
            return catchAll;
        }
        return this.customFilterWithCatchAll(includeList, excludeList, skipList, defaultExcludes, catchAll, filterFileType);
    }

    ResourceFilter getExcludesFilterPart(String[] list) {
        return this.getFilterPart(list, false);
    }

    ResourceFilter getIncludesFilterPart(String[] list) {
        return this.getFilterPart(list, true);
    }

    private ResourceFilter getFilterPart(String[] list, boolean isInclude) {
        if (list.length == 0) {
            return isInclude ? defaultAntIncludes : this.rejectAll;
        }
        String[] patternStrings = new String[list.length];
        int count = 0;
        for (String antPatternString : list) {
            String patternString = DefaultFilters.getPatternFromAntPattern(antPatternString);
            if (patternString == null) {
                return null;
            }
            patternStrings[count++] = patternString;
        }
        final Pattern pattern = DefaultFilters.getPatternFromStrings(patternStrings);
        return new ResourceFilter(){

            @Override
            public boolean allows(String path) {
                return pattern.matcher(path).matches();
            }
        };
    }

    private ResourceFilter getMatchingDefaultFilter(boolean defaultExcludes, FilterFileType filterFileType) {
        if (defaultExcludes) {
            return filterFileType.getDefaultFilter();
        }
        return filterFileType.getFileTypeFilter();
    }

    public static enum FilterFileType {
        RESOURCE_FILES(null),
        JAVA_FILES(".java"),
        CLASS_FILES(".class");

        private final String suffix;
        private final ResourceFilter justThisFileTypeFilter = new ResourceFilter(){

            @Override
            public boolean allows(String path) {
                return defaultAntIncludes.allows(path) && this.matches(path);
            }
        };
        private final ResourceFilter defaultFilter = new ResourceFilter(){

            @Override
            public boolean allows(String path) {
                return this.getFileTypeFilter().allows(path) && !DefaultFilters.isDefaultExcluded(path);
            }
        };

        private FilterFileType(String suffix) {
            this.suffix = suffix;
        }

        public ResourceFilter getDefaultFilter() {
            return this.defaultFilter;
        }

        public ResourceFilter getFileTypeFilter() {
            return this.justThisFileTypeFilter;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean matches(String path) {
            if (this.suffix == null) {
                return true;
            }
            return path.endsWith(this.suffix);
        }
    }
}

