/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.json;

import com.google.gwt.dev.json.JsonArray;
import com.google.gwt.dev.json.JsonBoolean;
import com.google.gwt.dev.json.JsonException;
import com.google.gwt.dev.json.JsonNumber;
import com.google.gwt.dev.json.JsonObject;
import com.google.gwt.dev.json.JsonString;
import com.google.gwt.dev.json.JsonValue;
import java.io.IOException;
import java.io.Reader;

class Tokenizer {
    private static final int INVALID_CHAR = -1;
    private static final String STOPCHARS = ",:]}/\\\"[{;=#";
    private int pushBackBuffer = -1;
    private final Reader reader;

    private static JsonNumber getNumberForLiteral(String literal) throws JsonException {
        try {
            if (literal.indexOf(46) > 0 || literal.indexOf(101) > 0 || literal.indexOf(69) > 0) {
                return JsonNumber.create(Double.parseDouble(literal));
            }
            return JsonNumber.create(Long.parseLong(literal));
        }
        catch (NumberFormatException e) {
            throw new JsonException("Invalid number literal: " + literal);
        }
    }

    private static JsonValue getValueForLiteral(String literal) throws JsonException {
        if ("".equals(literal)) {
            throw new JsonException("Missing value");
        }
        if ("null".equals(literal)) {
            return JsonValue.NULL;
        }
        if ("true".equals(literal)) {
            return JsonBoolean.create(true);
        }
        if ("false".equals(literal)) {
            return JsonBoolean.create(false);
        }
        char c = literal.charAt(0);
        if (c == '-' || Character.isDigit(c)) {
            return Tokenizer.getNumberForLiteral(literal);
        }
        throw new JsonException("Invalid literal: \"" + literal + "\"");
    }

    Tokenizer(Reader reader) {
        this.reader = reader;
    }

    void back(char c) {
        assert (this.pushBackBuffer == -1);
        this.pushBackBuffer = c;
    }

    void back(int c) {
        this.back((char)c);
    }

    int next() throws IOException {
        if (this.pushBackBuffer != -1) {
            int c = this.pushBackBuffer;
            this.pushBackBuffer = -1;
            return c;
        }
        return this.reader.read();
    }

    String next(int n) throws IOException, JsonException {
        int len;
        if (n == 0) {
            return "";
        }
        char[] buffer = new char[n];
        int pos = 0;
        if (this.pushBackBuffer != -1) {
            buffer[0] = (char)this.pushBackBuffer;
            pos = 1;
            this.pushBackBuffer = -1;
        }
        while (pos < n && (len = this.reader.read(buffer, pos, n - pos)) != -1) {
            pos += len;
        }
        if (pos < n) {
            throw new JsonException();
        }
        return String.valueOf(buffer);
    }

    int nextNonWhitespace() throws IOException {
        int c;
        while (Character.isWhitespace(c = this.next())) {
        }
        return c;
    }

    String nextString() throws IOException, JsonException {
        StringBuffer buffer = new StringBuffer();
        int c = this.next();
        assert (c == 34);
        block12: while (true) {
            c = this.next();
            switch (c) {
                case 10: 
                case 13: {
                    throw new JsonException("");
                }
                case 92: {
                    c = this.next();
                    switch (c) {
                        case 98: {
                            buffer.append('\b');
                            continue block12;
                        }
                        case 116: {
                            buffer.append('\t');
                            continue block12;
                        }
                        case 110: {
                            buffer.append('\n');
                            continue block12;
                        }
                        case 102: {
                            buffer.append('\f');
                            continue block12;
                        }
                        case 114: {
                            buffer.append('\r');
                            continue block12;
                        }
                        case 117: {
                            buffer.append((char)Integer.parseInt(this.next(4), 16));
                            continue block12;
                        }
                    }
                    buffer.append((char)c);
                    continue block12;
                }
            }
            if (c == 34) {
                return buffer.toString();
            }
            buffer.append((char)c);
        }
    }

    String nextUntilOneOf(String chars) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int c = this.next();
        while (c != -1) {
            if (Character.isWhitespace(c) || chars.indexOf((char)c) >= 0) {
                this.back(c);
                break;
            }
            buffer.append((char)c);
            c = this.next();
        }
        return buffer.toString();
    }

    JsonValue nextValue() throws IOException, JsonException {
        int c = this.nextNonWhitespace();
        this.back(c);
        switch (c) {
            case 34: {
                return JsonString.create(this.nextString());
            }
            case 123: {
                return JsonObject.parse(this);
            }
            case 91: {
                return JsonArray.parse(this);
            }
        }
        return Tokenizer.getValueForLiteral(this.nextUntilOneOf(STOPCHARS));
    }
}

