/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.json;

import com.google.gwt.dev.json.JsonArray;
import com.google.gwt.dev.json.JsonBoolean;
import com.google.gwt.dev.json.JsonNumber;
import com.google.gwt.dev.json.JsonObject;
import com.google.gwt.dev.json.JsonValue;
import java.io.IOException;
import java.io.Writer;

public class JsonString
implements JsonValue {
    private final String value;

    public static JsonString create(String value) {
        return new JsonString(value);
    }

    static void write(String data, Writer writer) throws IOException {
        if (data == null) {
            writer.append("null");
            return;
        }
        writer.append('\"');
        int n = data.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = data.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.append('\\').append(c);
                    continue block8;
                }
                case '\b': {
                    writer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    writer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    writer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    writer.append("\\r");
                    continue block8;
                }
                default: {
                    writer.append(c);
                }
            }
        }
        writer.append('\"');
    }

    private JsonString(String value) {
        this.value = value;
    }

    @Override
    public JsonArray asArray() {
        return null;
    }

    @Override
    public JsonBoolean asBoolean() {
        return null;
    }

    @Override
    public JsonNumber asNumber() {
        return null;
    }

    @Override
    public JsonObject asObject() {
        return null;
    }

    @Override
    public JsonString asString() {
        return this;
    }

    @Override
    public JsonString copyDeeply() {
        return new JsonString(this.value);
    }

    public String getString() {
        return this.value;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public void write(Writer writer) throws IOException {
        JsonString.write(this.value, writer);
    }
}

