/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.json;

import com.google.gwt.dev.json.JsonArray;
import com.google.gwt.dev.json.JsonBoolean;
import com.google.gwt.dev.json.JsonException;
import com.google.gwt.dev.json.JsonNumber;
import com.google.gwt.dev.json.JsonString;
import com.google.gwt.dev.json.JsonValue;
import com.google.gwt.dev.json.Pair;
import com.google.gwt.dev.json.Tokenizer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JsonObject
implements JsonValue,
Iterable<Pair<String, JsonValue>> {
    private final Map<String, JsonValue> properties = new HashMap<String, JsonValue>();

    public static JsonObject create() {
        return new JsonObject();
    }

    public static JsonObject parse(Reader reader) throws JsonException, IOException {
        return JsonObject.parse(new Tokenizer(reader));
    }

    static JsonObject parse(Tokenizer tokenizer) throws IOException, JsonException {
        JsonObject object = new JsonObject();
        int c = tokenizer.nextNonWhitespace();
        if (c != 123) {
            throw new JsonException("Payload does not begin with '{'.  Got " + c + "(" + Character.valueOf((char)c) + ")");
        }
        block9: while (true) {
            c = tokenizer.nextNonWhitespace();
            switch (c) {
                case 125: {
                    return object;
                }
                case 34: {
                    tokenizer.back(c);
                    String key = tokenizer.nextString();
                    if (tokenizer.nextNonWhitespace() != 58) {
                        throw new JsonException("Invalid object: expecting \":\"");
                    }
                    object.put(key, tokenizer.nextValue());
                    switch (tokenizer.nextNonWhitespace()) {
                        case 44: {
                            continue block9;
                        }
                        case 125: {
                            return object;
                        }
                    }
                    throw new JsonException("Invalid object: expecting } or ,");
                }
                case 44: {
                    continue block9;
                }
            }
            break;
        }
        throw new JsonException("Invalid object: ");
    }

    @Override
    public JsonArray asArray() {
        return null;
    }

    @Override
    public JsonBoolean asBoolean() {
        return null;
    }

    @Override
    public JsonNumber asNumber() {
        return null;
    }

    @Override
    public JsonObject asObject() {
        return this;
    }

    @Override
    public JsonString asString() {
        return null;
    }

    @Override
    public JsonObject copyDeeply() {
        JsonObject copy = new JsonObject();
        for (Map.Entry<String, JsonValue> entry : this.properties.entrySet()) {
            JsonValue value = entry.getValue();
            copy.properties.put(entry.getKey(), value == null ? null : value.copyDeeply());
        }
        return copy;
    }

    public JsonValue get(String key) {
        JsonValue value = this.properties.get(key);
        return value == null ? JsonValue.NULL : value;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public Iterator<Pair<String, JsonValue>> iterator() {
        return new Iter(this.properties.entrySet().iterator());
    }

    public void put(String key, boolean val) {
        this.put(key, JsonBoolean.create(val));
    }

    public void put(String key, double val) {
        this.put(key, JsonNumber.create(val));
    }

    public void put(String key, JsonValue val) {
        this.properties.put(key, val);
    }

    public void put(String key, long val) {
        this.put(key, JsonNumber.create(val));
    }

    public void put(String key, String val) {
        this.put(key, JsonString.create(val));
    }

    @Override
    public void write(Writer writer) throws IOException {
        boolean first = true;
        writer.write(123);
        for (Map.Entry<String, JsonValue> e : this.properties.entrySet()) {
            if (!first) {
                writer.append(',');
            } else {
                first = false;
            }
            JsonString.write(e.getKey(), writer);
            writer.append(':');
            e.getValue().write(writer);
        }
        writer.write(125);
    }

    private static class Iter
    implements Iterator<Pair<String, JsonValue>> {
        private final Iterator<Map.Entry<String, JsonValue>> iter;

        Iter(Iterator<Map.Entry<String, JsonValue>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Pair<String, JsonValue> next() {
            Map.Entry<String, JsonValue> entry = this.iter.next();
            return new Pair<String, JsonValue>(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

