/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.json;

import com.google.gwt.dev.json.JsonArray;
import com.google.gwt.dev.json.JsonBoolean;
import com.google.gwt.dev.json.JsonObject;
import com.google.gwt.dev.json.JsonString;
import com.google.gwt.dev.json.JsonValue;
import java.io.IOException;
import java.io.Writer;

public abstract class JsonNumber
implements JsonValue {
    public static JsonNumber create(double value) {
        return new JsonDecimal(value);
    }

    public static JsonNumber create(long value) {
        return new JsonInteger(value);
    }

    private JsonNumber() {
    }

    @Override
    public JsonArray asArray() {
        return null;
    }

    @Override
    public JsonBoolean asBoolean() {
        return null;
    }

    @Override
    public JsonNumber asNumber() {
        return this;
    }

    @Override
    public JsonObject asObject() {
        return null;
    }

    @Override
    public JsonString asString() {
        return null;
    }

    public abstract double getDecimal();

    public abstract long getInteger();

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    private static class JsonInteger
    extends JsonNumber {
        private final long value;

        public JsonInteger(long value) {
            this.value = value;
        }

        @Override
        public JsonInteger copyDeeply() {
            return new JsonInteger(this.value);
        }

        @Override
        public double getDecimal() {
            return this.value;
        }

        @Override
        public long getInteger() {
            return this.value;
        }

        @Override
        public void write(Writer writer) throws IOException {
            writer.write(Long.toString(this.value));
        }
    }

    private static class JsonDecimal
    extends JsonNumber {
        private final double value;

        public JsonDecimal(double value) {
            this.value = value;
        }

        @Override
        public JsonDecimal copyDeeply() {
            return new JsonDecimal(this.value);
        }

        @Override
        public double getDecimal() {
            return this.value;
        }

        @Override
        public long getInteger() {
            return (long)this.value;
        }

        @Override
        public void write(Writer writer) throws IOException {
            writer.write(Double.toString(this.value));
        }
    }
}

