/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.json;

import com.google.gwt.dev.json.JsonBoolean;
import com.google.gwt.dev.json.JsonException;
import com.google.gwt.dev.json.JsonNumber;
import com.google.gwt.dev.json.JsonObject;
import com.google.gwt.dev.json.JsonString;
import com.google.gwt.dev.json.JsonValue;
import com.google.gwt.dev.json.Tokenizer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class JsonArray
implements JsonValue {
    private final List<JsonValue> values = new ArrayList<JsonValue>();

    public static JsonArray create() {
        return new JsonArray();
    }

    public static JsonArray parse(Reader reader) throws IOException, JsonException {
        JsonArray arr = new Tokenizer(reader).nextValue().asArray();
        if (arr == null) {
            throw new JsonException("Object is not a JSON array.");
        }
        return arr;
    }

    static JsonArray parse(Tokenizer tokenizer) throws IOException, JsonException {
        JsonArray array = new JsonArray();
        int c = tokenizer.nextNonWhitespace();
        assert (c == 91);
        block7: while (true) {
            c = tokenizer.nextNonWhitespace();
            switch (c) {
                case 93: {
                    return array;
                }
            }
            tokenizer.back(c);
            array.add(tokenizer.nextValue());
            int d = tokenizer.nextNonWhitespace();
            switch (d) {
                case 93: {
                    return array;
                }
                case 44: {
                    continue block7;
                }
            }
            break;
        }
        throw new JsonException("Invalid array: expected , or ]");
    }

    public void add(boolean value) {
        this.add(JsonBoolean.create(value));
    }

    public void add(double value) {
        this.add(JsonNumber.create(value));
    }

    public void add(JsonValue value) {
        this.values.add(value);
    }

    public void add(long value) {
        this.add(JsonNumber.create(value));
    }

    public void add(String value) {
        this.add(JsonString.create(value));
    }

    @Override
    public JsonArray asArray() {
        return this;
    }

    @Override
    public JsonBoolean asBoolean() {
        return null;
    }

    @Override
    public JsonNumber asNumber() {
        return null;
    }

    @Override
    public JsonObject asObject() {
        return null;
    }

    @Override
    public JsonString asString() {
        return null;
    }

    @Override
    public JsonArray copyDeeply() {
        JsonArray copy = new JsonArray();
        for (JsonValue value : this.values) {
            copy.values.add(value == null ? null : value.copyDeeply());
        }
        return copy;
    }

    public JsonValue get(int index) {
        JsonValue value = this.values.get(index);
        return value == null ? JsonValue.NULL : value;
    }

    public int getLength() {
        return this.values.size();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(91);
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                writer.write(44);
            }
            this.values.get(i).write(writer);
        }
        writer.write(93);
    }
}

