/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.BinaryDigitReader;
import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.DToA;

public class ScriptRuntime {
    public static double NaN = Double.NaN;

    public static String numberToString(double d, int base) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (base < 2 || base > 36) {
            throw new Error(Context.getMessage1("msg.bad.radix", Integer.toString(base)));
        }
        if (base != 10) {
            return DToA.JS_dtobasestr(base, d);
        }
        StringBuffer result = new StringBuffer();
        DToA.JS_dtostr(result, 0, 0, d);
        return result.toString();
    }

    static double stringToNumber(String s, int start, int radix) {
        int end;
        char digitMax = '9';
        char lowerCaseBound = 'a';
        char upperCaseBound = 'A';
        int len = s.length();
        if (radix < 10) {
            digitMax = (char)(48 + radix - 1);
        }
        if (radix > 10) {
            lowerCaseBound = (char)(97 + radix - 10);
            upperCaseBound = (char)(65 + radix - 10);
        }
        double sum = 0.0;
        for (end = start; end < len; ++end) {
            int newDigit;
            char c = s.charAt(end);
            if ('0' <= c && c <= digitMax) {
                newDigit = c - 48;
            } else if ('a' <= c && c < lowerCaseBound) {
                newDigit = c - 97 + 10;
            } else {
                if ('A' > c || c >= upperCaseBound) break;
                newDigit = c - 65 + 10;
            }
            sum = sum * (double)radix + (double)newDigit;
        }
        if (start == end) {
            return NaN;
        }
        if (sum >= 9.007199254740992E15) {
            if (radix == 10) {
                try {
                    return Double.valueOf(s.substring(start, end));
                }
                catch (NumberFormatException nfe) {
                    return NaN;
                }
            }
            if (radix == 2 || radix == 4 || radix == 8 || radix == 16 || radix == 32) {
                int bit;
                BinaryDigitReader bdr = new BinaryDigitReader(radix, s, start, end);
                sum = 0.0;
                while ((bit = bdr.getNextBinaryDigit()) == 0) {
                }
                if (bit == 1) {
                    sum = 1.0;
                    for (int j = 52; j != 0; --j) {
                        bit = bdr.getNextBinaryDigit();
                        if (bit < 0) {
                            return sum;
                        }
                        sum = sum * 2.0 + (double)bit;
                    }
                    int bit54 = bdr.getNextBinaryDigit();
                    if (bit54 >= 0) {
                        int bit3;
                        double factor = 2.0;
                        int sticky = 0;
                        while ((bit3 = bdr.getNextBinaryDigit()) >= 0) {
                            sticky |= bit3;
                            factor *= 2.0;
                        }
                        sum += (double)(bit54 & (bit | sticky));
                        sum *= factor;
                    }
                }
            }
        }
        return sum;
    }

    public static String escapeString(String s) {
        StringBuffer sb = null;
        int L = s.length();
        for (int i = 0; i != L; ++i) {
            int hexSize;
            char c = s.charAt(i);
            if (' ' <= c && c <= '~' && c != '\"' && c != '\\') {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer(L + 3);
                sb.append(s);
                sb.setLength(i);
            }
            int escape = -1;
            switch (c) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\u000b': {
                    escape = 118;
                    break;
                }
                case '\"': {
                    escape = 34;
                    break;
                }
                case ' ': {
                    escape = 32;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                sb.append('\\');
                sb.append((char)escape);
                continue;
            }
            if (c < '\u0100') {
                sb.append("\\x");
                hexSize = 2;
            } else {
                sb.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                int hc = digit < 10 ? 48 + digit : 87 + digit;
                sb.append((char)hc);
            }
        }
        return sb == null ? s : sb.toString();
    }
}

