/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.google.gwt.dev.js.rhino.EvaluatorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Context {
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    static final String defaultResource = "com.google.gwt.dev.js.rhino.Messages";
    static final boolean printTrees = true;
    static final boolean printICode = true;
    static final boolean check = true;
    private static Hashtable threadContexts = new Hashtable(11);
    private static Object threadLocalCx;
    private static Method threadLocalGet;
    private static Method threadLocalSet;
    int version;
    int errorCount;
    private ErrorReporter errorReporter;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    private boolean compileFunctionsWithDynamicScopeFlag;
    private int enterCount;
    private Object[] listeners;
    private Hashtable hashtable;
    private ClassLoader applicationClassLoader;
    private Hashtable activationNames;
    int instructionCount;
    int instructionThreshold;

    public Context() {
        this.setLanguageVersion(0);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context cx) {
        Context old = Context.getCurrentContext();
        if (cx == null) {
            if (old != null) {
                cx = old;
            } else {
                cx = new Context();
                Context.setThreadContext(cx);
            }
        } else if (cx.enterCount != 0) {
            if (cx != old) {
                throw new RuntimeException("Cannot enter Context active on another thread");
            }
        } else if (old != null) {
            cx = old;
        } else {
            Context.setThreadContext(cx);
        }
        ++cx.enterCount;
        return cx;
    }

    public static void exit() {
        boolean released = false;
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("Calling Context.exit without previous Context.enter");
        }
        if (cx.enterCount < 1) {
            Context.codeBug();
        }
        --cx.enterCount;
        if (cx.enterCount == 0) {
            released = true;
            Context.setThreadContext(null);
        }
    }

    public static Context getCurrentContext() {
        if (threadLocalCx != null) {
            try {
                return (Context)threadLocalGet.invoke(threadLocalCx, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread t = Thread.currentThread();
        return (Context)threadContexts.get(t);
    }

    private static void setThreadContext(Context cx) {
        if (threadLocalCx != null) {
            try {
                threadLocalSet.invoke(threadLocalCx, cx);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread t = Thread.currentThread();
        if (cx != null) {
            threadContexts.put(t, cx);
        } else {
            threadContexts.remove(t);
        }
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int version) {
        this.version = version;
    }

    public String getImplementationVersion() {
        return "Rhino 1.5 release 4.1 2003 04 21";
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public ErrorReporter setErrorReporter(ErrorReporter reporter) {
        this.errorReporter = reporter;
        return reporter;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public Locale setLocale(Locale loc) {
        Locale result = this.locale;
        this.locale = loc;
        return result;
    }

    void firePropertyChange(String property, Object oldValue, Object newValue) {
        Object[] array = this.listeners;
        if (array != null) {
            this.firePropertyChangeImpl(array, property, oldValue, newValue);
        }
    }

    private void firePropertyChangeImpl(Object[] array, String property, Object oldValue, Object newValue) {
        int i = array.length;
        while (i-- != 0) {
            Object obj = array[i];
            if (!(obj instanceof PropertyChangeListener)) continue;
            PropertyChangeListener l = (PropertyChangeListener)obj;
            l.propertyChange(new PropertyChangeEvent(this, property, oldValue, newValue));
        }
    }

    public static void reportWarning(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getContext();
        cx.getErrorReporter().warning(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportError(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            ++cx.errorCount;
        } else {
            throw new EvaluatorException(message);
        }
        cx.getErrorReporter().error(message, sourceName, lineno, lineSource, lineOffset);
    }

    public final Object getThreadLocal(Object key) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(key);
    }

    public void putThreadLocal(Object key, Object value) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(key, value);
    }

    public void removeThreadLocal(Object key) {
        if (this.hashtable == null) {
            return;
        }
        this.hashtable.remove(key);
    }

    public final boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public void setCompileFunctionsWithDynamicScope(boolean flag) {
        this.compileFunctionsWithDynamicScopeFlag = flag;
    }

    public boolean hasFeature(int featureIndex) {
        switch (featureIndex) {
            case 1: {
                return this.version == 100 || this.version == 110 || this.version == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.version == 120;
            }
        }
        throw new IllegalArgumentException();
    }

    static String getMessage0(String messageId) {
        return Context.getMessage(messageId, null);
    }

    static String getMessage1(String messageId, Object arg1) {
        Object[] arguments = new Object[]{arg1};
        return Context.getMessage(messageId, arguments);
    }

    static String getMessage2(String messageId, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return Context.getMessage(messageId, arguments);
    }

    static String getMessage3(String messageId, Object arg1, Object arg2, Object arg3) {
        Object[] arguments = new Object[]{arg1, arg2, arg3};
        return Context.getMessage(messageId, arguments);
    }

    static Context getContext() {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return cx;
    }

    static String getMessage(String messageId, Object[] arguments) {
        String formatString;
        Context cx = Context.getCurrentContext();
        Locale locale = cx != null ? cx.getLocale() : Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle(defaultResource, locale);
        try {
            formatString = rb.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("no message resource found for message property " + messageId);
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(arguments);
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    static void codeBug() {
        throw new RuntimeException("FAILED ASSERTION");
    }
}

