/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.HasName;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JsVars
extends JsStatement
implements Iterable<JsVar> {
    private final List<JsVar> vars = new ArrayList<JsVar>();

    public JsVars(SourceInfo sourceInfo, JsVar ... vars) {
        super(sourceInfo);
        Collections.addAll(this.vars, vars);
    }

    public void add(JsVar var) {
        this.vars.add(var);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.VARS;
    }

    public int getNumVars() {
        return this.vars.size();
    }

    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    @Override
    public Iterator<JsVar> iterator() {
        return this.vars.iterator();
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this.vars);
        }
        v.endVisit(this, ctx);
    }

    public static class JsVar
    extends JsNode
    implements HasName {
        private JsExpression initExpr;
        private final JsName name;

        public JsVar(SourceInfo sourceInfo, JsName name) {
            super(sourceInfo);
            this.name = name;
        }

        public JsExpression getInitExpr() {
            return this.initExpr;
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.VAR;
        }

        @Override
        public JsName getName() {
            return this.name;
        }

        public void setInitExpr(JsExpression initExpr) {
            this.initExpr = initExpr;
        }

        @Override
        public void traverse(JsVisitor v, JsContext ctx) {
            if (v.visit(this, ctx) && this.initExpr != null) {
                this.initExpr = v.accept(this.initExpr);
            }
            v.endVisit(this, ctx);
        }
    }
}

