/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsValueLiteral;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;
import com.google.gwt.dev.util.StringInterner;

public final class JsStringLiteral
extends JsValueLiteral {
    private final String value;

    public JsStringLiteral(SourceInfo sourceInfo, String value) {
        super(sourceInfo);
        this.value = StringInterner.get().intern(value);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.STRING;
    }

    public boolean equals(Object that) {
        if (!(that instanceof JsStringLiteral)) {
            return false;
        }
        return this.value.equals(((JsStringLiteral)that).value);
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean isBooleanFalse() {
        return this.value.length() == 0;
    }

    @Override
    public boolean isBooleanTrue() {
        return this.value.length() != 0;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        v.visit(this, ctx);
        v.endVisit(this, ctx);
    }

    @Override
    public boolean isInternable() {
        return true;
    }
}

