/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.util.StringInterner;
import java.io.Serializable;
import java.util.List;

public abstract class JsScope
implements Serializable {
    private final String description;

    protected JsScope(String description) {
        this.description = StringInterner.get().intern(description);
    }

    public final JsName declareName(String ident) {
        JsName name = this.findExistingNameNoRecurse(ident);
        if (name != null) {
            return name;
        }
        return this.doCreateName(ident, ident);
    }

    public final JsName declareName(String ident, String shortIdent) {
        JsName name = this.findExistingNameNoRecurse(ident);
        if (name != null) {
            if (!name.getShortIdent().equals(shortIdent)) {
                throw new IllegalArgumentException("Requested short name " + shortIdent + " conflicts with preexisting short name " + name.getShortIdent() + " for identifier " + ident);
            }
            return name;
        }
        return this.doCreateName(ident, shortIdent);
    }

    public final JsName declareUnobfuscatableName(String ident) {
        JsName name = this.declareName(ident);
        name.setUnobfuscatable();
        return name;
    }

    public final JsName findExistingName(String ident) {
        JsName name = this.findExistingNameNoRecurse(ident);
        if (name == null && this.getParent() != null) {
            return this.getParent().findExistingName(ident);
        }
        return name;
    }

    public final JsName findExistingUnobfuscatableName(String ident) {
        JsName name = this.findExistingNameNoRecurse(ident);
        if (name != null && name.isObfuscatable()) {
            name = null;
        }
        if (name == null && this.getParent() != null) {
            return this.getParent().findExistingUnobfuscatableName(ident);
        }
        return name;
    }

    public abstract Iterable<JsName> getAllNames();

    public abstract List<JsScope> getChildren();

    public String getDescription() {
        return this.description;
    }

    public abstract JsScope getParent();

    public final String toString() {
        if (this.getParent() != null) {
            return this.description + "->" + this.getParent();
        }
        return this.description;
    }

    protected abstract void addChild(JsScope var1);

    protected abstract JsName doCreateName(String var1, String var2);

    protected abstract JsName findExistingNameNoRecurse(String var1);
}

