/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;

public class JsPropertyInitializer
extends JsNode {
    private JsExpression labelExpr;
    private JsExpression valueExpr;

    public JsPropertyInitializer(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public JsPropertyInitializer(SourceInfo sourceInfo, JsExpression labelExpr, JsExpression valueExpr) {
        super(sourceInfo);
        this.labelExpr = labelExpr;
        this.valueExpr = valueExpr;
        assert (this.isLabelProper());
    }

    public boolean equals(Object that) {
        if (that == null || that.getClass() != this.getClass()) {
            return false;
        }
        JsPropertyInitializer thatPropertyInitializer = (JsPropertyInitializer)that;
        assert (this.isLabelProper() && ((JsPropertyInitializer)that).isLabelProper());
        return JsPropertyInitializer.areLabelsEqual(this.labelExpr, thatPropertyInitializer.labelExpr) && this.valueExpr.equals(thatPropertyInitializer.valueExpr);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.PROPERTY_INIT;
    }

    public JsExpression getLabelExpr() {
        return this.labelExpr;
    }

    public JsExpression getValueExpr() {
        return this.valueExpr;
    }

    public int hashCode() {
        return this.labelExpr.toString().hashCode() + 17 * this.valueExpr.hashCode();
    }

    public boolean hasSideEffects() {
        return this.labelExpr.hasSideEffects() || this.valueExpr.hasSideEffects();
    }

    public void setValueExpr(JsExpression valueExpr) {
        this.valueExpr = valueExpr;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.labelExpr = v.accept(this.labelExpr);
            this.valueExpr = v.accept(this.valueExpr);
        }
        v.endVisit(this, ctx);
    }

    private static boolean areLabelsEqual(JsExpression thisLabel, JsExpression thatLabel) {
        if (thisLabel instanceof JsNameRef && thatLabel instanceof JsNameRef) {
            JsNameRef thisJsNameRef = (JsNameRef)thisLabel;
            JsNameRef thatJsNameRef = (JsNameRef)thatLabel;
            return thisJsNameRef.getIdent().equals(thatJsNameRef.getIdent());
        }
        return thisLabel.equals(thatLabel);
    }

    private boolean isLabelProper() {
        if (this.labelExpr instanceof JsStringLiteral || this.labelExpr instanceof JsNumberLiteral) {
            return true;
        }
        if (!(this.labelExpr instanceof JsNameRef)) {
            return false;
        }
        JsNameRef labelJsNameRef = (JsNameRef)this.labelExpr;
        return labelJsNameRef.getQualifier() == null;
    }
}

