/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.CorrelationFactory;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNormalScope;
import com.google.gwt.dev.js.ast.JsProgramFragment;
import com.google.gwt.dev.js.ast.JsRootScope;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;
import java.util.Arrays;
import java.util.Collection;

public final class JsProgram
extends JsNode {
    public static final String OBJECT_SCOPE_NAME = "Object";
    public static final String GLOBAL_SCOPE_NAME = "Global";
    private final CorrelationFactory correlator;
    private JsProgramFragment[] fragments;
    private final JsScope objectScope;
    private final JsScope topScope;

    public JsProgram() {
        this(CorrelationFactory.DummyCorrelationFactory.INSTANCE);
    }

    public JsProgram(CorrelationFactory correlator) {
        super(correlator.makeSourceInfo(SourceOrigin.create(0, JsProgram.class.getName())));
        this.correlator = correlator;
        this.topScope = new JsNormalScope(JsRootScope.INSTANCE, GLOBAL_SCOPE_NAME);
        this.objectScope = new JsNormalScope(JsRootScope.INSTANCE, OBJECT_SCOPE_NAME);
        this.setFragmentCount(1);
    }

    public SourceInfo createSourceInfo(int lineNumber, String location) {
        return this.correlator.makeSourceInfo(SourceOrigin.create(lineNumber, location));
    }

    public SourceInfo createSourceInfoSynthetic(Class<?> caller) {
        return this.createSourceInfo(0, caller.getName());
    }

    public JsProgramFragment getFragment(int fragment) {
        if (fragment < 0 || fragment >= this.fragments.length) {
            throw new IllegalArgumentException("Invalid fragment: " + fragment);
        }
        return this.fragments[fragment];
    }

    public JsBlock getFragmentBlock(int fragment) {
        if (fragment < 0 || fragment >= this.fragments.length) {
            throw new IllegalArgumentException("Invalid fragment: " + fragment);
        }
        return this.fragments[fragment].getGlobalBlock();
    }

    public int getFragmentCount() {
        return this.fragments.length;
    }

    public Collection<JsProgramFragment> getFragments() {
        return Arrays.asList(this.fragments);
    }

    public JsBlock getGlobalBlock() {
        return this.getFragmentBlock(0);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.PROGRAM;
    }

    public JsScope getObjectScope() {
        return this.objectScope;
    }

    public JsScope getScope() {
        return this.topScope;
    }

    public void setFragmentCount(int fragments) {
        this.fragments = new JsProgramFragment[fragments];
        for (int i = 0; i < fragments; ++i) {
            this.fragments[i] = new JsProgramFragment(this.createSourceInfoSynthetic(JsProgram.class));
        }
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            for (JsProgramFragment fragment : this.fragments) {
                v.accept(fragment);
            }
        }
        v.endVisit(this, ctx);
    }
}

