/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsLiteral;
import com.google.gwt.dev.js.ast.JsPropertyInitializer;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public final class JsObjectLiteral
extends JsLiteral {
    public static final JsObjectLiteral EMPTY = new JsObjectLiteral(SourceOrigin.UNKNOWN);
    private final List<JsPropertyInitializer> properties = Lists.newArrayList();
    private boolean internable = false;

    public static Builder builder(SourceInfo info) {
        return new Builder(info);
    }

    private JsObjectLiteral(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        JsObjectLiteral thatLiteral = (JsObjectLiteral)that;
        return this.internable == thatLiteral.internable && this.properties.equals(thatLiteral.properties);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.OBJECT;
    }

    public List<JsPropertyInitializer> getPropertyInitializers() {
        return Collections.unmodifiableList(this.properties);
    }

    public int hashCode() {
        return this.properties.hashCode() + 17 * (this.internable ? 0 : 1);
    }

    @Override
    public boolean hasSideEffects() {
        for (JsPropertyInitializer prop : this.properties) {
            if (!prop.hasSideEffects()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBooleanFalse() {
        return false;
    }

    @Override
    public boolean isBooleanTrue() {
        return true;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this.properties);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public boolean isInternable() {
        return this.internable;
    }

    public void setInternable() {
        this.internable = true;
    }

    public static class Builder {
        private List<JsPropertyInitializer> propertyInitializers = Lists.newArrayList();
        private final SourceInfo sourceInfo;
        private boolean internable = false;

        private Builder(SourceInfo info) {
            this.sourceInfo = info;
        }

        public Builder add(String property, JsExpression value) {
            this.add(new JsStringLiteral(this.sourceInfo, property), value);
            return this;
        }

        public Builder add(JsExpression property, JsExpression value) {
            this.add(this.sourceInfo, property, value);
            return this;
        }

        public Builder add(SourceInfo sourceInfo, JsExpression property, JsExpression value) {
            this.propertyInitializers.add(new JsPropertyInitializer(sourceInfo, property, value));
            return this;
        }

        public Builder setInternable() {
            this.internable = true;
            return this;
        }

        public JsObjectLiteral build() {
            JsObjectLiteral objectLiteral = new JsObjectLiteral(this.sourceInfo);
            objectLiteral.properties.addAll(this.propertyInitializers);
            if (this.internable) {
                objectLiteral.setInternable();
            }
            return objectLiteral;
        }
    }
}

