/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsValueLiteral;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;

public final class JsNumberLiteral
extends JsValueLiteral {
    private final double value;

    public JsNumberLiteral(SourceInfo sourceInfo, double value) {
        super(sourceInfo);
        this.value = value;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.value == ((JsNumberLiteral)that).value;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.NUMBER;
    }

    public double getValue() {
        return this.value;
    }

    public int hashCode() {
        return new Double(this.value).hashCode();
    }

    @Override
    public boolean isBooleanFalse() {
        return this.value == 0.0;
    }

    @Override
    public boolean isBooleanTrue() {
        return this.value != 0.0;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        v.visit(this, ctx);
        v.endVisit(this, ctx);
    }

    @Override
    public boolean isInternable() {
        return true;
    }
}

