/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.CanBooleanEval;
import com.google.gwt.dev.js.ast.HasName;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsRootScope;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;
import com.google.gwt.dev.util.StringInterner;

public final class JsNameRef
extends JsExpression
implements CanBooleanEval,
HasName {
    private String ident;
    private JsName name;
    private JsExpression qualifier;

    public JsNameRef(SourceInfo sourceInfo, JsName name) {
        super(sourceInfo);
        this.name = name;
    }

    public JsNameRef(SourceInfo sourceInfo, String ident, JsExpression qualifier) {
        this(sourceInfo, ident);
        this.setQualifier(qualifier);
    }

    public JsNameRef(SourceInfo sourceInfo, String ident) {
        super(sourceInfo);
        this.ident = StringInterner.get().intern(ident);
    }

    public String getIdent() {
        return this.name == null ? this.ident : this.name.getIdent();
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.NAME_REF;
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    public JsExpression getQualifier() {
        return this.qualifier;
    }

    public String getShortIdent() {
        return this.name == null ? this.ident : this.name.getShortIdent();
    }

    @Override
    public boolean hasSideEffects() {
        return this.qualifier != null && this.qualifier.hasSideEffects();
    }

    @Override
    public boolean isBooleanFalse() {
        return this.isDefinitelyNull();
    }

    @Override
    public boolean isBooleanTrue() {
        return false;
    }

    @Override
    public boolean isDefinitelyNull() {
        return this.name == JsRootScope.INSTANCE.getUndefined();
    }

    public boolean isJsniReference() {
        return this.getIdent().charAt(0) == '@';
    }

    @Override
    public boolean isLeaf() {
        if (this.qualifier == null) {
            return true;
        }
        return this.qualifier.isLeaf();
    }

    public boolean isResolved() {
        return this.name != null;
    }

    public void resolve(JsName name) {
        this.name = name;
        this.ident = null;
    }

    public void setQualifier(JsExpression qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx) && this.qualifier != null) {
            this.qualifier = v.accept(this.qualifier);
        }
        v.endVisit(this, ctx);
    }
}

