/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.util.StringInterner;
import java.io.Serializable;

public class JsName
implements Serializable {
    private final JsScope enclosing;
    private final String ident;
    private boolean isObfuscatable;
    private String shortIdent;
    private JsNode staticRef;
    private JsName namespace;

    public JsName(JsScope enclosing, String ident, String shortIdent) {
        this.enclosing = enclosing;
        this.ident = StringInterner.get().intern(ident);
        this.shortIdent = StringInterner.get().intern(shortIdent);
        this.isObfuscatable = true;
    }

    public JsScope getEnclosing() {
        return this.enclosing;
    }

    public String getIdent() {
        return this.ident;
    }

    public String getShortIdent() {
        return this.shortIdent;
    }

    public JsNode getStaticRef() {
        return this.staticRef;
    }

    public boolean isObfuscatable() {
        return this.isObfuscatable;
    }

    public JsNameRef makeRef(SourceInfo sourceInfo) {
        return this.makeQualifiedRef(sourceInfo, null);
    }

    public JsNameRef makeQualifiedRef(SourceInfo sourceInfo, JsExpression qualifier) {
        JsNameRef ref = new JsNameRef(sourceInfo, this);
        assert (this.namespace == null || qualifier == null);
        if (qualifier == null && this.namespace != null) {
            qualifier = this.namespace.makeRef(sourceInfo);
        }
        if (qualifier != null) {
            ref.setQualifier(qualifier);
        }
        return ref;
    }

    public void setUnobfuscatable() {
        this.isObfuscatable = false;
    }

    public void setShortIdent(String shortIdent) {
        this.shortIdent = StringInterner.get().intern(shortIdent);
    }

    public JsName getNamespace() {
        return this.namespace;
    }

    public void setNamespace(JsName namespace) {
        this.namespace = namespace;
    }

    public void setStaticRef(JsNode node) {
        this.staticRef = node;
    }

    public String toString() {
        return this.ident;
    }
}

