/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.HasArguments;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class JsInvocation
extends JsExpression
implements HasArguments {
    private final List<JsExpression> args = new ArrayList<JsExpression>();
    private JsExpression qualifier;

    public JsInvocation(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public JsInvocation(SourceInfo sourceInfo, JsFunction function, JsExpression ... args) {
        this(sourceInfo, (JsExpression)function.getName().makeRef(sourceInfo), args);
    }

    public JsInvocation(SourceInfo sourceInfo, JsExpression function, JsExpression ... args) {
        super(sourceInfo);
        this.setQualifier(function);
        Collections.addAll(this.args, args);
    }

    public JsInvocation(SourceInfo sourceInfo, JsFunction function, Iterable<JsExpression> args) {
        this(sourceInfo, (JsExpression)function.getName().makeRef(sourceInfo), args);
    }

    public JsInvocation(SourceInfo sourceInfo, JsExpression function, Iterable<JsExpression> args) {
        super(sourceInfo);
        assert (function != null);
        this.setQualifier(function);
        Iterables.addAll(this.args, args);
    }

    @Override
    public List<JsExpression> getArguments() {
        return this.args;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.INVOKE;
    }

    public JsExpression getQualifier() {
        return this.qualifier;
    }

    @Override
    public boolean hasSideEffects() {
        return true;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    public void setQualifier(JsExpression qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.qualifier = v.accept(this.qualifier);
            v.acceptList(this.args);
        }
        v.endVisit(this, ctx);
    }
}

