/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;

public final class JsIf
extends JsStatement {
    private JsExpression ifExpr;
    private JsStatement thenStmt;
    private JsStatement elseStmt;

    public JsIf(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public JsIf(SourceInfo sourceInfo, JsExpression ifExpr, JsStatement thenStmt, JsStatement elseStmt) {
        super(sourceInfo);
        this.ifExpr = ifExpr;
        this.thenStmt = thenStmt;
        this.elseStmt = elseStmt;
    }

    public JsStatement getElseStmt() {
        return this.elseStmt;
    }

    public JsExpression getIfExpr() {
        return this.ifExpr;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.IF;
    }

    public JsStatement getThenStmt() {
        return this.thenStmt;
    }

    public void setElseStmt(JsStatement elseStmt) {
        this.elseStmt = elseStmt;
    }

    public void setIfExpr(JsExpression ifExpr) {
        this.ifExpr = ifExpr;
    }

    public void setThenStmt(JsStatement thenStmt) {
        this.thenStmt = thenStmt;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.ifExpr = v.accept(this.ifExpr);
            this.thenStmt = v.accept(this.thenStmt);
            if (this.elseStmt != null) {
                this.elseStmt = v.accept(this.elseStmt);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public boolean unconditionalControlBreak() {
        boolean elseBreaks;
        boolean thenBreaks = this.thenStmt != null && this.thenStmt.unconditionalControlBreak();
        boolean bl = elseBreaks = this.elseStmt != null && this.elseStmt.unconditionalControlBreak();
        return thenBreaks && elseBreaks;
    }
}

