/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.common.InliningMode;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.js.ast.HasName;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsLiteral;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNormalScope;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;
import java.util.ArrayList;
import java.util.List;

public final class JsFunction
extends JsLiteral
implements HasName {
    protected JsBlock body;
    protected final List<JsParameter> params = new ArrayList<JsParameter>();
    protected final JsScope scope;
    private boolean isClinit;
    private boolean fromJava;
    private JsFunction superClinit;
    private JsName name;
    private InliningMode inliningMode = InliningMode.NORMAL;

    public JsFunction(SourceInfo sourceInfo, JsScope parent) {
        this(sourceInfo, parent, null, false);
    }

    public JsFunction(SourceInfo sourceInfo, JsScope parent, JsName name) {
        this(sourceInfo, parent, name, false);
    }

    public JsFunction(SourceInfo sourceInfo, JsScope parent, JsName name, boolean fromJava) {
        super(sourceInfo);
        assert (parent != null);
        this.fromJava = fromJava;
        this.setName(name);
        String scopeName = name == null ? "<anonymous>" : name.getIdent();
        scopeName = "function " + scopeName;
        this.scope = new JsNormalScope(parent, scopeName);
    }

    private JsFunction() {
        super(SourceOrigin.UNKNOWN);
        this.scope = null;
    }

    public static JsFunction createSentinel() {
        return new JsFunction();
    }

    public JsBlock getBody() {
        return this.body;
    }

    public boolean isClinit() {
        return this.isClinit;
    }

    public JsFunction getSuperClinit() {
        return this.superClinit;
    }

    public InliningMode getInliningMode() {
        return this.inliningMode;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.FUNCTION;
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    public List<JsParameter> getParameters() {
        return this.params;
    }

    public JsScope getScope() {
        return this.scope;
    }

    @Override
    public boolean hasSideEffects() {
        return this.name != null;
    }

    @Override
    public boolean isBooleanFalse() {
        return false;
    }

    @Override
    public boolean isBooleanTrue() {
        return true;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    public boolean isFromJava() {
        return this.fromJava;
    }

    public boolean isInliningAllowed() {
        return this.inliningMode != InliningMode.DO_NOT_INLINE;
    }

    public void markAsClinit() {
        this.isClinit = true;
    }

    public void setBody(JsBlock body) {
        this.body = body;
    }

    public void setFromJava(boolean fromJava) {
        this.fromJava = fromJava;
    }

    public void setSuperClinit(JsFunction superClinit) {
        this.superClinit = superClinit;
    }

    public void setInliningMode(InliningMode inliningMode) {
        this.inliningMode = inliningMode;
    }

    public void setName(JsName name) {
        this.name = name;
        if (name != null && this.isFromJava()) {
            name.setStaticRef(this);
        }
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this.params);
            this.body = v.accept(this.body);
        }
        v.endVisit(this, ctx);
    }
}

