/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;

public final class JsConditional
extends JsExpression {
    private JsExpression elseExpr;
    private JsExpression testExpr;
    private JsExpression thenExpr;

    public JsConditional(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public JsConditional(SourceInfo sourceInfo, JsExpression testExpr, JsExpression thenExpr, JsExpression elseExpr) {
        super(sourceInfo);
        this.testExpr = testExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    public JsExpression getElseExpression() {
        return this.elseExpr;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.CONDITIONAL;
    }

    public JsExpression getTestExpression() {
        return this.testExpr;
    }

    public JsExpression getThenExpression() {
        return this.thenExpr;
    }

    @Override
    public boolean hasSideEffects() {
        return this.testExpr.hasSideEffects() || this.thenExpr.hasSideEffects() || this.elseExpr.hasSideEffects();
    }

    @Override
    public boolean isDefinitelyNull() {
        return this.thenExpr.isDefinitelyNull() && this.elseExpr.isDefinitelyNull();
    }

    public void setElseExpression(JsExpression elseExpr) {
        this.elseExpr = elseExpr;
    }

    public void setTestExpression(JsExpression testExpr) {
        this.testExpr = testExpr;
    }

    public void setThenExpression(JsExpression thenExpr) {
        this.thenExpr = thenExpr;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.testExpr = v.accept(this.testExpr);
            this.thenExpr = v.accept(this.thenExpr);
            this.elseExpr = v.accept(this.elseExpr);
        }
        v.endVisit(this, ctx);
    }
}

