/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsCatchScope;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;

public class JsCatch
extends JsNode {
    protected final JsCatchScope scope;
    private JsBlock body;
    private JsExpression condition;
    private JsParameter param;

    public JsCatch(SourceInfo sourceInfo, JsScope parent, String ident) {
        super(sourceInfo);
        assert (parent != null);
        this.scope = new JsCatchScope(parent, ident);
        this.param = new JsParameter(sourceInfo, this.scope.findExistingName(ident));
    }

    public JsBlock getBody() {
        return this.body;
    }

    public JsExpression getCondition() {
        return this.condition;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.BREAK;
    }

    public JsParameter getParameter() {
        return this.param;
    }

    public JsScope getScope() {
        return this.scope;
    }

    public void setBody(JsBlock body) {
        this.body = body;
    }

    public void setCondition(JsExpression condition) {
        this.condition = condition;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.param = v.accept(this.param);
            if (this.condition != null) {
                this.condition = v.accept(this.condition);
            }
            this.body = v.accept(this.body);
        }
        v.endVisit(this, ctx);
    }
}

