/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsValueLiteral;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;

public final class JsBooleanLiteral
extends JsValueLiteral {
    public static final JsBooleanLiteral FALSE = new JsBooleanLiteral(SourceOrigin.UNKNOWN, false);
    public static final JsBooleanLiteral TRUE = new JsBooleanLiteral(SourceOrigin.UNKNOWN, true);
    private final boolean value;

    public static JsBooleanLiteral get(boolean value) {
        return value ? TRUE : FALSE;
    }

    private JsBooleanLiteral(SourceInfo sourceInfo, boolean value) {
        super(sourceInfo);
        this.value = value;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.BOOLEAN;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public boolean isBooleanFalse() {
        return !this.value;
    }

    @Override
    public boolean isBooleanTrue() {
        return this.value;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        v.visit(this, ctx);
        v.endVisit(this, ctx);
    }

    private Object readResolve() {
        return JsBooleanLiteral.get(this.value);
    }
}

