/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;

public final class JsBinaryOperation
extends JsExpression {
    private JsExpression arg1;
    private JsExpression arg2;
    private final JsBinaryOperator op;

    public JsBinaryOperation(SourceInfo sourceInfo, JsBinaryOperator op) {
        this(sourceInfo, op, null, null);
    }

    public JsBinaryOperation(SourceInfo sourceInfo, JsBinaryOperator op, JsExpression arg1, JsExpression arg2) {
        super(sourceInfo);
        this.op = op;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    public JsExpression getArg1() {
        return this.arg1;
    }

    public JsExpression getArg2() {
        return this.arg2;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.BINARY_OP;
    }

    public JsBinaryOperator getOperator() {
        return this.op;
    }

    @Override
    public boolean hasSideEffects() {
        return this.op.isAssignment() || this.arg1.hasSideEffects() || this.arg2.hasSideEffects();
    }

    @Override
    public boolean isDefinitelyNull() {
        if (this.op == JsBinaryOperator.AND) {
            return this.arg1.isDefinitelyNull();
        }
        return false;
    }

    public void setArg1(JsExpression arg1) {
        this.arg1 = arg1;
    }

    public void setArg2(JsExpression arg2) {
        this.arg2 = arg2;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.arg1 = this.op.isAssignment() ? v.acceptLvalue(this.arg1) : v.accept(this.arg1);
            this.arg2 = v.accept(this.arg2);
        }
        v.endVisit(this, ctx);
    }
}

