/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsLiteral;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public final class JsArrayLiteral
extends JsLiteral {
    private final List<JsExpression> exprs = Lists.newArrayList();
    private boolean internable = false;

    public JsArrayLiteral(SourceInfo sourceInfo, Iterable<JsExpression> expressions) {
        super(sourceInfo);
        Iterables.addAll(this.exprs, expressions);
    }

    public JsArrayLiteral(SourceInfo sourceInfo, JsExpression ... expressions) {
        this(sourceInfo, Arrays.asList(expressions));
    }

    public List<JsExpression> getExpressions() {
        return this.exprs;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        JsArrayLiteral thatLiteral = (JsArrayLiteral)that;
        return this.internable == thatLiteral.internable && this.exprs.equals(thatLiteral.exprs);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ARRAY;
    }

    public int hashCode() {
        return this.exprs.hashCode() + 17 * (this.internable ? 0 : 1);
    }

    @Override
    public boolean hasSideEffects() {
        for (JsExpression expr : this.exprs) {
            if (!expr.hasSideEffects()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBooleanFalse() {
        return false;
    }

    @Override
    public boolean isBooleanTrue() {
        return true;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this.exprs);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public boolean isInternable() {
        return this.internable;
    }

    public void setInternable() {
        this.internable = true;
    }
}

