/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.NodeKind;

public final class JsArrayAccess
extends JsExpression {
    private JsExpression arrayExpr;
    private JsExpression indexExpr;

    public JsArrayAccess(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public JsArrayAccess(SourceInfo sourceInfo, JsExpression arrayExpr, JsExpression indexExpr) {
        super(sourceInfo);
        this.arrayExpr = arrayExpr;
        this.indexExpr = indexExpr;
    }

    public JsExpression getArrayExpr() {
        return this.arrayExpr;
    }

    public JsExpression getIndexExpr() {
        return this.indexExpr;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ARRAY_ACCESS;
    }

    @Override
    public boolean hasSideEffects() {
        return this.arrayExpr.hasSideEffects() || this.indexExpr.hasSideEffects();
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    public void setArrayExpr(JsExpression arrayExpr) {
        this.arrayExpr = arrayExpr;
    }

    public void setIndexExpr(JsExpression indexExpr) {
        this.indexExpr = indexExpr;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.arrayExpr = v.accept(this.arrayExpr);
            this.indexExpr = v.accept(this.indexExpr);
        }
        v.endVisit(this, ctx);
    }
}

