/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.ast;

import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsProgramFragment;
import com.google.gwt.dev.js.ast.JsPropertyInitializer;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.HashSet;

public class JavaScriptVerifier {
    public static void verify(JsProgram jsProgram, JavaToJavaScriptMap map) {
        if (!JavaScriptVerifier.class.desiredAssertionStatus()) {
            return;
        }
        JavaScriptVerifier.verifyTopLevelMethodMapping(jsProgram, map);
        JavaScriptVerifier.verifyGlobalNameOrdering(jsProgram, map);
    }

    private static void verifyGlobalNameOrdering(JsProgram jsProgram, final JavaToJavaScriptMap map) {
        final HashSet declaredEntities = Sets.newHashSet();
        new JsVisitor(){

            @Override
            public boolean visit(JsFunction x, JsContext ctx) {
                declaredEntities.add(x.getName());
                return false;
            }
        }.accept(jsProgram);
        new JsVisitor(){

            @Override
            public boolean visit(JsFunction x, JsContext ctx) {
                return false;
            }

            @Override
            public boolean visit(JsVars x, JsContext ctx) {
                for (JsVars.JsVar var : x) {
                    declaredEntities.add(var.getName());
                }
                return true;
            }

            @Override
            public boolean visit(JsBinaryOperation x, JsContext ctx) {
                JsNameRef nameRef;
                if (x.getOperator().isAssignment() && (nameRef = (JsNameRef)x.getArg1()).getQualifier() == null) {
                    declaredEntities.add(nameRef.getName());
                }
                return true;
            }

            @Override
            public boolean visit(JsObjectLiteral x, JsContext ctx) {
                for (JsPropertyInitializer propertyInitializer : x.getPropertyInitializers()) {
                    this.accept(propertyInitializer.getValueExpr());
                }
                return false;
            }

            @Override
            public void endVisit(JsNameRef x, JsContext ctx) {
                if (x.getQualifier() != null || !x.getName().isObfuscatable()) {
                    return;
                }
                assert (declaredEntities.contains(x.getName())) : x.getName() + " reference found before  definition.";
                map.nameToField(x.getName());
            }
        }.accept(jsProgram);
    }

    public static void verifyTopLevelMethodMapping(JsProgram jsProgram, JavaToJavaScriptMap map) {
        for (JsProgramFragment fragment : jsProgram.getFragments()) {
            for (JsStatement statement : fragment.getGlobalBlock().getStatements()) {
                JsFunction function = JsUtils.isFunctionDeclaration(statement);
                if (function != null) assert (map.nameToMethod(function.getName()) == map.methodForStatement(statement));
            }
        }
    }

    private JavaScriptVerifier() {
    }
}

