/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.js.JsProtectedNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class ReservedNames {
    static final String BLACKLIST = "js.identifier.blacklist";
    static final String BLACKLIST_SUFFIXES = "js.identifier.blacklist.suffixes";
    private final Set<String> blacklistedIdents;
    private final List<String> blacklistedSuffixes;

    ReservedNames(ConfigurationProperties config) {
        HashSet<String> blacklist = new HashSet<String>();
        ArrayList<String> blacklistSuffixes = new ArrayList<String>();
        if (config != null) {
            blacklist.addAll(config.getCommaSeparatedStrings(BLACKLIST));
            blacklistSuffixes.addAll(config.getCommaSeparatedStrings(BLACKLIST_SUFFIXES));
        }
        this.blacklistedIdents = Collections.unmodifiableSet(blacklist);
        this.blacklistedSuffixes = Collections.unmodifiableList(blacklistSuffixes);
    }

    final boolean isAvailable(String newIdent) {
        if (!JsProtectedNames.isLegalName(newIdent)) {
            return false;
        }
        String lcIdent = newIdent.toLowerCase(Locale.ROOT);
        for (String suffix : this.blacklistedSuffixes) {
            if (!lcIdent.endsWith(suffix.toLowerCase(Locale.ROOT))) continue;
            return false;
        }
        return !this.blacklistedIdents.contains(newIdent);
    }
}

