/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.HasJsInfo;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.JsSafeCloner;
import com.google.gwt.dev.js.ast.JsArrayLiteral;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNew;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsReturn;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsThisRef;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class JsUtils {
    private static final String VALID_JS_NAME_REGEX = "[a-zA-Z_$][\\w_$]*";
    private static final Pattern JAVASCRIPT_VALID_QUALIFIED_NAME_PATTERN = Pattern.compile("[a-zA-Z_$][\\w_$]*(\\.[a-zA-Z_$][\\w_$]*)*");
    private static final Pattern JAVASCRIPT_VALID_IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_$][\\w_$]*");
    private static final String CALL_STRING = StringInterner.get().intern("call");

    public static JsFunction isExecuteOnce(JsInvocation invocation) {
        JsFunction f = JsUtils.isFunction(invocation.getQualifier());
        if (f != null && f.isClinit()) {
            return f;
        }
        return null;
    }

    public static JsFunction isFunction(JsExpression e) {
        JsNode staticRef;
        if (!(e instanceof JsNameRef)) {
            return null;
        }
        JsNameRef ref = (JsNameRef)e;
        if (!ref.getName().isObfuscatable() && CALL_STRING.equals(ref.getIdent()) && ref.getQualifier() instanceof JsNameRef) {
            ref = (JsNameRef)ref.getQualifier();
        }
        if ((staticRef = ref.getName().getStaticRef()) instanceof JsFunction) {
            return (JsFunction)staticRef;
        }
        return null;
    }

    public static JsExpression createAssignment(JsExpression lhs, JsExpression rhs) {
        return JsUtils.createAssignment(lhs.getSourceInfo(), lhs, rhs);
    }

    public static JsExpression createAssignment(SourceInfo info, JsExpression lhs, JsExpression rhs) {
        return new JsBinaryOperation(info, JsBinaryOperator.ASG, lhs, rhs);
    }

    public static JsFunction createBridge(JMethod method, JsName polyName, JsScope scope) {
        SourceInfo sourceInfo = method.getSourceInfo();
        JsFunction bridge = new JsFunction(sourceInfo, scope);
        for (JParameter p : method.getParams()) {
            JsName name = bridge.getScope().declareName(p.getName());
            bridge.getParameters().add(new JsParameter(sourceInfo, name));
        }
        JsNameRef reference = polyName.makeQualifiedRef(sourceInfo, new JsThisRef(sourceInfo));
        ArrayList<JsExpression> args = Lists.newArrayList();
        for (JsParameter p : bridge.getParameters()) {
            args.add(p.getName().makeRef(sourceInfo));
        }
        JsExpression invocation = JsUtils.createInvocationOrPropertyAccess(InvocationStyle.NORMAL, sourceInfo, method, reference.getQualifier(), reference, args);
        JsBlock block = new JsBlock(sourceInfo);
        if (method.getType() == JPrimitiveType.VOID) {
            block.getStatements().add(invocation.makeStmt());
        } else {
            block.getStatements().add(new JsReturn(sourceInfo, invocation));
        }
        bridge.setBody(block);
        return bridge;
    }

    public static JsExpression createCommaExpression(JsExpression ... expressions) {
        return JsUtils.createCommaExpressionHelper(expressions, 0);
    }

    private static JsExpression createCommaExpressionHelper(JsExpression[] expressions, int index) {
        int remainingExpressions = expressions.length - index;
        assert (remainingExpressions >= 2);
        JsExpression lhs = expressions[index];
        JsExpression rhs = expressions[index + 1];
        if (remainingExpressions > 2) {
            rhs = JsUtils.createCommaExpressionHelper(expressions, index + 1);
        }
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return new JsBinaryOperation(lhs.getSourceInfo(), JsBinaryOperator.COMMA, lhs, rhs);
    }

    public static JsFunction createEmptyFunctionLiteral(SourceInfo info, JsScope scope, JsName name) {
        JsFunction func = new JsFunction(info, scope, name);
        func.setBody(new JsBlock(info));
        return func;
    }

    public static JsExpression createQualifiedNameRef(SourceInfo info, JsExpression base, String ... names) {
        JsExpression result = base;
        for (String name : names) {
            result = new JsNameRef(info, name, result);
        }
        return result;
    }

    public static JsNameRef createQualifiedNameRef(String namespace, SourceInfo sourceInfo) {
        assert (!namespace.isEmpty());
        JsNameRef ref = null;
        for (String part : namespace.split("\\.")) {
            JsNameRef newRef = new JsNameRef(sourceInfo, part);
            if (ref != null) {
                newRef.setQualifier(ref);
            }
            ref = newRef;
        }
        return ref;
    }

    public static JsNameRef createQualifiedNameRef(SourceInfo info, JsName ... names) {
        JsNameRef result = null;
        for (JsName name : names) {
            result = result == null ? name.makeRef(info) : name.makeQualifiedRef(info, result);
        }
        return result;
    }

    private static InvocationDescriptor createInvocationDescriptor(InvocationStyle invocationStyle, JMethod method, JsExpression instance, JsNameRef reference, List<JsExpression> args) {
        TargetType targetType;
        CallStyle callStyle = invocationStyle == InvocationStyle.SUPER || invocationStyle == InvocationStyle.FUNCTION && instance instanceof JsNameRef && ((JsNameRef)instance).getQualifier() != null ? CallStyle.USING_CALL : CallStyle.DIRECT;
        switch (invocationStyle) {
            case NEWINSTANCE: {
                assert (method.isConstructor());
                targetType = TargetType.NEWINSTANCE;
                break;
            }
            case FUNCTION: {
                assert (method.isOrOverridesJsFunctionMethod());
                targetType = TargetType.FUNCTION;
                break;
            }
            default: {
                targetType = method.getJsMemberType().isPropertyAccessor() ? (method.getJsMemberType() == HasJsInfo.JsMemberType.GETTER ? TargetType.GETTER : TargetType.SETTER) : TargetType.METHOD;
            }
        }
        JsExpression lastArgument = Iterables.getLast(args, null);
        boolean needsVarargsApply = method.isJsMethodVarargs() && !(lastArgument instanceof JsArrayLiteral);
        List<JsExpression> nonVarargArguments = args;
        JsExpression varargArgument = null;
        if (method.isJsMethodVarargs()) {
            nonVarargArguments = nonVarargArguments.subList(0, args.size() - 1);
            if (!needsVarargsApply) {
                nonVarargArguments.addAll(((JsArrayLiteral)lastArgument).getExpressions());
            } else {
                varargArgument = lastArgument;
                callStyle = CallStyle.USING_APPLY_FOR_VARARGS_ARRAY;
            }
        }
        instance = instance != null ? instance : JsNullLiteral.INSTANCE;
        return new InvocationDescriptor(targetType, callStyle, instance, reference, nonVarargArguments, varargArgument);
    }

    private static JsExpression prepareArgumentsForApply(SourceInfo sourceInfo, Iterable<JsExpression> nonVarargsArguments, JsExpression varargsArgument) {
        if (Iterables.isEmpty(nonVarargsArguments)) {
            return varargsArgument;
        }
        JsArrayLiteral argumentsArray = new JsArrayLiteral(sourceInfo, nonVarargsArguments);
        JsNameRef argumentsConcat = new JsNameRef(sourceInfo, "concat", argumentsArray);
        return new JsInvocation(sourceInfo, (JsExpression)argumentsConcat, varargsArgument);
    }

    public static JsExpression createApplyInvocation(SourceInfo sourceInfo, InvocationDescriptor invocationDescriptor) {
        assert (invocationDescriptor.callStyle == CallStyle.USING_APPLY_FOR_VARARGS_ARRAY);
        switch (invocationDescriptor.targetType) {
            case FUNCTION: {
                return new JsInvocation(sourceInfo, JsUtils.createQualifiedNameRef(sourceInfo, invocationDescriptor.instance, "apply"), JsNullLiteral.INSTANCE, JsUtils.prepareArgumentsForApply(sourceInfo, invocationDescriptor.nonVarargsArguments, invocationDescriptor.varargsArgument));
            }
            case METHOD: {
                JsExpression instance = invocationDescriptor.instance;
                if (instance == invocationDescriptor.reference.getQualifier()) {
                    assert (instance instanceof JsNameRef && ((JsNameRef)instance).isLeaf());
                    instance = Preconditions.checkNotNull(JsSafeCloner.clone(instance));
                }
                return new JsInvocation(sourceInfo, JsUtils.createQualifiedNameRef(sourceInfo, invocationDescriptor.reference, "apply"), instance, JsUtils.prepareArgumentsForApply(sourceInfo, invocationDescriptor.nonVarargsArguments, invocationDescriptor.varargsArgument));
            }
            case NEWINSTANCE: {
                return new JsNew(sourceInfo, (JsExpression)new JsInvocation(sourceInfo, JsUtils.createQualifiedNameRef(sourceInfo, invocationDescriptor.reference, "bind", "apply"), invocationDescriptor.reference, JsUtils.prepareArgumentsForApply(sourceInfo, Iterables.concat(Collections.singleton(JsNullLiteral.INSTANCE), invocationDescriptor.nonVarargsArguments), invocationDescriptor.varargsArgument)), new JsExpression[0]);
            }
        }
        throw new AssertionError((Object)("Target type " + (Object)((Object)invocationDescriptor.targetType) + " invalid for varargs apply invocation"));
    }

    public static JsExpression createDirectInvocationOrPropertyAccess(SourceInfo sourceInfo, InvocationDescriptor invocationDescriptor) {
        assert (invocationDescriptor.callStyle == CallStyle.DIRECT);
        switch (invocationDescriptor.targetType) {
            case SETTER: {
                assert (invocationDescriptor.nonVarargsArguments.size() == 1);
                return JsUtils.createAssignment(invocationDescriptor.reference, (JsExpression)invocationDescriptor.nonVarargsArguments.get(0));
            }
            case GETTER: {
                assert (invocationDescriptor.nonVarargsArguments.size() == 0);
                return invocationDescriptor.reference;
            }
            case FUNCTION: {
                return new JsInvocation(sourceInfo, invocationDescriptor.instance, (Iterable<JsExpression>)invocationDescriptor.nonVarargsArguments);
            }
            case METHOD: {
                return new JsInvocation(sourceInfo, (JsExpression)invocationDescriptor.reference, (Iterable<JsExpression>)invocationDescriptor.nonVarargsArguments);
            }
            case NEWINSTANCE: {
                return new JsNew(sourceInfo, (JsExpression)invocationDescriptor.reference, invocationDescriptor.nonVarargsArguments);
            }
        }
        throw new AssertionError((Object)("Target type " + (Object)((Object)invocationDescriptor.targetType) + " invalid for direct invocation"));
    }

    public static JsExpression createCallInvocationOrSuperPropertyAccess(SourceInfo sourceInfo, InvocationDescriptor invocationDescriptor) {
        assert (invocationDescriptor.callStyle == CallStyle.USING_CALL);
        switch (invocationDescriptor.targetType) {
            case SETTER: {
                assert (invocationDescriptor.nonVarargsArguments.size() == 1);
                throw new UnsupportedOperationException("Super.setter is unsupported");
            }
            case GETTER: {
                assert (invocationDescriptor.nonVarargsArguments.size() == 0);
                throw new UnsupportedOperationException("Super.getter is unsupported");
            }
            case FUNCTION: {
                return JsUtils.createCallInvocation(sourceInfo, invocationDescriptor.instance, JsNullLiteral.INSTANCE, invocationDescriptor.nonVarargsArguments);
            }
            case METHOD: {
                return JsUtils.createCallInvocation(sourceInfo, invocationDescriptor.reference, invocationDescriptor.instance, invocationDescriptor.nonVarargsArguments);
            }
        }
        throw new AssertionError((Object)("Target type " + (Object)((Object)invocationDescriptor.targetType) + " invalid for super invocation"));
    }

    private static JsInvocation createCallInvocation(SourceInfo sourceInfo, JsExpression target, JsExpression instance, Iterable<JsExpression> arguments) {
        return new JsInvocation(sourceInfo, JsUtils.createQualifiedNameRef(sourceInfo, target, "call"), Iterables.concat(Collections.singleton(instance), arguments));
    }

    public static JsExpression createInvocationOrPropertyAccess(InvocationStyle invocationStyle, SourceInfo sourceInfo, JMethod method, JsExpression instance, JsNameRef reference, List<JsExpression> args) {
        InvocationDescriptor invocationDescriptor = JsUtils.createInvocationDescriptor(invocationStyle, method, instance, reference, args);
        switch (invocationDescriptor.callStyle) {
            case DIRECT: {
                return JsUtils.createDirectInvocationOrPropertyAccess(sourceInfo, invocationDescriptor);
            }
            case USING_CALL: {
                return JsUtils.createCallInvocationOrSuperPropertyAccess(sourceInfo, invocationDescriptor);
            }
            case USING_APPLY_FOR_VARARGS_ARRAY: {
                return JsUtils.createApplyInvocation(sourceInfo, invocationDescriptor);
            }
        }
        throw new AssertionError();
    }

    public static JsExpression extractExpression(JsStatement stmt) {
        if (stmt == null) {
            return null;
        }
        if (stmt instanceof JsExprStmt) {
            return ((JsExprStmt)stmt).getExpression();
        }
        if (stmt instanceof JsBlock && ((JsBlock)stmt).getStatements().size() == 1) {
            return JsUtils.extractExpression(((JsBlock)stmt).getStatements().get(0));
        }
        return null;
    }

    public static JsName getJsNameForMethod(JavaToJavaScriptMap jjsmap, JProgram jprogram, String indexedMethodName) {
        return jjsmap.nameForMethod(jprogram.getIndexedMethod(indexedMethodName));
    }

    public static JsName getJsNameForField(JavaToJavaScriptMap jjsmap, JProgram jprogram, String indexedMethodName) {
        return jjsmap.nameForField(jprogram.getIndexedField(indexedMethodName));
    }

    public static boolean isEmpty(JsStatement stmt) {
        if (stmt == null) {
            return true;
        }
        return stmt instanceof JsBlock && ((JsBlock)stmt).getStatements().isEmpty();
    }

    public static JsFunction isFunctionDeclaration(JsStatement stmt) {
        JsFunction func;
        JsExprStmt exprStmt;
        JsExpression expr;
        if (stmt instanceof JsExprStmt && (expr = (exprStmt = (JsExprStmt)stmt).getExpression()) instanceof JsFunction && (func = (JsFunction)expr).getName() != null) {
            return func;
        }
        return null;
    }

    public static boolean isValidJsIdentifier(String name) {
        return JAVASCRIPT_VALID_IDENTIFIER_PATTERN.matcher(name).matches();
    }

    public static boolean isValidJsQualifiedName(String name) {
        return JAVASCRIPT_VALID_QUALIFIED_NAME_PATTERN.matcher(name).matches();
    }

    private JsUtils() {
    }

    public static enum InvocationStyle {
        NORMAL,
        FUNCTION,
        SUPER,
        NEWINSTANCE;

    }

    private static class InvocationDescriptor {
        private final TargetType targetType;
        private final CallStyle callStyle;
        private final List<JsExpression> nonVarargsArguments;
        private final JsExpression varargsArgument;
        private final JsExpression instance;
        private final JsNameRef reference;

        InvocationDescriptor(TargetType targetType, CallStyle callStyle, JsExpression instance, JsNameRef reference, List<JsExpression> nonVarargsArguments, JsExpression varargsArgument) {
            this.targetType = targetType;
            this.callStyle = callStyle;
            this.nonVarargsArguments = nonVarargsArguments;
            this.varargsArgument = varargsArgument;
            this.instance = instance;
            this.reference = reference;
        }
    }

    private static enum CallStyle {
        DIRECT,
        USING_CALL,
        USING_APPLY_FOR_VARARGS_ARRAY;

    }

    private static enum TargetType {
        SETTER,
        GETTER,
        NEWINSTANCE,
        FUNCTION,
        METHOD;

    }
}

