/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.util.collect.IdentityHashSet;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.util.Set;

public class JsUnusedFunctionRemover {
    public static final String NAME = JsUnusedFunctionRemover.class.getSimpleName();
    private final JsProgram program;
    private final Set<JsName> seen = new IdentityHashSet<JsName>();

    public static OptimizerStats exec(JsProgram program) {
        SpeedTracerLogger.Event optimizeJsEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE_JS, "optimizer", NAME);
        OptimizerStats stats = new JsUnusedFunctionRemover(program).execImpl();
        optimizeJsEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    public JsUnusedFunctionRemover(JsProgram program) {
        this.program = program;
    }

    public OptimizerStats execImpl() {
        OptimizerStats stats = new OptimizerStats(NAME);
        new RescueVisitor().accept(this.program);
        RemovalVisitor removalVisitor = new RemovalVisitor();
        removalVisitor.accept(this.program);
        if (removalVisitor.didChange()) {
            stats.recordModified();
        }
        return stats;
    }

    private class RescueVisitor
    extends JsVisitor {
        private RescueVisitor() {
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            JsUnusedFunctionRemover.this.seen.add(x.getName());
        }
    }

    private class RemovalVisitor
    extends JsModVisitor {
        private RemovalVisitor() {
        }

        @Override
        public void endVisit(JsExprStmt x, JsContext ctx) {
            if (!(x.getExpression() instanceof JsFunction)) {
                return;
            }
            JsFunction f = (JsFunction)x.getExpression();
            JsName name = f.getName();
            if (name == null || JsUnusedFunctionRemover.this.seen.contains(name)) {
                return;
            }
            if (f.isClinit()) {
                throw new InternalCompilerException("Tried to remove clinit " + name.getStaticRef().toSource());
            }
            ctx.removeMe();
        }
    }
}

