/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.core.ext.linker.StatementRanges;
import com.google.gwt.core.ext.linker.impl.NamedRange;
import com.google.gwt.core.ext.linker.impl.StandardStatementRanges;
import com.google.gwt.dev.js.JsConstructExpressionVisitor;
import com.google.gwt.dev.js.JsFirstExpressionVisitor;
import com.google.gwt.dev.js.JsPrecedenceVisitor;
import com.google.gwt.dev.js.JsRequiresSemiVisitor;
import com.google.gwt.dev.js.ast.HasName;
import com.google.gwt.dev.js.ast.JsArrayAccess;
import com.google.gwt.dev.js.ast.JsArrayLiteral;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsBooleanLiteral;
import com.google.gwt.dev.js.ast.JsBreak;
import com.google.gwt.dev.js.ast.JsCase;
import com.google.gwt.dev.js.ast.JsCatch;
import com.google.gwt.dev.js.ast.JsConditional;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsContinue;
import com.google.gwt.dev.js.ast.JsDebugger;
import com.google.gwt.dev.js.ast.JsDefault;
import com.google.gwt.dev.js.ast.JsDoWhile;
import com.google.gwt.dev.js.ast.JsEmpty;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFor;
import com.google.gwt.dev.js.ast.JsForIn;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsIf;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsLabel;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameOf;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNew;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsNumericEntry;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsOperator;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsPositionMarker;
import com.google.gwt.dev.js.ast.JsPostfixOperation;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsProgramFragment;
import com.google.gwt.dev.js.ast.JsPropertyInitializer;
import com.google.gwt.dev.js.ast.JsRegExp;
import com.google.gwt.dev.js.ast.JsReturn;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsSwitch;
import com.google.gwt.dev.js.ast.JsThisRef;
import com.google.gwt.dev.js.ast.JsThrow;
import com.google.gwt.dev.js.ast.JsTry;
import com.google.gwt.dev.js.ast.JsUnaryOperator;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.JsWhile;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.dev.util.collect.HashSet;
import com.google.gwt.util.tools.shared.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JsToStringGenerationVisitor
extends JsVisitor {
    private static final char[] CHARS_BREAK = "break".toCharArray();
    private static final char[] CHARS_CASE = "case".toCharArray();
    private static final char[] CHARS_CATCH = "catch".toCharArray();
    private static final char[] CHARS_CONTINUE = "continue".toCharArray();
    private static final char[] CHARS_DEBUGGER = "debugger".toCharArray();
    private static final char[] CHARS_DEFAULT = "default".toCharArray();
    private static final char[] CHARS_DO = "do".toCharArray();
    private static final char[] CHARS_ELSE = "else".toCharArray();
    private static final char[] CHARS_FALSE = "false".toCharArray();
    private static final char[] CHARS_FINALLY = "finally".toCharArray();
    private static final char[] CHARS_FOR = "for".toCharArray();
    private static final char[] CHARS_FUNCTION = "function".toCharArray();
    private static final char[] CHARS_IF = "if".toCharArray();
    private static final char[] CHARS_IN = "in".toCharArray();
    private static final char[] CHARS_NEW = "new".toCharArray();
    private static final char[] CHARS_NULL = "null".toCharArray();
    private static final char[] CHARS_RETURN = "return".toCharArray();
    private static final char[] CHARS_SWITCH = "switch".toCharArray();
    private static final char[] CHARS_THIS = "this".toCharArray();
    private static final char[] CHARS_THROW = "throw".toCharArray();
    private static final char[] CHARS_TRUE = "true".toCharArray();
    private static final char[] CHARS_TRY = "try".toCharArray();
    private static final char[] CHARS_VAR = "var".toCharArray();
    private static final char[] CHARS_WHILE = "while".toCharArray();
    private static final int JSBLOCK_LINES_TO_PRINT = 3;
    protected boolean needSemi = true;
    private List<NamedRange> classRanges = new ArrayList<NamedRange>();
    private NamedRange currentClassRange;
    private NamedRange programClassRange;
    private Set<JsBlock> globalBlocks = new HashSet<JsBlock>();
    private final TextOutput p;
    private ArrayList<Integer> statementEnds = new ArrayList();
    private ArrayList<Integer> statementStarts = new ArrayList();
    private final boolean useLongIdents;

    public JsToStringGenerationVisitor(TextOutput out) {
        this(out, false);
    }

    JsToStringGenerationVisitor(TextOutput out, boolean useLongIdents) {
        this.p = out;
        this.useLongIdents = useLongIdents;
    }

    public List<NamedRange> getClassRanges() {
        return this.classRanges;
    }

    public NamedRange getProgramClassRange() {
        return this.programClassRange;
    }

    public StatementRanges getStatementRanges() {
        return new StandardStatementRanges(this.statementStarts, this.statementEnds);
    }

    @Override
    public boolean visit(JsArrayAccess x, JsContext ctx) {
        JsExpression arrayExpr = x.getArrayExpr();
        this._parenPush(x, arrayExpr, false);
        this.accept(arrayExpr);
        this._parenPop(x, arrayExpr, false);
        this._lsquare();
        this.accept(x.getIndexExpr());
        this._rsquare();
        return false;
    }

    @Override
    public boolean visit(JsArrayLiteral x, JsContext ctx) {
        this._lsquare();
        boolean sep = false;
        Iterator<JsExpression> iterator = x.getExpressions().iterator();
        while (iterator.hasNext()) {
            JsExpression element;
            JsExpression arg = element = iterator.next();
            sep = this._sepCommaOptSpace(sep);
            this._parenPushIfCommaExpr(arg);
            this.accept(arg);
            this._parenPopIfCommaExpr(arg);
        }
        this._rsquare();
        return false;
    }

    @Override
    public boolean visit(JsBinaryOperation x, JsContext ctx) {
        JsBinaryOperator op = x.getOperator();
        JsExpression arg1 = x.getArg1();
        this._parenPush(x, arg1, !op.isLeftAssociative());
        this.accept(arg1);
        if (op.isKeyword()) {
            this._parenPopOrSpace(x, arg1, !op.isLeftAssociative());
        } else {
            this._parenPop(x, arg1, !op.isLeftAssociative());
            this._spaceOpt();
        }
        this.p.print(op.getSymbol());
        JsExpression arg2 = x.getArg2();
        if (this._spaceCalc(op, arg2)) {
            this._parenPushOrSpace(x, arg2, op.isLeftAssociative());
        } else {
            this._spaceOpt();
            this._parenPush(x, arg2, op.isLeftAssociative());
        }
        this.accept(arg2);
        this._parenPop(x, arg2, op.isLeftAssociative());
        return false;
    }

    @Override
    public boolean visit(JsBlock x, JsContext ctx) {
        this.printJsBlock(x, true, true);
        return false;
    }

    @Override
    public boolean visit(JsBooleanLiteral x, JsContext ctx) {
        if (x.getValue()) {
            this._true();
        } else {
            this._false();
        }
        return false;
    }

    @Override
    public boolean visit(JsBreak x, JsContext ctx) {
        this._break();
        JsNameRef label = x.getLabel();
        if (label != null) {
            this._space();
            this._nameRef(label);
        }
        return false;
    }

    @Override
    public boolean visit(JsCase x, JsContext ctx) {
        this._case();
        this._space();
        this.accept(x.getCaseExpr());
        this._colon();
        this._newlineOpt();
        this.indent();
        Iterator<JsStatement> iterator = x.getStmts().iterator();
        while (iterator.hasNext()) {
            JsStatement element;
            JsStatement stmt = element = iterator.next();
            this.needSemi = true;
            this.accept(stmt);
            if (this.needSemi) {
                this._semi();
            }
            this._newlineOpt();
        }
        this.outdent();
        this.needSemi = false;
        return false;
    }

    @Override
    public boolean visit(JsCatch x, JsContext ctx) {
        this._spaceOpt();
        this._catch();
        this._spaceOpt();
        this._lparen();
        this._nameDef(x.getParameter().getName());
        JsExpression catchCond = x.getCondition();
        if (catchCond != null) {
            this._space();
            this._if();
            this._space();
            this.accept(catchCond);
        }
        this._rparen();
        this._spaceOpt();
        this.accept(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsPositionMarker x, JsContext ctx) {
        this.needSemi = false;
        switch (x.getType()) {
            case CLASS_START: {
                assert (this.currentClassRange == null) : "Class start and end boundaries must be matched and not nested.";
                this.currentClassRange = new NamedRange(x.getName());
                this.currentClassRange.setStartPosition(this.p.getPosition());
                this.currentClassRange.setStartLineNumber(this.p.getLine());
                break;
            }
            case CLASS_END: {
                assert (this.currentClassRange != null) : "Class start and end boundaries must be matched and not nested.";
                this.currentClassRange.setEndPosition(this.p.getPosition());
                this.currentClassRange.setEndLineNumber(this.p.getLine());
                this.classRanges.add(this.currentClassRange);
                this.currentClassRange = null;
                break;
            }
            case PROGRAM_START: {
                this.programClassRange = new NamedRange("Program");
                this.programClassRange.setStartPosition(this.p.getPosition());
                this.programClassRange.setStartLineNumber(this.p.getLine());
                break;
            }
            case PROGRAM_END: {
                assert (this.programClassRange != null) : "Program start and end boundaries must be matched.";
                this.programClassRange.setEndPosition(this.p.getPosition());
                this.programClassRange.setEndLineNumber(this.p.getLine());
                break;
            }
            default: {
                assert (false) : (Object)((Object)x.getType()) + " position type is not recognized.";
                break;
            }
        }
        return super.visit(x, ctx);
    }

    @Override
    public boolean visit(JsConditional x, JsContext ctx) {
        JsExpression testExpression = x.getTestExpression();
        this._parenPush(x, testExpression, true);
        this.accept(testExpression);
        this._parenPop(x, testExpression, true);
        this._questionMark();
        JsExpression thenExpression = x.getThenExpression();
        this._parenPush(x, thenExpression, false);
        this.accept(thenExpression);
        this._parenPop(x, thenExpression, false);
        this._colon();
        JsExpression elseExpression = x.getElseExpression();
        this._parenPush(x, elseExpression, false);
        this.accept(elseExpression);
        this._parenPop(x, elseExpression, false);
        return false;
    }

    @Override
    public boolean visit(JsContinue x, JsContext ctx) {
        this._continue();
        JsNameRef label = x.getLabel();
        if (label != null) {
            this._space();
            this._nameRef(label);
        }
        return false;
    }

    @Override
    public boolean visit(JsDebugger x, JsContext ctx) {
        this._debugger();
        return false;
    }

    @Override
    public boolean visit(JsDefault x, JsContext ctx) {
        this._default();
        this._colon();
        this.indent();
        Iterator<JsStatement> iterator = x.getStmts().iterator();
        while (iterator.hasNext()) {
            JsStatement element;
            JsStatement stmt = element = iterator.next();
            this.needSemi = true;
            this.accept(stmt);
            if (this.needSemi) {
                this._semi();
            }
            this._newlineOpt();
        }
        this.outdent();
        this.needSemi = false;
        return false;
    }

    @Override
    public boolean visit(JsDoWhile x, JsContext ctx) {
        this._do();
        this._nestedPush(x.getBody(), true);
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        if (this.needSemi) {
            this._semi();
            this._newlineOpt();
        } else {
            this._spaceOpt();
            this.needSemi = true;
        }
        this._while();
        this._spaceOpt();
        this._lparen();
        this.accept(x.getCondition());
        this._rparen();
        return false;
    }

    @Override
    public boolean visit(JsEmpty x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsExprStmt x, JsContext ctx) {
        boolean surroundWithParentheses = JsFirstExpressionVisitor.exec(x);
        if (surroundWithParentheses) {
            this._lparen();
        }
        JsExpression expr = x.getExpression();
        this.accept(expr);
        if (surroundWithParentheses) {
            this._rparen();
        }
        return false;
    }

    @Override
    public boolean visit(JsFor x, JsContext ctx) {
        this._for();
        this._spaceOpt();
        this._lparen();
        if (x.getInitExpr() != null) {
            this.accept(x.getInitExpr());
        } else if (x.getInitVars() != null) {
            this.accept(x.getInitVars());
        }
        this._semi();
        if (x.getCondition() != null) {
            this._spaceOpt();
            this.accept(x.getCondition());
        }
        this._semi();
        if (x.getIncrExpr() != null) {
            this._spaceOpt();
            this.accept(x.getIncrExpr());
        }
        this._rparen();
        this._nestedPush(x.getBody(), false);
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsForIn x, JsContext ctx) {
        this._for();
        this._spaceOpt();
        this._lparen();
        if (x.getIterVarName() != null) {
            this._var();
            this._space();
            this._nameDef(x.getIterVarName());
            if (x.getIterExpr() != null) {
                this._spaceOpt();
                this._assignment();
                this._spaceOpt();
                this.accept(x.getIterExpr());
            }
        } else {
            this.accept(x.getIterExpr());
        }
        this._space();
        this._in();
        this._space();
        this.accept(x.getObjExpr());
        this._rparen();
        this._nestedPush(x.getBody(), false);
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsFunction x, JsContext ctx) {
        this._function();
        if (x.getName() != null) {
            this._space();
            this._nameOf(x);
        }
        this._lparen();
        boolean sep = false;
        Iterator<JsParameter> iterator = x.getParameters().iterator();
        while (iterator.hasNext()) {
            JsParameter element;
            JsParameter param = element = iterator.next();
            sep = this._sepCommaOptSpace(sep);
            this.accept(param);
        }
        this._rparen();
        this.accept(x.getBody());
        this.needSemi = true;
        return false;
    }

    @Override
    public boolean visit(JsIf x, JsContext ctx) {
        this._if();
        this._spaceOpt();
        this._lparen();
        this.accept(x.getIfExpr());
        this._rparen();
        JsStatement thenStmt = x.getThenStmt();
        this._nestedPush(thenStmt, false);
        this.accept(thenStmt);
        this._nestedPop(thenStmt);
        JsStatement elseStmt = x.getElseStmt();
        if (elseStmt != null) {
            if (this.needSemi) {
                this._semi();
                this._newlineOpt();
            } else {
                this._spaceOpt();
                this.needSemi = true;
            }
            this._else();
            boolean elseIf = elseStmt instanceof JsIf;
            if (!elseIf) {
                this._nestedPush(elseStmt, true);
            } else {
                this._space();
            }
            this.accept(elseStmt);
            if (!elseIf) {
                this._nestedPop(elseStmt);
            }
        }
        return false;
    }

    @Override
    public boolean visit(JsInvocation x, JsContext ctx) {
        JsExpression qualifier = x.getQualifier();
        this._parenPush(x, qualifier, false);
        this.accept(qualifier);
        this._parenPop(x, qualifier, false);
        this._lparen();
        boolean sep = false;
        Iterator<JsExpression> iterator = x.getArguments().iterator();
        while (iterator.hasNext()) {
            JsExpression element;
            JsExpression arg = element = iterator.next();
            sep = this._sepCommaOptSpace(sep);
            this._parenPushIfCommaExpr(arg);
            this.accept(arg);
            this._parenPopIfCommaExpr(arg);
        }
        this._rparen();
        return false;
    }

    @Override
    public boolean visit(JsLabel x, JsContext ctx) {
        this._nameOf(x);
        this._colon();
        this._spaceOpt();
        this.accept(x.getStmt());
        return false;
    }

    @Override
    public boolean visit(JsNameOf x, JsContext ctx) {
        if (this.useLongIdents) {
            this.printStringLiteral(x.getName().getIdent());
        } else {
            this.printStringLiteral(x.getName().getShortIdent());
        }
        return false;
    }

    @Override
    public boolean visit(JsNameRef x, JsContext ctx) {
        JsExpression q = x.getQualifier();
        if (q != null) {
            this._parenPush(x, q, false);
            this.accept(q);
            if (q instanceof JsNumberLiteral) {
                this._space();
            }
            this._parenPop(x, q, false);
            this._dot();
        }
        this._nameRef(x);
        return false;
    }

    @Override
    public boolean visit(JsNew x, JsContext ctx) {
        List<JsExpression> args;
        this._new();
        this._space();
        JsExpression ctorExpr = x.getConstructorExpression();
        boolean needsParens = JsConstructExpressionVisitor.exec(ctorExpr);
        if (needsParens) {
            this._lparen();
        }
        this.accept(ctorExpr);
        if (needsParens) {
            this._rparen();
        }
        if ((args = x.getArguments()).size() > 0) {
            this._lparen();
            boolean sep = false;
            for (JsExpression arg : args) {
                sep = this._sepCommaOptSpace(sep);
                this._parenPushIfCommaExpr(arg);
                this.accept(arg);
                this._parenPopIfCommaExpr(arg);
            }
            this._rparen();
        }
        return false;
    }

    @Override
    public boolean visit(JsNullLiteral x, JsContext ctx) {
        this._null();
        return false;
    }

    @Override
    public boolean visit(JsNumberLiteral x, JsContext ctx) {
        double dvalue = x.getValue();
        if (dvalue == 0.0 && 1.0 / dvalue == Double.NEGATIVE_INFINITY) {
            this.p.print("-0.");
            return false;
        }
        long lvalue = (long)dvalue;
        if ((double)lvalue == dvalue) {
            this.p.print(Long.toString(lvalue));
        } else {
            this.p.print(Double.toString(dvalue));
        }
        return false;
    }

    @Override
    public boolean visit(JsNumericEntry x, JsContext ctx) {
        this.p.print(Integer.toString(x.getValue()));
        return false;
    }

    @Override
    public boolean visit(JsObjectLiteral x, JsContext ctx) {
        this._lbrace();
        boolean sep = false;
        for (JsPropertyInitializer element : x.getPropertyInitializers()) {
            sep = this._sepCommaOptSpace(sep);
            this.accept(element.getLabelExpr());
            this._colon();
            JsExpression valueExpr = element.getValueExpr();
            this._parenPushIfCommaExpr(valueExpr);
            this.accept(valueExpr);
            this._parenPopIfCommaExpr(valueExpr);
        }
        this._rbrace();
        return false;
    }

    @Override
    public boolean visit(JsParameter x, JsContext ctx) {
        this._nameOf(x);
        return false;
    }

    @Override
    public boolean visit(JsPostfixOperation x, JsContext ctx) {
        JsUnaryOperator op = x.getOperator();
        JsExpression arg = x.getArg();
        this._parenPush(x, arg, false);
        this.accept(arg);
        this._parenPop(x, arg, false);
        this.p.print(op.getSymbol());
        return false;
    }

    @Override
    public boolean visit(JsPrefixOperation x, JsContext ctx) {
        JsUnaryOperator op = x.getOperator();
        this.p.print(op.getSymbol());
        JsExpression arg = x.getArg();
        if (this._spaceCalc(op, arg)) {
            this._space();
        }
        this._parenPush(x, arg, false);
        this.accept(arg);
        this._parenPop(x, arg, false);
        return false;
    }

    @Override
    public boolean visit(JsProgram x, JsContext ctx) {
        this.p.print("<JsProgram>");
        return false;
    }

    @Override
    public boolean visit(JsProgramFragment x, JsContext ctx) {
        this.p.print("<JsProgramFragment>");
        return false;
    }

    @Override
    public boolean visit(JsPropertyInitializer x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsRegExp x, JsContext ctx) {
        this._slash();
        this.p.print(x.getPattern());
        this._slash();
        String flags = x.getFlags();
        if (flags != null) {
            this.p.print(flags);
        }
        return false;
    }

    @Override
    public boolean visit(JsReturn x, JsContext ctx) {
        this._return();
        JsExpression expr = x.getExpr();
        if (expr != null) {
            this._space();
            this.accept(expr);
        }
        return false;
    }

    @Override
    public boolean visit(JsStringLiteral x, JsContext ctx) {
        this.printStringLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(JsSwitch x, JsContext ctx) {
        this._switch();
        this._spaceOpt();
        this._lparen();
        this.accept(x.getExpr());
        this._rparen();
        this._spaceOpt();
        this._blockOpen();
        this.acceptList(x.getCases());
        this._blockClose();
        return false;
    }

    @Override
    public boolean visit(JsThisRef x, JsContext ctx) {
        this._this();
        return false;
    }

    @Override
    public boolean visit(JsThrow x, JsContext ctx) {
        this._throw();
        this._space();
        this.accept(x.getExpr());
        return false;
    }

    @Override
    public boolean visit(JsTry x, JsContext ctx) {
        this._try();
        this._spaceOpt();
        this.accept(x.getTryBlock());
        this.acceptList(x.getCatches());
        JsBlock finallyBlock = x.getFinallyBlock();
        if (finallyBlock != null) {
            this._spaceOpt();
            this._finally();
            this._spaceOpt();
            this.accept(finallyBlock);
        }
        return false;
    }

    @Override
    public boolean visit(JsVars.JsVar x, JsContext ctx) {
        this._nameOf(x);
        JsExpression initExpr = x.getInitExpr();
        if (initExpr != null) {
            this._spaceOpt();
            this._assignment();
            this._spaceOpt();
            this._parenPushIfCommaExpr(initExpr);
            this.accept(initExpr);
            this._parenPopIfCommaExpr(initExpr);
        }
        return false;
    }

    @Override
    public boolean visit(JsVars x, JsContext ctx) {
        this._var();
        this._space();
        boolean sep = false;
        for (JsVars.JsVar var : x) {
            sep = this._sepCommaOptSpace(sep);
            this.accept(var);
        }
        return false;
    }

    @Override
    public boolean visit(JsWhile x, JsContext ctx) {
        this._while();
        this._spaceOpt();
        this._lparen();
        this.accept(x.getCondition());
        this._rparen();
        this._nestedPush(x.getBody(), false);
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        return false;
    }

    protected void _newline() {
        this.p.newline();
    }

    protected void _newlineOpt() {
        this.p.newlineOpt();
    }

    protected void billChildToHere() {
    }

    protected void printJsBlock(JsBlock x, boolean truncate, boolean finalNewline) {
        boolean needBraces;
        boolean bl = needBraces = !x.isGlobalBlock();
        if (needBraces) {
            this._blockOpen();
        }
        int count = 0;
        Iterator<JsStatement> iter = x.getStatements().iterator();
        while (iter.hasNext()) {
            boolean isGlobal;
            boolean bl2 = isGlobal = x.isGlobalBlock() || this.globalBlocks.contains(x);
            if (truncate && count > 3) {
                this.p.print("[...]");
                this._newlineOpt();
                break;
            }
            JsStatement stmt = iter.next();
            this.needSemi = true;
            boolean shouldRecordPositions = isGlobal && stmt.shouldRecordPosition();
            boolean stmtIsGlobalBlock = false;
            if (isGlobal && stmt instanceof JsBlock) {
                stmtIsGlobalBlock = true;
                this.globalBlocks.add((JsBlock)stmt);
            }
            if (shouldRecordPositions) {
                this.statementStarts.add(this.p.getPosition());
            }
            this.accept(stmt);
            if (stmtIsGlobalBlock) {
                this.globalBlocks.remove(stmt);
            }
            if (this.needSemi) {
                boolean lastStatement;
                boolean functionStmt = stmt instanceof JsExprStmt && ((JsExprStmt)stmt).getExpression() instanceof JsFunction;
                boolean bl3 = lastStatement = !iter.hasNext() && needBraces && !JsRequiresSemiVisitor.exec(stmt);
                if (functionStmt) {
                    if (lastStatement) {
                        this._newlineOpt();
                    } else {
                        this._newline();
                    }
                } else {
                    if (lastStatement) {
                        this._semiOpt();
                    } else {
                        this._semi();
                    }
                    this._newlineOpt();
                    this.billChildToHere();
                }
            }
            if (shouldRecordPositions) {
                assert (this.statementStarts.size() == this.statementEnds.size() + 1);
                this.statementEnds.add(this.p.getPosition());
            }
            ++count;
        }
        if (needBraces) {
            this.p.indentOut();
            this.p.print('}');
            if (finalNewline) {
                this._newlineOpt();
            }
        }
        this.needSemi = false;
    }

    private void _assignment() {
        this.p.print('=');
    }

    private void _blockClose() {
        this.p.indentOut();
        this.p.print('}');
        this._newlineOpt();
    }

    private void _blockOpen() {
        this.p.print('{');
        this.p.indentIn();
        this._newlineOpt();
    }

    private void _break() {
        this.p.print(CHARS_BREAK);
    }

    private void _case() {
        this.p.print(CHARS_CASE);
    }

    private void _catch() {
        this.p.print(CHARS_CATCH);
    }

    private void _colon() {
        this.p.print(':');
    }

    private void _continue() {
        this.p.print(CHARS_CONTINUE);
    }

    private void _debugger() {
        this.p.print(CHARS_DEBUGGER);
    }

    private void _default() {
        this.p.print(CHARS_DEFAULT);
    }

    private void _do() {
        this.p.print(CHARS_DO);
    }

    private void _dot() {
        this.p.print('.');
    }

    private void _else() {
        this.p.print(CHARS_ELSE);
    }

    private void _false() {
        this.p.print(CHARS_FALSE);
    }

    private void _finally() {
        this.p.print(CHARS_FINALLY);
    }

    private void _for() {
        this.p.print(CHARS_FOR);
    }

    private void _function() {
        this.p.print(CHARS_FUNCTION);
    }

    private void _if() {
        this.p.print(CHARS_IF);
    }

    private void _in() {
        this.p.print(CHARS_IN);
    }

    private void _lbrace() {
        this.p.print('{');
    }

    private void _lparen() {
        this.p.print('(');
    }

    private void _lsquare() {
        this.p.print('[');
    }

    private void _nameDef(JsName name) {
        if (this.useLongIdents) {
            this.p.print(name.getIdent());
        } else {
            this.p.print(name.getShortIdent());
        }
    }

    private void _nameOf(HasName hasName) {
        this._nameDef(hasName.getName());
    }

    private void _nameRef(JsNameRef nameRef) {
        if (this.useLongIdents) {
            this.p.print(nameRef.getIdent());
        } else {
            this.p.print(nameRef.getShortIdent());
        }
    }

    private boolean _nestedPop(JsStatement statement) {
        boolean pop;
        boolean bl = pop = !(statement instanceof JsBlock);
        if (pop) {
            this.p.indentOut();
        }
        return pop;
    }

    private boolean _nestedPush(JsStatement statement, boolean needSpace) {
        boolean push;
        boolean bl = push = !(statement instanceof JsBlock);
        if (push) {
            if (needSpace) {
                this._space();
            }
            this.p.indentIn();
            this._newlineOpt();
        } else {
            this._spaceOpt();
        }
        return push;
    }

    private void _new() {
        this.p.print(CHARS_NEW);
    }

    private void _null() {
        this.p.print(CHARS_NULL);
    }

    private boolean _parenCalc(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        int childPrec;
        int parentPrec = JsPrecedenceVisitor.exec(parent);
        return parentPrec > (childPrec = JsPrecedenceVisitor.exec(child)) || parentPrec == childPrec && wrongAssoc;
    }

    private boolean _parenPop(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPop = this._parenCalc(parent, child, wrongAssoc);
        if (doPop) {
            this._rparen();
        }
        return doPop;
    }

    private boolean _parenPopIfCommaExpr(JsExpression x) {
        boolean doPop;
        boolean bl = doPop = x instanceof JsBinaryOperation && ((JsBinaryOperation)x).getOperator() == JsBinaryOperator.COMMA;
        if (doPop) {
            this._rparen();
        }
        return doPop;
    }

    private boolean _parenPopOrSpace(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPop = this._parenCalc(parent, child, wrongAssoc);
        if (doPop) {
            this._rparen();
        } else {
            this._space();
        }
        return doPop;
    }

    private boolean _parenPush(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPush = this._parenCalc(parent, child, wrongAssoc);
        if (doPush) {
            this._lparen();
        }
        return doPush;
    }

    private boolean _parenPushIfCommaExpr(JsExpression x) {
        boolean doPush;
        boolean bl = doPush = x instanceof JsBinaryOperation && ((JsBinaryOperation)x).getOperator() == JsBinaryOperator.COMMA;
        if (doPush) {
            this._lparen();
        }
        return doPush;
    }

    private boolean _parenPushOrSpace(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPush = this._parenCalc(parent, child, wrongAssoc);
        if (doPush) {
            this._lparen();
        } else {
            this._space();
        }
        return doPush;
    }

    private void _questionMark() {
        this.p.print('?');
    }

    private void _rbrace() {
        this.p.print('}');
    }

    private void _return() {
        this.p.print(CHARS_RETURN);
    }

    private void _rparen() {
        this.p.print(')');
    }

    private void _rsquare() {
        this.p.print(']');
    }

    private void _semi() {
        this.p.print(';');
        this.billChildToHere();
    }

    private void _semiOpt() {
        this.p.printOpt(';');
        this.billChildToHere();
    }

    private boolean _sepCommaOptSpace(boolean sep) {
        if (sep) {
            this.p.print(',');
            this._spaceOpt();
        }
        return true;
    }

    private void _slash() {
        this.p.print('/');
    }

    private void _space() {
        this.p.print(' ');
    }

    private boolean _spaceCalc(JsOperator op, JsExpression arg) {
        if (op.isKeyword()) {
            return true;
        }
        if (arg instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)arg;
            if (binary.getOperator().getPrecedence() > op.getPrecedence()) {
                return this._spaceCalc(op, binary.getArg1());
            }
            return false;
        }
        if (arg instanceof JsPrefixOperation) {
            JsUnaryOperator op2 = ((JsPrefixOperation)arg).getOperator();
            return !((op != JsBinaryOperator.SUB && op != JsUnaryOperator.NEG || op2 != JsUnaryOperator.DEC && op2 != JsUnaryOperator.NEG) && (op != JsBinaryOperator.ADD && op != JsUnaryOperator.POS || op2 != JsUnaryOperator.INC && op2 != JsUnaryOperator.POS));
        }
        if (arg instanceof JsNumberLiteral) {
            JsNumberLiteral literal = (JsNumberLiteral)arg;
            return (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG) && literal.getValue() < 0.0;
        }
        return false;
    }

    private void _spaceOpt() {
        this.p.printOpt(' ');
    }

    private void _switch() {
        this.p.print(CHARS_SWITCH);
    }

    private void _this() {
        this.p.print(CHARS_THIS);
    }

    private void _throw() {
        this.p.print(CHARS_THROW);
    }

    private void _true() {
        this.p.print(CHARS_TRUE);
    }

    private void _try() {
        this.p.print(CHARS_TRY);
    }

    private void _var() {
        this.p.print(CHARS_VAR);
    }

    private void _while() {
        this.p.print(CHARS_WHILE);
    }

    private void indent() {
        this.p.indentIn();
    }

    private void outdent() {
        this.p.indentOut();
    }

    private void printStringLiteral(String value) {
        String resultString = StringUtils.javaScriptString(value);
        this.p.print(resultString);
    }
}

