/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.js.JsAbstractSymbolResolver;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsProgram;

public class JsSymbolResolver {
    private final JsProgram program;

    public static void exec(JsProgram program) {
        new JsSymbolResolver(program).execImpl();
    }

    private JsSymbolResolver(JsProgram program) {
        this.program = program;
    }

    private void execImpl() {
        JsResolveSymbolsVisitor resolver = new JsResolveSymbolsVisitor();
        resolver.accept(this.program);
    }

    private class JsResolveSymbolsVisitor
    extends JsAbstractSymbolResolver {
        private JsResolveSymbolsVisitor() {
        }

        @Override
        protected void resolveQualifiedName(JsNameRef x) {
            String ident = x.getIdent();
            JsName name = JsSymbolResolver.this.program.getObjectScope().findExistingName(ident);
            if (name == null) {
                name = JsSymbolResolver.this.program.getObjectScope().declareUnobfuscatableName(ident);
            } else if (name.isObfuscatable()) {
                name.setUnobfuscatable();
            }
            x.resolve(name);
        }

        @Override
        protected void resolveUnqualifiedName(JsNameRef x) {
            String ident = x.getIdent();
            JsName name = this.getScope().findExistingName(ident);
            if (name == null) {
                name = JsSymbolResolver.this.program.getScope().declareUnobfuscatableName(ident);
            }
            x.resolve(name);
        }
    }
}

