/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.CanBooleanEval;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsBooleanLiteral;
import com.google.gwt.dev.js.ast.JsBreak;
import com.google.gwt.dev.js.ast.JsConditional;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsContinue;
import com.google.gwt.dev.js.ast.JsDoWhile;
import com.google.gwt.dev.js.ast.JsEmpty;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFor;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsIf;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsUnaryOperator;
import com.google.gwt.dev.js.ast.JsValueLiteral;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.JsWhile;
import com.google.gwt.dev.js.rhino.ScriptRuntime;
import com.google.gwt.dev.util.Ieee754_64_Arithmetic;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsStaticEval {
    private static final String NAME = JsStaticEval.class.getSimpleName();
    private static final Set<JsBinaryOperator> REORDERABLE_OPERATORS = EnumSet.of(JsBinaryOperator.OR, JsBinaryOperator.AND, JsBinaryOperator.BIT_AND, JsBinaryOperator.BIT_OR, JsBinaryOperator.COMMA);
    private final JsProgram program;

    public static OptimizerStats exec(JsProgram program) {
        SpeedTracerLogger.Event optimizeJsEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE_JS, "optimizer", NAME);
        OptimizerStats stats = new JsStaticEval(program).execImpl();
        optimizeJsEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    protected static JsExpression shortCircuitAnd(JsBinaryOperation expr) {
        JsExpression arg1 = expr.getArg1();
        JsExpression arg2 = expr.getArg2();
        if (arg1 instanceof CanBooleanEval) {
            CanBooleanEval eval1 = (CanBooleanEval)((Object)arg1);
            if (eval1.isBooleanTrue() && !arg1.hasSideEffects()) {
                return arg2;
            }
            if (eval1.isBooleanFalse()) {
                return arg1;
            }
        }
        return expr;
    }

    protected static JsExpression shortCircuitOr(JsBinaryOperation expr) {
        JsExpression arg1 = expr.getArg1();
        JsExpression arg2 = expr.getArg2();
        if (arg1 instanceof CanBooleanEval) {
            CanBooleanEval eval1 = (CanBooleanEval)((Object)arg1);
            if (eval1.isBooleanTrue()) {
                return arg1;
            }
            if (eval1.isBooleanFalse() && !arg1.hasSideEffects()) {
                return arg2;
            }
        }
        return expr;
    }

    protected static JsExpression trySimplifyComma(JsBinaryOperation expr) {
        JsExpression arg1 = expr.getArg1();
        JsExpression arg2 = expr.getArg2();
        if (!arg1.hasSideEffects()) {
            return arg2;
        }
        return expr;
    }

    private static JsExpression simplifyEqAndRefEq(JsBinaryOperation expr) {
        JsExpression arg1 = expr.getArg1();
        JsExpression arg2 = expr.getArg2();
        if (arg1 instanceof JsNullLiteral) {
            return JsStaticEval.simplifyNullEq(expr, arg2);
        }
        if (arg2 instanceof JsNullLiteral) {
            return JsStaticEval.simplifyNullEq(expr, arg1);
        }
        if (arg1 instanceof JsNumberLiteral && arg2 instanceof JsNumberLiteral) {
            return JsBooleanLiteral.get(((JsNumberLiteral)arg1).getValue() == ((JsNumberLiteral)arg2).getValue());
        }
        if (arg1 instanceof JsStringLiteral && arg2 instanceof JsStringLiteral) {
            return JsBooleanLiteral.get(((JsStringLiteral)arg1).getValue().equals(((JsStringLiteral)arg2).getValue()));
        }
        return expr;
    }

    private static JsExpression simplifyNullEq(JsExpression original, JsExpression exp) {
        assert (original != null);
        if (exp instanceof JsValueLiteral) {
            boolean result = exp instanceof JsNullLiteral;
            return JsBooleanLiteral.get(result);
        }
        return original;
    }

    private static JsExpression simplifyNeAndRefNe(JsBinaryOperation expr) {
        JsExpression arg1 = expr.getArg1();
        JsExpression arg2 = expr.getArg2();
        JsExpression simplifiedEq = JsStaticEval.simplifyEqAndRefEq(expr);
        if (simplifiedEq == expr) {
            return expr;
        }
        assert (simplifiedEq instanceof JsBooleanLiteral);
        return JsBooleanLiteral.get(!((JsBooleanLiteral)simplifiedEq).getValue());
    }

    private static JsExpression simplifyOp(JsBinaryOperation expr) {
        SourceInfo info = expr.getSourceInfo();
        JsExpression arg1 = expr.getArg1();
        JsExpression arg2 = expr.getArg2();
        JsBinaryOperator op = expr.getOperator();
        if (op == JsBinaryOperator.ADD && (arg1 instanceof JsStringLiteral || arg2 instanceof JsStringLiteral)) {
            StringBuilder result = new StringBuilder();
            if (JsStaticEval.appendLiteral(result, (JsValueLiteral)arg1) && JsStaticEval.appendLiteral(result, (JsValueLiteral)arg2)) {
                return new JsStringLiteral(info, result.toString());
            }
            return expr;
        }
        if (arg1 instanceof JsNumberLiteral && arg2 instanceof JsNumberLiteral) {
            Constable result;
            double num1 = ((JsNumberLiteral)arg1).getValue();
            double num2 = ((JsNumberLiteral)arg2).getValue();
            switch (op) {
                case ADD: {
                    result = Double.valueOf(Ieee754_64_Arithmetic.add(num1, num2));
                    break;
                }
                case SUB: {
                    result = Double.valueOf(Ieee754_64_Arithmetic.subtract(num1, num2));
                    break;
                }
                case MUL: {
                    result = Double.valueOf(Ieee754_64_Arithmetic.multiply(num1, num2));
                    break;
                }
                case DIV: {
                    result = Double.valueOf(Ieee754_64_Arithmetic.divide(num1, num2));
                    break;
                }
                case MOD: {
                    result = Double.valueOf(Ieee754_64_Arithmetic.mod(num1, num2));
                    break;
                }
                case LT: {
                    result = Boolean.valueOf(Ieee754_64_Arithmetic.lt(num1, num2));
                    break;
                }
                case LTE: {
                    result = Boolean.valueOf(Ieee754_64_Arithmetic.le(num1, num2));
                    break;
                }
                case GT: {
                    result = Boolean.valueOf(Ieee754_64_Arithmetic.gt(num1, num2));
                    break;
                }
                case GTE: {
                    result = Boolean.valueOf(Ieee754_64_Arithmetic.ge(num1, num2));
                    break;
                }
                default: {
                    throw new InternalCompilerException("Can't handle simplify of op " + op);
                }
            }
            return result instanceof Double ? new JsNumberLiteral(info, (Double)result) : JsBooleanLiteral.get((Boolean)result);
        }
        return expr;
    }

    private static boolean appendLiteral(StringBuilder result, JsValueLiteral val) {
        if (val instanceof JsNumberLiteral) {
            double number = ((JsNumberLiteral)val).getValue();
            result.append(ScriptRuntime.numberToString(number, 10));
        } else if (val instanceof JsStringLiteral) {
            result.append(((JsStringLiteral)val).getValue());
        } else if (val instanceof JsBooleanLiteral) {
            result.append(((JsBooleanLiteral)val).getValue());
        } else if (val instanceof JsNullLiteral) {
            result.append("null");
        } else {
            return false;
        }
        return true;
    }

    private static JsExpression maybeReorderOperations(JsExpression x) {
        if (!(x instanceof JsBinaryOperation)) {
            return x;
        }
        JsBinaryOperation expr = (JsBinaryOperation)x;
        JsBinaryOperator outerOp = expr.getOperator();
        if (!REORDERABLE_OPERATORS.contains(outerOp)) {
            return expr;
        }
        if (!(expr.getArg2() instanceof JsBinaryOperation) || ((JsBinaryOperation)expr.getArg2()).getOperator() != outerOp) {
            return expr;
        }
        JsBinaryOperation leftExpr = (JsBinaryOperation)expr.getArg2();
        return new JsBinaryOperation(x.getSourceInfo(), leftExpr.getOperator(), JsStaticEval.maybeReorderOperations(new JsBinaryOperation(x.getSourceInfo(), outerOp, expr.getArg1(), leftExpr.getArg1())), leftExpr.getArg2());
    }

    public JsStaticEval(JsProgram program) {
        this.program = program;
    }

    public OptimizerStats execImpl() {
        StaticEvalVisitor sev = new StaticEvalVisitor();
        sev.accept(this.program);
        OptimizerStats stats = new OptimizerStats(NAME);
        if (sev.didChange()) {
            stats.recordModified();
        }
        return stats;
    }

    private class StaticEvalVisitor
    extends JsModVisitor {
        private Set<JsExpression> evalBooleanContext = new HashSet<JsExpression>();
        private Map<JsExpression, Boolean> coercesToStringMap = new IdentityHashMap<JsExpression, Boolean>();

        private StaticEvalVisitor() {
        }

        @Override
        public void endVisit(JsBinaryOperation x, JsContext ctx) {
            JsBinaryOperator op = x.getOperator();
            JsExpression arg1 = x.getArg1();
            JsExpression arg2 = x.getArg2();
            JsExpression result = x;
            if (op == JsBinaryOperator.AND) {
                result = JsStaticEval.shortCircuitAnd(x);
            } else if (op == JsBinaryOperator.OR) {
                result = JsStaticEval.shortCircuitOr(x);
            } else if (op == JsBinaryOperator.COMMA) {
                result = JsStaticEval.trySimplifyComma(x);
            } else if (op == JsBinaryOperator.EQ || op == JsBinaryOperator.REF_EQ) {
                result = JsStaticEval.simplifyEqAndRefEq(x);
            } else if (op == JsBinaryOperator.NEQ || op == JsBinaryOperator.REF_NEQ) {
                result = JsStaticEval.simplifyNeAndRefNe(x);
            } else if (arg1 instanceof JsValueLiteral && arg2 instanceof JsValueLiteral) {
                switch (op) {
                    case ADD: 
                    case SUB: 
                    case MUL: 
                    case DIV: 
                    case MOD: 
                    case GT: 
                    case GTE: 
                    case LT: 
                    case LTE: {
                        result = JsStaticEval.simplifyOp(x);
                        break;
                    }
                }
            }
            result = JsStaticEval.maybeReorderOperations(result);
            if (result != x) {
                ctx.replaceMe(result);
            }
        }

        @Override
        public void endVisit(JsBlock x, JsContext ctx) {
            List<JsStatement> stmts = x.getStatements();
            for (int i = 0; i < stmts.size(); ++i) {
                JsStatement stmt = stmts.get(i);
                if (stmt instanceof JsBlock) {
                    JsBlock block = (JsBlock)stmt;
                    stmts.remove(i);
                    stmts.addAll(i, block.getStatements());
                    --i;
                    this.didChange = true;
                    continue;
                }
                if (!stmt.unconditionalControlBreak()) continue;
                int j = i + 1;
                while (j < stmts.size()) {
                    JsStatement toRemove = stmts.get(j);
                    JsStatement toReplace = this.ensureDeclarations(toRemove);
                    if (toReplace == null) {
                        stmts.remove(j);
                        this.didChange = true;
                        continue;
                    }
                    if (toReplace == toRemove) {
                        ++j;
                        continue;
                    }
                    stmts.set(j, toReplace);
                    ++j;
                    this.didChange = true;
                }
            }
            if (ctx.canRemove() && stmts.size() == 0) {
                ctx.removeMe();
            }
        }

        @Override
        public void endVisit(JsConditional x, JsContext ctx) {
            this.evalBooleanContext.remove(x.getTestExpression());
            JsExpression condExpr = x.getTestExpression();
            JsExpression thenExpr = x.getThenExpression();
            JsExpression elseExpr = x.getElseExpression();
            if (condExpr instanceof CanBooleanEval) {
                CanBooleanEval condEval = (CanBooleanEval)((Object)condExpr);
                if (condEval.isBooleanTrue()) {
                    JsBinaryOperation binOp = new JsBinaryOperation(x.getSourceInfo(), JsBinaryOperator.AND, condExpr, thenExpr);
                    ctx.replaceMe(this.accept(binOp));
                } else if (condEval.isBooleanFalse()) {
                    JsBinaryOperation binOp = new JsBinaryOperation(x.getSourceInfo(), JsBinaryOperator.OR, condExpr, elseExpr);
                    ctx.replaceMe(this.accept(binOp));
                }
            }
        }

        @Override
        public void endVisit(JsDoWhile x, JsContext ctx) {
            CanBooleanEval cond;
            this.evalBooleanContext.remove(x.getCondition());
            JsExpression expr = x.getCondition();
            if (expr instanceof CanBooleanEval && (cond = (CanBooleanEval)((Object)expr)).isBooleanFalse()) {
                FindBreakContinueStatementsVisitor visitor = new FindBreakContinueStatementsVisitor();
                visitor.accept(x.getBody());
                if (!visitor.hasBreakContinueStatements()) {
                    JsBlock block = new JsBlock(x.getSourceInfo());
                    block.getStatements().add(x.getBody());
                    block.getStatements().add(expr.makeStmt());
                    ctx.replaceMe(this.accept(block));
                }
            }
        }

        @Override
        public void endVisit(JsExprStmt x, JsContext ctx) {
            if (!x.getExpression().hasSideEffects()) {
                if (ctx.canRemove()) {
                    ctx.removeMe();
                } else {
                    ctx.replaceMe(new JsEmpty(x.getSourceInfo()));
                }
            }
        }

        @Override
        public void endVisit(JsFor x, JsContext ctx) {
            CanBooleanEval cond;
            this.evalBooleanContext.remove(x.getCondition());
            JsExpression expr = x.getCondition();
            if (expr instanceof CanBooleanEval && (cond = (CanBooleanEval)((Object)expr)).isBooleanFalse()) {
                JsBlock block = new JsBlock(x.getSourceInfo());
                if (x.getInitExpr() != null) {
                    block.getStatements().add(x.getInitExpr().makeStmt());
                }
                if (x.getInitVars() != null) {
                    block.getStatements().add(x.getInitVars());
                }
                block.getStatements().add(expr.makeStmt());
                JsStatement decls = this.ensureDeclarations(x.getBody());
                if (decls != null) {
                    block.getStatements().add(decls);
                }
                ctx.replaceMe(this.accept(block));
            }
        }

        @Override
        public void endVisit(JsIf x, JsContext ctx) {
            this.evalBooleanContext.remove(x.getIfExpr());
            JsExpression condExpr = x.getIfExpr();
            if (condExpr instanceof CanBooleanEval && this.tryStaticEvalIf(x, (CanBooleanEval)((Object)condExpr), ctx)) {
                return;
            }
            JsStatement thenStmt = x.getThenStmt();
            JsStatement elseStmt = x.getElseStmt();
            boolean thenIsEmpty = JsUtils.isEmpty(thenStmt);
            boolean elseIsEmpty = JsUtils.isEmpty(elseStmt);
            JsExpression thenExpr = JsUtils.extractExpression(thenStmt);
            JsExpression elseExpr = JsUtils.extractExpression(elseStmt);
            if (thenIsEmpty && elseIsEmpty) {
                ctx.replaceMe(condExpr.makeStmt());
            } else if (thenExpr != null && elseExpr != null) {
                JsConditional cond = new JsConditional(x.getSourceInfo(), x.getIfExpr(), thenExpr, elseExpr);
                ctx.replaceMe(this.accept(cond.makeStmt()));
            } else if (thenIsEmpty && elseExpr != null) {
                JsBinaryOperation op = new JsBinaryOperation(x.getSourceInfo(), JsBinaryOperator.OR, x.getIfExpr(), elseExpr);
                ctx.replaceMe(this.accept(op.makeStmt()));
            } else if (thenIsEmpty && !elseIsEmpty) {
                JsPrefixOperation negatedOperation = new JsPrefixOperation(x.getSourceInfo(), JsUnaryOperator.NOT, x.getIfExpr());
                JsIf newIf = new JsIf(x.getSourceInfo(), negatedOperation, elseStmt, null);
                ctx.replaceMe(this.accept(newIf));
            } else if (elseIsEmpty && thenExpr != null) {
                JsBinaryOperation op = new JsBinaryOperation(x.getSourceInfo(), JsBinaryOperator.AND, x.getIfExpr(), thenExpr);
                ctx.replaceMe(this.accept(op.makeStmt()));
            } else if (elseIsEmpty && elseStmt != null) {
                JsIf newIf = new JsIf(x.getSourceInfo(), x.getIfExpr(), thenStmt, null);
                ctx.replaceMe(this.accept(newIf));
            }
        }

        @Override
        public void endVisit(JsPrefixOperation x, JsContext ctx) {
            JsPrefixOperation arg;
            if (x.getOperator() == JsUnaryOperator.NOT) {
                this.evalBooleanContext.remove(x.getArg());
            }
            if (this.evalBooleanContext.contains(x) && x.getOperator() == JsUnaryOperator.NOT && x.getArg() instanceof JsPrefixOperation && (arg = (JsPrefixOperation)x.getArg()).getOperator() == JsUnaryOperator.NOT) {
                ctx.replaceMe(arg.getArg());
                return;
            }
        }

        @Override
        public void endVisit(JsWhile x, JsContext ctx) {
            CanBooleanEval cond;
            this.evalBooleanContext.remove(x.getCondition());
            JsExpression expr = x.getCondition();
            if (expr instanceof CanBooleanEval && (cond = (CanBooleanEval)((Object)expr)).isBooleanFalse()) {
                JsBlock block = new JsBlock(x.getSourceInfo());
                block.getStatements().add(expr.makeStmt());
                JsStatement decls = this.ensureDeclarations(x.getBody());
                if (decls != null) {
                    block.getStatements().add(decls);
                }
                ctx.replaceMe(this.accept(block));
            }
        }

        @Override
        public boolean visit(JsConditional x, JsContext ctx) {
            this.evalBooleanContext.add(x.getTestExpression());
            return true;
        }

        @Override
        public boolean visit(JsDoWhile x, JsContext ctx) {
            this.evalBooleanContext.add(x.getCondition());
            return true;
        }

        @Override
        public boolean visit(JsFor x, JsContext ctx) {
            this.evalBooleanContext.add(x.getCondition());
            return true;
        }

        @Override
        public boolean visit(JsIf x, JsContext ctx) {
            this.evalBooleanContext.add(x.getIfExpr());
            return true;
        }

        @Override
        public boolean visit(JsPrefixOperation x, JsContext ctx) {
            if (x.getOperator() == JsUnaryOperator.NOT) {
                this.evalBooleanContext.add(x.getArg());
            }
            return true;
        }

        @Override
        public boolean visit(JsWhile x, JsContext ctx) {
            this.evalBooleanContext.add(x.getCondition());
            return true;
        }

        private boolean additionCoercesToString(JsExpression expr) {
            if (expr instanceof JsStringLiteral) {
                return true;
            }
            Boolean toReturn = this.coercesToStringMap.get(expr);
            if (toReturn != null) {
                return toReturn;
            }
            toReturn = false;
            if (expr instanceof JsBinaryOperation) {
                JsBinaryOperation op = (JsBinaryOperation)expr;
                switch (op.getOperator()) {
                    case ADD: {
                        toReturn = this.additionCoercesToString(op.getArg1()) || this.additionCoercesToString(op.getArg2());
                        break;
                    }
                    case COMMA: {
                        toReturn = this.additionCoercesToString(op.getArg2());
                    }
                }
                if (op.getOperator().isAssignment()) {
                    toReturn = this.additionCoercesToString(op.getArg2());
                }
            }
            this.coercesToStringMap.put(expr, toReturn);
            return toReturn;
        }

        private JsStatement ensureDeclarations(JsStatement stmt) {
            if (stmt == null) {
                return null;
            }
            MustExecVisitor mev = new MustExecVisitor();
            mev.accept(stmt);
            List<JsStatement> stmts = mev.getStatements();
            if (stmts.isEmpty()) {
                return null;
            }
            if (stmts.size() == 1) {
                return stmts.get(0);
            }
            JsBlock jsBlock = new JsBlock(stmt.getSourceInfo());
            jsBlock.getStatements().addAll(stmts);
            return jsBlock;
        }

        private boolean tryStaticEvalIf(JsIf x, CanBooleanEval cond, JsContext ctx) {
            JsStatement thenStmt = x.getThenStmt();
            JsStatement elseStmt = x.getElseStmt();
            if (cond.isBooleanTrue()) {
                JsStatement decls;
                JsBlock block = new JsBlock(x.getSourceInfo());
                block.getStatements().add(x.getIfExpr().makeStmt());
                if (thenStmt != null) {
                    block.getStatements().add(thenStmt);
                }
                if ((decls = this.ensureDeclarations(elseStmt)) != null) {
                    block.getStatements().add(decls);
                }
                ctx.replaceMe(this.accept(block));
                return true;
            }
            if (cond.isBooleanFalse()) {
                JsStatement decls;
                JsBlock block = new JsBlock(x.getSourceInfo());
                block.getStatements().add(x.getIfExpr().makeStmt());
                if (elseStmt != null) {
                    block.getStatements().add(elseStmt);
                }
                if ((decls = this.ensureDeclarations(thenStmt)) != null) {
                    block.getStatements().add(decls);
                }
                ctx.replaceMe(this.accept(block));
                return true;
            }
            return false;
        }
    }

    private static class MustExecVisitor
    extends JsVisitor {
        private final List<JsStatement> mustExec = new ArrayList<JsStatement>();

        @Override
        public void endVisit(JsExprStmt x, JsContext ctx) {
            JsFunction func = JsUtils.isFunctionDeclaration(x);
            if (func != null) {
                this.mustExec.add(x);
            }
        }

        @Override
        public void endVisit(JsVars x, JsContext ctx) {
            JsVars strippedVars = new JsVars(x.getSourceInfo(), new JsVars.JsVar[0]);
            boolean mustReplace = false;
            for (JsVars.JsVar var : x) {
                JsVars.JsVar strippedVar = new JsVars.JsVar(var.getSourceInfo(), var.getName());
                strippedVars.add(strippedVar);
                if (var.getInitExpr() == null) continue;
                mustReplace = true;
            }
            if (mustReplace) {
                this.mustExec.add(strippedVars);
            } else {
                this.mustExec.add(x);
            }
        }

        public List<JsStatement> getStatements() {
            return this.mustExec;
        }

        @Override
        public boolean visit(JsFunction x, JsContext ctx) {
            return false;
        }
    }

    public static class FindBreakContinueStatementsVisitor
    extends JsVisitor {
        private boolean hasBreakContinueStatements = false;

        @Override
        public void endVisit(JsBreak x, JsContext ctx) {
            this.hasBreakContinueStatements = true;
        }

        @Override
        public void endVisit(JsContinue x, JsContext ctx) {
            this.hasBreakContinueStatements = true;
        }

        protected boolean hasBreakContinueStatements() {
            return this.hasBreakContinueStatements;
        }
    }
}

