/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.cfg.PermutationProperties;
import com.google.gwt.dev.jjs.HasSourceInfo;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.HasArguments;
import com.google.gwt.dev.js.ast.HasName;
import com.google.gwt.dev.js.ast.JsArrayAccess;
import com.google.gwt.dev.js.ast.JsArrayLiteral;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsBooleanLiteral;
import com.google.gwt.dev.js.ast.JsCatch;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFor;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNew;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsPostfixOperation;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsPropertyInitializer;
import com.google.gwt.dev.js.ast.JsReturn;
import com.google.gwt.dev.js.ast.JsRootScope;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsThrow;
import com.google.gwt.dev.js.ast.JsTry;
import com.google.gwt.dev.js.ast.JsUnaryOperator;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.js.ast.JsWhile;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.collect.Maps;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JsStackEmulator {
    private JsName wrapFunctionName;
    private JsName unwrapFunctionName;
    private JsName lineNumbers;
    private JProgram jprogram;
    private final JsProgram jsProgram;
    private JavaToJavaScriptMap jjsmap;
    private final boolean recordFileNames;
    private final boolean recordLineNumbers;
    private JsName stack;
    private JsName stackDepth;
    private JsName tmp;
    private JDeclaredType exceptionsClass;

    private boolean isExceptionWrappingCode(JsExprStmt x) {
        JsExpression expr = x.getExpression();
        if (!(expr instanceof JsBinaryOperation)) {
            return false;
        }
        JsBinaryOperation op = (JsBinaryOperation)expr;
        if (!(op.getArg2() instanceof JsInvocation)) {
            return false;
        }
        JsInvocation i = (JsInvocation)op.getArg2();
        JsExpression q = i.getQualifier();
        if (!(q instanceof JsNameRef)) {
            return false;
        }
        JsName name = ((JsNameRef)q).getName();
        if (name == null) {
            return false;
        }
        return name == this.wrapFunctionName;
    }

    public static void exec(JProgram jprogram, JsProgram jsProgram, PermutationProperties properties, JavaToJavaScriptMap jjsmap) {
        if (JsStackEmulator.getStackMode(properties) == StackMode.EMULATED) {
            new JsStackEmulator(jprogram, jsProgram, jjsmap, properties.getConfigurationProperties()).execImpl();
        }
    }

    public static StackMode getStackMode(PermutationProperties properties) {
        String value = properties.mustGetString("compiler.stackMode");
        return StackMode.valueOf(value.toUpperCase(Locale.ROOT));
    }

    private JsStackEmulator(JProgram jprogram, JsProgram jsProgram, JavaToJavaScriptMap jjsmap, ConfigurationProperties config) {
        this.jprogram = jprogram;
        this.jsProgram = jsProgram;
        this.jjsmap = jjsmap;
        this.exceptionsClass = jprogram.getFromTypeMap("com.google.gwt.lang.Exceptions");
        this.recordFileNames = config.getBoolean("compiler.emulatedStack.recordFileNames", false);
        this.recordLineNumbers = this.recordFileNames || config.getBoolean("compiler.emulatedStack.recordLineNumbers", false);
    }

    private boolean shouldInstrumentFunction(JsExpression functionExpression) {
        if (!(functionExpression instanceof HasName)) {
            return true;
        }
        JMethod method = this.jjsmap.nameToMethod(((HasName)((Object)functionExpression)).getName());
        return method == null || method.getEnclosingType() != this.exceptionsClass || this.jprogram.immortalCodeGenTypes.contains(method.getEnclosingType());
    }

    private void execImpl() {
        this.wrapFunctionName = JsUtils.getJsNameForMethod(this.jjsmap, this.jprogram, "Exceptions.toJava");
        this.unwrapFunctionName = JsUtils.getJsNameForMethod(this.jjsmap, this.jprogram, "Exceptions.toJs");
        if (this.wrapFunctionName == null) {
            return;
        }
        assert (this.unwrapFunctionName != null);
        this.initNames();
        this.makeVars();
        new ReplaceUnobfuscatableNames().accept(this.jsProgram);
        new InstrumentAllFunctions().accept(this.jsProgram);
    }

    private void initNames() {
        this.stack = this.jsProgram.getScope().declareName("$JsStackEmulator_stack", "$stack");
        this.stackDepth = this.jsProgram.getScope().declareName("$JsStackEmulator_stackDepth", "$stackDepth");
        this.lineNumbers = this.jsProgram.getScope().declareName("$JsStackEmulator_location", "$location");
        this.tmp = this.jsProgram.getScope().declareName("$JsStackEmulator_tmp", "$tmp");
    }

    private void makeVars() {
        JsVars vars;
        SourceInfo info = this.jsProgram.createSourceInfoSynthetic(this.getClass());
        JsVars.JsVar stackVar = new JsVars.JsVar(info, this.stack);
        stackVar.setInitExpr(new JsArrayLiteral(info, new JsExpression[0]));
        JsVars.JsVar stackDepthVar = new JsVars.JsVar(info, this.stackDepth);
        stackDepthVar.setInitExpr(new JsNumberLiteral(info, -1.0));
        JsVars.JsVar lineNumbersVar = new JsVars.JsVar(info, this.lineNumbers);
        lineNumbersVar.setInitExpr(new JsArrayLiteral(info, new JsExpression[0]));
        JsVars.JsVar tmpVar = new JsVars.JsVar(info, this.tmp);
        JsStatement first = this.jsProgram.getGlobalBlock().getStatements().get(0);
        if (first instanceof JsVars) {
            vars = (JsVars)first;
        } else {
            vars = new JsVars(info, new JsVars.JsVar[0]);
            this.jsProgram.getGlobalBlock().getStatements().add(0, vars);
        }
        vars.add(stackVar);
        vars.add(stackDepthVar);
        vars.add(lineNumbersVar);
        vars.add(tmpVar);
    }

    public static enum StackMode {
        STRIP,
        NATIVE,
        EMULATED;

    }

    private class ReplaceUnobfuscatableNames
    extends JsModVisitor {
        private final JsName rootLineNumbers = JsRootScope.INSTANCE.findExistingUnobfuscatableName("$location");
        private final JsName rootStack = JsRootScope.INSTANCE.findExistingUnobfuscatableName("$stack");
        private final JsName rootStackDepth = JsRootScope.INSTANCE.findExistingUnobfuscatableName("$stackDepth");

        private ReplaceUnobfuscatableNames() {
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            JsName name = x.getName();
            JsNameRef newRef = null;
            if (name == this.rootStack) {
                newRef = JsStackEmulator.this.stack.makeRef(x.getSourceInfo());
            } else if (name == this.rootStackDepth) {
                newRef = JsStackEmulator.this.stackDepth.makeRef(x.getSourceInfo());
            } else if (name == this.rootLineNumbers) {
                newRef = JsStackEmulator.this.lineNumbers.makeRef(x.getSourceInfo());
            }
            if (newRef == null) {
                return;
            }
            assert (x.getQualifier() == null);
            ctx.replaceMe(newRef);
        }
    }

    private class LocationVisitor
    extends EntryExitVisitor {
        private String lastFile;
        private int lastLine;
        private final Set<JsNode> nodesInRefContext;

        public LocationVisitor(JsFunction function) {
            super(function);
            this.nodesInRefContext = new HashSet<JsNode>();
            this.clearLocation();
        }

        @Override
        public void endVisit(JsArrayAccess x, JsContext ctx) {
            this.record(x, ctx);
        }

        @Override
        public void endVisit(JsBinaryOperation x, JsContext ctx) {
            if (x.getOperator().isAssignment()) {
                this.record(x, ctx);
            }
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            this.nodesInRefContext.remove(x.getQualifier());
            List<JsExpression> args = x.getArguments();
            if (!args.isEmpty()) {
                this.recordAfterLastArg(x);
                return;
            }
            JsNameRef qualifier = this.getPossibleMethod(x);
            if (qualifier == null) {
                this.record(x, ctx);
                return;
            }
            SourceInfo locationToRecord = x.getSourceInfo();
            if (this.sameAsLastLocation(locationToRecord)) {
                return;
            }
            qualifier.setQualifier(this.recordAfter(qualifier.getQualifier(), locationToRecord));
            this.setLastLocation(locationToRecord);
            this.didChange = true;
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            this.record(x, ctx);
        }

        @Override
        public void endVisit(JsNew x, JsContext ctx) {
            this.nodesInRefContext.remove(x.getConstructorExpression());
            if (!x.getArguments().isEmpty()) {
                this.recordAfterLastArg(x);
            } else {
                this.record(x, ctx);
            }
        }

        @Override
        public void endVisit(JsPostfixOperation x, JsContext ctx) {
            this.record(x, ctx);
        }

        @Override
        public void endVisit(JsPrefixOperation x, JsContext ctx) {
            this.record(x, ctx);
            this.nodesInRefContext.remove(x.getArg());
        }

        @Override
        public boolean visit(JsExprStmt x, JsContext ctx) {
            return !JsStackEmulator.this.isExceptionWrappingCode(x);
        }

        @Override
        public boolean visit(JsFor x, JsContext ctx) {
            if (x.getInitExpr() != null) {
                x.setInitExpr(this.accept(x.getInitExpr()));
            } else if (x.getInitVars() != null) {
                x.setInitVars(this.accept(x.getInitVars()));
            }
            if (x.getCondition() != null) {
                this.clearLocation();
                x.setCondition(this.accept(x.getCondition()));
            }
            if (x.getIncrExpr() != null) {
                this.clearLocation();
                x.setIncrExpr(this.accept(x.getIncrExpr()));
            }
            this.accept(x.getBody());
            return false;
        }

        @Override
        public boolean visit(JsInvocation x, JsContext ctx) {
            this.nodesInRefContext.add(x.getQualifier());
            return true;
        }

        @Override
        public boolean visit(JsNew x, JsContext ctx) {
            this.nodesInRefContext.add(x.getConstructorExpression());
            return true;
        }

        @Override
        public boolean visit(JsPrefixOperation x, JsContext ctx) {
            if (x.getOperator() == JsUnaryOperator.DELETE || x.getOperator() == JsUnaryOperator.TYPEOF) {
                this.nodesInRefContext.add(x.getArg());
            }
            return true;
        }

        @Override
        public boolean visit(JsPropertyInitializer x, JsContext ctx) {
            x.setValueExpr(this.accept(x.getValueExpr()));
            return false;
        }

        @Override
        public boolean visit(JsWhile x, JsContext ctx) {
            this.clearLocation();
            x.setCondition(this.accept(x.getCondition()));
            this.accept(x.getBody());
            return false;
        }

        private JsNameRef getPossibleMethod(JsInvocation x) {
            if (!(x.getQualifier() instanceof JsNameRef)) {
                return null;
            }
            JsNameRef ref = (JsNameRef)x.getQualifier();
            if (ref.getQualifier() == null) {
                return null;
            }
            return ref;
        }

        private String baseName(String fileName) {
            int lastIndex = fileName.lastIndexOf(File.separator);
            if (lastIndex == -1) {
                lastIndex = fileName.lastIndexOf(47);
            }
            if (lastIndex != -1) {
                return fileName.substring(lastIndex + 1);
            }
            return fileName;
        }

        private void record(JsExpression x, JsContext ctx) {
            if (ctx.isLvalue()) {
                return;
            }
            if (this.nodesInRefContext.contains(x)) {
                return;
            }
            SourceInfo locationToRecord = x.getSourceInfo();
            if (this.sameAsLastLocation(locationToRecord)) {
                return;
            }
            JsBinaryOperation comma = new JsBinaryOperation(locationToRecord, JsBinaryOperator.COMMA, this.assignLocation(locationToRecord), x);
            ctx.replaceMe(comma);
            this.setLastLocation(locationToRecord);
        }

        private <T extends JsExpression> void recordAfterLastArg(T x) {
            SourceInfo locationToRecord = x.getSourceInfo();
            if (this.sameAsLastLocation(locationToRecord)) {
                return;
            }
            List<JsExpression> args = ((HasArguments)((Object)x)).getArguments();
            JsExpression last = args.get(args.size() - 1);
            args.set(args.size() - 1, this.recordAfter(last, locationToRecord));
            this.setLastLocation(locationToRecord);
            this.didChange = true;
        }

        private void setLastLocation(SourceInfo recordedLocation) {
            this.lastLine = recordedLocation.getStartLine();
            if (JsStackEmulator.this.recordFileNames) {
                this.lastFile = recordedLocation.getFileName();
            }
        }

        private void clearLocation() {
            this.lastFile = "";
            this.lastLine = -1;
        }

        private boolean sameAsLastLocation(SourceInfo info) {
            return info.getStartLine() == this.lastLine && (!JsStackEmulator.this.recordFileNames || info.getFileName().equals(this.lastFile));
        }

        private JsExpression recordAfter(JsExpression x, SourceInfo locationToRecord) {
            SourceInfo info = x.getSourceInfo();
            JsBinaryOperation setTmp = new JsBinaryOperation(info, JsBinaryOperator.ASG, JsStackEmulator.this.tmp.makeRef(info), x);
            return new JsBinaryOperation(info, JsBinaryOperator.COMMA, new JsBinaryOperation(info, JsBinaryOperator.COMMA, setTmp, this.assignLocation(locationToRecord)), JsStackEmulator.this.tmp.makeRef(info));
        }

        private JsExpression assignLocation(SourceInfo info) {
            JsExpression location = new JsStringLiteral(info, String.valueOf(info.getStartLine()));
            if (JsStackEmulator.this.recordFileNames) {
                JsStringLiteral stringLit = new JsStringLiteral(info, this.baseName(info.getFileName()) + ":");
                location = new JsBinaryOperation(info, JsBinaryOperator.ADD, stringLit, location);
            }
            JsArrayAccess access = new JsArrayAccess(info, JsStackEmulator.this.lineNumbers.makeRef(info), this.stackIndexRef(info));
            return new JsBinaryOperation(info, JsBinaryOperator.ASG, access, location);
        }
    }

    private class InstrumentAllFunctions
    extends JsVisitor {
        private InstrumentAllFunctions() {
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            if (x.getBody().getStatements().isEmpty() || !JsStackEmulator.this.shouldInstrumentFunction(x)) {
                return;
            }
            if (JsStackEmulator.this.recordLineNumbers) {
                new LocationVisitor(x).accept(x.getBody());
            } else {
                new EntryExitVisitor(x).accept(x.getBody());
            }
        }
    }

    private class EntryExitVisitor
    extends JsModVisitor {
        protected JsName stackIndex;
        private final JsFunction currentFunction;
        private Map<JsBlock, JsName> finallyBlocksToExitVariables = Maps.create();
        private JsBlock outerFinallyBlock;
        private JsName returnTemp;
        private List<JsVars.JsVar> varsToAdd = Lists.create();

        public EntryExitVisitor(JsFunction currentFunction) {
            this.currentFunction = currentFunction;
        }

        @Override
        public void endVisit(JsBlock x, JsContext ctx) {
            if (x == this.currentFunction.getBody()) {
                JsVars vars;
                List<JsStatement> statements = x.getStatements();
                int idx = statements.isEmpty() || !(statements.get(0) instanceof JsVars) ? 0 : 1;
                statements.add(idx, this.push(this.currentFunction));
                this.addPopAtEndOfBlock(x, false);
                if (statements.get(0) instanceof JsVars) {
                    vars = (JsVars)statements.get(0);
                } else {
                    vars = new JsVars(this.currentFunction.getSourceInfo(), new JsVars.JsVar[0]);
                    statements.add(0, vars);
                }
                for (JsVars.JsVar var : this.varsToAdd) {
                    vars.add(var);
                }
            }
        }

        @Override
        public void endVisit(JsReturn x, JsContext ctx) {
            if (this.outerFinallyBlock != null) {
                JsBinaryOperation asg = new JsBinaryOperation(x.getSourceInfo(), JsBinaryOperator.ASG, this.earlyExitRef(this.outerFinallyBlock), JsBooleanLiteral.get(true));
                if (x.getExpr() == null) {
                    if (ctx.canInsert()) {
                        ctx.insertBefore(asg.makeStmt());
                    } else {
                        JsBlock block = new JsBlock(x.getSourceInfo());
                        block.getStatements().add(asg.makeStmt());
                        block.getStatements().add(x);
                        ctx.replaceMe(block);
                    }
                } else {
                    JsBinaryOperation op = new JsBinaryOperation(x.getSourceInfo(), JsBinaryOperator.COMMA, asg, x.getExpr());
                    x.setExpr(op);
                }
            } else if (x.getExpr() != null && x.getExpr().hasSideEffects()) {
                SourceInfo info = x.getSourceInfo();
                JsBinaryOperation asg = new JsBinaryOperation(info, JsBinaryOperator.ASG, this.returnTempRef(info), x.getExpr());
                x.setExpr(this.returnTempRef(info));
                this.pop(x, asg, ctx);
            } else {
                this.pop(x, null, ctx);
            }
        }

        @Override
        public boolean visit(JsCatch x, JsContext ctx) {
            new CatchStackReset(this).accept(x);
            return true;
        }

        @Override
        public boolean visit(JsFunction x, JsContext ctx) {
            return false;
        }

        @Override
        public boolean visit(JsTry x, JsContext ctx) {
            JsBlock finallyBlock = x.getFinallyBlock();
            if (finallyBlock != null && this.outerFinallyBlock == null) {
                this.outerFinallyBlock = finallyBlock;
                this.accept(x.getTryBlock());
                if (x.getCatches().isEmpty()) {
                    JsCatch c = this.makeSyntheticCatchBlock(x);
                    x.getCatches().add(c);
                }
                assert (x.getCatches().size() >= 1);
                this.acceptList(x.getCatches());
                assert (this.outerFinallyBlock == finallyBlock);
                this.outerFinallyBlock = null;
                this.accept(finallyBlock);
                this.addPopAtEndOfBlock(finallyBlock, true);
                this.finallyBlocksToExitVariables = Maps.remove(this.finallyBlocksToExitVariables, finallyBlock);
                return false;
            }
            return true;
        }

        protected JsNameRef stackIndexRef(SourceInfo info) {
            if (this.stackIndex == null) {
                this.stackIndex = this.currentFunction.getScope().declareName("JsStackEmulator_stackIndex", "stackIndex");
                JsVars.JsVar var = new JsVars.JsVar(info, this.stackIndex);
                this.varsToAdd = Lists.add(this.varsToAdd, var);
            }
            return this.stackIndex.makeRef(info);
        }

        private void addPopAtEndOfBlock(JsBlock x, boolean checkEarlyExit) {
            JsStatement last;
            JsStatement jsStatement = last = x.getStatements().isEmpty() ? null : x.getStatements().get(x.getStatements().size() - 1);
            if (last instanceof JsReturn || last instanceof JsThrow) {
                return;
            }
            if (checkEarlyExit && !this.finallyBlocksToExitVariables.containsKey(x)) {
                return;
            }
            SourceInfo info = x.getSourceInfo();
            JsExpression op = this.pop(info);
            if (checkEarlyExit) {
                op = new JsBinaryOperation(info, JsBinaryOperator.AND, this.earlyExitRef(x), op);
            }
            x.getStatements().add(op.makeStmt());
        }

        private JsNameRef earlyExitRef(JsBlock x) {
            JsName earlyExitName = this.finallyBlocksToExitVariables.get(x);
            if (earlyExitName == null) {
                earlyExitName = this.currentFunction.getScope().declareName("JsStackEmulator_exitingEarly" + this.finallyBlocksToExitVariables.size(), "exitingEarly");
                this.finallyBlocksToExitVariables = Maps.put(this.finallyBlocksToExitVariables, x, earlyExitName);
                JsVars.JsVar var = new JsVars.JsVar(x.getSourceInfo(), earlyExitName);
                this.varsToAdd = Lists.add(this.varsToAdd, var);
            }
            return earlyExitName.makeRef(x.getSourceInfo());
        }

        private JsCatch makeSyntheticCatchBlock(JsTry x) {
            SourceInfo info = x.getSourceInfo();
            JsCatch c = new JsCatch(info, this.currentFunction.getScope(), "e");
            JsName paramName = c.getParameter().getName();
            JsInvocation wrapCall = new JsInvocation(info, (JsExpression)JsStackEmulator.this.wrapFunctionName.makeRef(info), paramName.makeRef(info));
            JsBinaryOperation asg = new JsBinaryOperation(info, JsBinaryOperator.ASG, paramName.makeRef(info), wrapCall);
            JsInvocation unwrapCall = new JsInvocation(info, (JsExpression)JsStackEmulator.this.unwrapFunctionName.makeRef(info), paramName.makeRef(info));
            JsThrow throwStatement = new JsThrow(info, unwrapCall);
            JsBlock body = new JsBlock(info);
            body.getStatements().add(asg.makeStmt());
            body.getStatements().add(throwStatement);
            c.setBody(body);
            return c;
        }

        private void pop(JsStatement x, JsExpression expr, JsContext ctx) {
            SourceInfo info = x.getSourceInfo();
            JsExpression op = this.pop(info);
            if (ctx.canInsert()) {
                if (expr != null) {
                    ctx.insertBefore(expr.makeStmt());
                }
                ctx.insertBefore(op.makeStmt());
            } else {
                JsBlock block = new JsBlock(info);
                if (expr != null) {
                    block.getStatements().add(expr.makeStmt());
                }
                block.getStatements().add(op.makeStmt());
                block.getStatements().add(x);
                ctx.replaceMe(block);
            }
        }

        private JsExpression pop(SourceInfo info) {
            JsBinaryOperation sub = new JsBinaryOperation(info, JsBinaryOperator.SUB, this.stackIndexRef(info), new JsNumberLiteral(info, 1.0));
            JsBinaryOperation op = new JsBinaryOperation(info, JsBinaryOperator.ASG, JsStackEmulator.this.stackDepth.makeRef(info), sub);
            return op;
        }

        private JsStatement push(HasSourceInfo x) {
            SourceInfo info = x.getSourceInfo();
            JsNameRef stackRef = JsStackEmulator.this.stack.makeRef(info);
            JsNameRef stackDepthRef = JsStackEmulator.this.stackDepth.makeRef(info);
            JsExpression currentFunctionRef = this.currentFunction.getName() == null ? JsNullLiteral.INSTANCE : this.currentFunction.getName().makeRef(info);
            JsPrefixOperation inc = new JsPrefixOperation(info, JsUnaryOperator.INC, stackDepthRef);
            JsBinaryOperation stackIndexOp = new JsBinaryOperation(info, JsBinaryOperator.ASG, this.stackIndexRef(info), inc);
            JsArrayAccess access = new JsArrayAccess(info, stackRef, stackIndexOp);
            JsBinaryOperation op = new JsBinaryOperation(info, JsBinaryOperator.ASG, access, currentFunctionRef);
            return op.makeStmt();
        }

        private JsNameRef returnTempRef(SourceInfo info) {
            if (this.returnTemp == null) {
                this.returnTemp = this.currentFunction.getScope().declareName("JsStackEmulator_returnTemp", "returnTemp");
                JsVars.JsVar var = new JsVars.JsVar(info, this.returnTemp);
                this.varsToAdd = Lists.add(this.varsToAdd, var);
            }
            return this.returnTemp.makeRef(info);
        }
    }

    private class CatchStackReset
    extends JsModVisitor {
        private final EntryExitVisitor eeVisitor;

        public CatchStackReset(EntryExitVisitor eeVisitor) {
            this.eeVisitor = eeVisitor;
        }

        @Override
        public void endVisit(JsExprStmt x, JsContext ctx) {
            if (!JsStackEmulator.this.isExceptionWrappingCode(x)) {
                return;
            }
            SourceInfo info = x.getSourceInfo();
            JsBinaryOperation reset = new JsBinaryOperation(info, JsBinaryOperator.ASG, JsStackEmulator.this.stackDepth.makeRef(info), this.eeVisitor.stackIndexRef(info));
            ctx.insertAfter(reset.makeStmt());
        }
    }
}

