/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.JsSourceGenerationVisitor;
import com.google.gwt.dev.js.SizeBreakdown;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitable;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.dev.util.collect.HashMap;
import java.util.Map;

public class JsSourceGenerationVisitorWithSizeBreakdown
extends JsSourceGenerationVisitor {
    private JavaToJavaScriptMap map;
    private JsName billedAncestor;
    private TextOutput out;
    private final Map<JsName, Integer> sizeMap = new HashMap<JsName, Integer>();

    public JsSourceGenerationVisitorWithSizeBreakdown(TextOutput out, JavaToJavaScriptMap javaToJavaScriptMap) {
        super(out);
        this.out = out;
        this.map = javaToJavaScriptMap;
    }

    public SizeBreakdown getSizeBreakdown() {
        return new SizeBreakdown(this.out.getPosition(), this.sizeMap);
    }

    public JsSourceMap getSourceInfoMap() {
        return null;
    }

    @Override
    protected final <T extends JsVisitable> T doAccept(T node) {
        JsName newName = this.nameToBillTo(node, this.billedAncestor != null);
        return this.generateAndBill(node, newName);
    }

    protected <T extends JsVisitable> T generateAndBill(T node, JsName nameToBillTo) {
        if (nameToBillTo == null) {
            return super.doAccept(node);
        }
        int start = this.out.getPosition();
        JsName savedAncestor = this.billedAncestor;
        this.billedAncestor = nameToBillTo;
        T retValue = super.doAccept(node);
        this.billedAncestor = savedAncestor;
        this.billChars(nameToBillTo, this.out.getPosition() - start);
        return retValue;
    }

    private void billChars(JsName nameToBillTo, int chars) {
        Integer oldSize = this.sizeMap.get(nameToBillTo);
        if (oldSize == null) {
            oldSize = 0;
        }
        this.sizeMap.put(nameToBillTo, oldSize + chars);
    }

    private JsName nameToBillTo(JsVisitable node, boolean isAncestorBilled) {
        if (node instanceof JsStatement) {
            JsStatement statement = (JsStatement)node;
            JDeclaredType type = this.map.typeForStatement(statement);
            if (type != null) {
                return this.map.nameForType(type);
            }
            JMethod method = this.map.methodForStatement(statement);
            if (method != null) {
                return this.map.nameForMethod(method);
            }
            return null;
        }
        if (node instanceof JsVars.JsVar) {
            return isAncestorBilled ? null : ((JsVars.JsVar)node).getName();
        }
        return null;
    }
}

