/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.js.ast.JsArrayAccess;
import com.google.gwt.dev.js.ast.JsArrayLiteral;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBooleanLiteral;
import com.google.gwt.dev.js.ast.JsConditional;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsNameOf;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNew;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsNumericEntry;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsPostfixOperation;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsPropertyInitializer;
import com.google.gwt.dev.js.ast.JsRegExp;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsThisRef;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.util.collect.Stack;
import java.util.ArrayList;
import java.util.List;

public final class JsSafeCloner {
    public static JsExpression clone(JsExpression expression) {
        if (expression == null) {
            return null;
        }
        Cloner c = new Cloner();
        c.accept(expression);
        return c.getExpression();
    }

    private JsSafeCloner() {
    }

    public static class Cloner
    extends JsVisitor {
        protected final Stack<JsExpression> stack = new Stack();
        private boolean successful = true;

        @Override
        public void endVisit(JsArrayAccess x, JsContext ctx) {
            JsArrayAccess newExpression = new JsArrayAccess(x.getSourceInfo());
            newExpression.setIndexExpr(this.stack.pop());
            newExpression.setArrayExpr(this.stack.pop());
            this.stack.push(newExpression);
        }

        @Override
        public void endVisit(JsArrayLiteral x, JsContext ctx) {
            JsArrayLiteral toReturn = new JsArrayLiteral(x.getSourceInfo(), new JsExpression[0]);
            List<JsExpression> expressions = toReturn.getExpressions();
            int size = x.getExpressions().size();
            while (size-- > 0) {
                expressions.add(0, this.stack.pop());
            }
            this.stack.push(toReturn);
        }

        @Override
        public void endVisit(JsBinaryOperation x, JsContext ctx) {
            JsBinaryOperation toReturn = new JsBinaryOperation(x.getSourceInfo(), x.getOperator());
            toReturn.setArg2(this.stack.pop());
            toReturn.setArg1(this.stack.pop());
            this.stack.push(toReturn);
        }

        @Override
        public void endVisit(JsBooleanLiteral x, JsContext ctx) {
            this.stack.push(x);
        }

        @Override
        public void endVisit(JsConditional x, JsContext ctx) {
            JsConditional toReturn = new JsConditional(x.getSourceInfo());
            toReturn.setElseExpression(this.stack.pop());
            toReturn.setThenExpression(this.stack.pop());
            toReturn.setTestExpression(this.stack.pop());
            this.stack.push(toReturn);
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            this.successful = false;
            this.stack.push(null);
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            JsInvocation toReturn = new JsInvocation(x.getSourceInfo());
            List<JsExpression> params = toReturn.getArguments();
            int size = x.getArguments().size();
            while (size-- > 0) {
                params.add(0, this.stack.pop());
            }
            toReturn.setQualifier(this.stack.pop());
            this.stack.push(toReturn);
        }

        @Override
        public void endVisit(JsNameOf x, JsContext ctx) {
            JsNameOf toReturn = new JsNameOf(x.getSourceInfo(), x.getName());
            this.stack.push(toReturn);
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            if (x.getQualifier() == null && "arguments".equals(x.getIdent())) {
                this.successful = false;
                this.stack.push(null);
            }
            JsNameRef toReturn = x.getName() == null ? new JsNameRef(x.getSourceInfo(), x.getIdent(), x.getQualifier()) : new JsNameRef(x.getSourceInfo(), x.getName());
            if (x.getQualifier() != null) {
                toReturn.setQualifier(this.stack.pop());
            }
            this.stack.push(toReturn);
        }

        @Override
        public void endVisit(JsNew x, JsContext ctx) {
            int size = x.getArguments().size();
            ArrayList<JsExpression> arguments = new ArrayList<JsExpression>(size);
            while (size-- > 0) {
                arguments.add(0, this.stack.pop());
            }
            JsNew toReturn = new JsNew(x.getSourceInfo(), this.stack.pop(), new JsExpression[0]);
            toReturn.getArguments().addAll(arguments);
            this.stack.push(toReturn);
        }

        @Override
        public void endVisit(JsNullLiteral x, JsContext ctx) {
            this.stack.push(x);
        }

        @Override
        public void endVisit(JsNumberLiteral x, JsContext ctx) {
            this.stack.push(x);
        }

        @Override
        public void endVisit(JsNumericEntry x, JsContext ctx) {
            this.stack.push(x);
        }

        @Override
        public boolean visit(JsObjectLiteral x, JsContext ctx) {
            JsObjectLiteral.Builder builder = JsObjectLiteral.builder(x.getSourceInfo());
            if (x.isInternable()) {
                builder.setInternable();
            }
            for (JsPropertyInitializer propertyInitializer : x.getPropertyInitializers()) {
                this.accept(propertyInitializer.getLabelExpr());
                JsExpression label = this.stack.pop();
                this.accept(propertyInitializer.getValueExpr());
                JsExpression value = this.stack.pop();
                builder.add(propertyInitializer.getSourceInfo(), label, value);
            }
            this.stack.push(builder.build());
            return false;
        }

        @Override
        public void endVisit(JsPostfixOperation x, JsContext ctx) {
            JsPostfixOperation toReturn = new JsPostfixOperation(x.getSourceInfo(), x.getOperator());
            toReturn.setArg(this.stack.pop());
            this.stack.push(toReturn);
        }

        @Override
        public void endVisit(JsPrefixOperation x, JsContext ctx) {
            JsPrefixOperation toReturn = new JsPrefixOperation(x.getSourceInfo(), x.getOperator());
            toReturn.setArg(this.stack.pop());
            this.stack.push(toReturn);
        }

        @Override
        public void endVisit(JsRegExp x, JsContext ctx) {
            this.stack.push(x);
        }

        @Override
        public void endVisit(JsStringLiteral x, JsContext ctx) {
            this.stack.push(x);
        }

        @Override
        public void endVisit(JsThisRef x, JsContext ctx) {
            this.stack.push(new JsThisRef(x.getSourceInfo()));
        }

        public JsExpression getExpression() {
            return this.successful && this.checkStack() ? this.stack.peek() : null;
        }

        private boolean checkStack() {
            if (this.stack.size() > 1) {
                throw new InternalCompilerException("Too many expressions on stack");
            }
            return this.stack.size() == 1;
        }
    }
}

