/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.core.ext.soyc.Range;
import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.JsSourceGenerationVisitorWithSizeBreakdown;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsDoWhile;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsVisitable;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.List;

public class JsReportGenerationVisitor
extends JsSourceGenerationVisitorWithSizeBreakdown {
    private final List<Range> ranges = Lists.newArrayList();
    private final TextOutput out;
    private final boolean needSourcemapNames;
    private Range previousRange = null;
    private List<JsNode> parentStack = Lists.newArrayList();

    public JsReportGenerationVisitor(TextOutput out, JavaToJavaScriptMap map, boolean needSourcemapNames) {
        super(out, map);
        this.out = out;
        this.needSourcemapNames = needSourcemapNames;
    }

    @Override
    protected <T extends JsVisitable> T generateAndBill(T node, JsName nameToBillTo) {
        this.previousRange = null;
        if (!(node instanceof JsNode)) {
            return super.generateAndBill(node, nameToBillTo);
        }
        boolean willReportRange = false;
        if (node instanceof JsBlock) {
            willReportRange = false;
        } else if (this.parentStack.isEmpty()) {
            willReportRange = true;
        } else if (node instanceof JsStatement) {
            willReportRange = true;
        } else if (node instanceof JsNameRef && this.needSourcemapNames) {
            willReportRange = true;
        } else {
            JsNode parent = this.parentStack.get(this.parentStack.size() - 1);
            if (node instanceof JsExpression && parent instanceof JsDoWhile) {
                willReportRange = true;
            } else {
                SourceInfo info = ((JsNode)node).getSourceInfo();
                if (!this.surroundsInJavaSource(parent.getSourceInfo(), info)) {
                    willReportRange = true;
                }
            }
        }
        int beforePosition = this.out.getPosition();
        int beforeLine = this.out.getLine();
        int beforeColumn = this.out.getColumn();
        if (willReportRange) {
            this.parentStack.add((JsNode)node);
        }
        T toReturn = super.generateAndBill(node, nameToBillTo);
        if (!willReportRange) {
            return toReturn;
        }
        this.parentStack.remove(this.parentStack.size() - 1);
        SourceInfo info = ((JsNode)node).getSourceInfo();
        Range range = new Range(beforePosition, this.out.getPosition(), beforeLine, beforeColumn, this.out.getLine(), this.out.getColumn(), info);
        if (this.out.getPosition() <= beforePosition || beforeLine < 0 || this.out.getLine() < 0) {
            return toReturn;
        }
        if (info == SourceOrigin.UNKNOWN || info.getFileName() == null || info.getStartLine() < 0) {
            return toReturn;
        }
        if (this.previousRange != null && this.previousRange.contains(range)) {
            return toReturn;
        }
        this.ranges.add(range);
        this.previousRange = range;
        return toReturn;
    }

    @VisibleForTesting
    boolean surroundsInJavaSource(SourceInfo parent, SourceInfo child) {
        if (!this.hasValidJavaRange(parent) || !this.hasValidJavaRange(child)) {
            return false;
        }
        return parent.getStartPos() <= child.getStartPos() && child.getEndPos() <= parent.getEndPos() && child.getFileName().equals(parent.getFileName());
    }

    private boolean hasValidJavaRange(SourceInfo info) {
        return info != null && info.getStartPos() >= 0 && info.getEndPos() >= info.getStartPos();
    }

    @Override
    protected void billChildToHere() {
        if (this.previousRange != null && this.previousRange.getEnd() < this.out.getPosition()) {
            Range expandedRange = this.previousRange.withNewEnd(this.out.getPosition(), this.out.getLine(), this.out.getColumn());
            int lastIndex = this.ranges.size() - 1;
            Range removedRange = this.ranges.set(lastIndex, expandedRange);
            assert (removedRange == this.previousRange);
            this.previousRange = expandedRange;
        }
    }

    @Override
    public JsSourceMap getSourceInfoMap() {
        return new JsSourceMap(this.ranges, this.out.getPosition(), this.out.getLine());
    }
}

