/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.thirdparty.guava.common.base.Charsets;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;

public class JsProtectedNames {
    private static final Set<String> illegalNames = Sets.newHashSet("break", "case", "class", "catch", "const", "continue", "debugger", "default", "delete", "do", "else", "export", "extends", "finally", "for", "function", "if", "import", "in", "instanceof", "let", "new", "return", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield", "abstract", "arguments", "async", "await", "boolean", "byte", "char", "double", "false", "final", "float", "goto", "implements", "int", "interface", "long", "native", "null", "package", "private", "protected", "public", "short", "static", "synchronized", "throws", "transient", "true", "volatile", "body", "click", "min", "bind", "watch", "set", "ch", "code", "bold", "Date", "Text", "color", "event", "Attr", "sin", "exec", "quote", "form", "add", "isMap", "width", "alert", "java", "big", "parse", "media", "floor", "abbr", "gamma", "id", "dump", "exp", "some", "link", "abs", "self", "tan", "test", "every", "isNaN", "index", "pop", "join", "fixed", "ceil", "span", "UTC", "SQRT2", "name", "tFoot", "pow", "URL", "face", "sub", "vLink", "label", "cells", "rows", "eval", "cols", "acos", "lang", "trim", "LN10", "cite", "frame", "sun", "links", "sup", "areas", "isId", "type", "seal", "shift", "keys", "call", "close", "axis", "alt", "uri", "value", "rules", "reset", "alpha", "E", "open", "aLink", "sheet", "start", "Node", "blink", "stack", "now", "slice", "clear", "rel", "top", "scope", "item", "sqrt", "LOG2E", "align", "href", "apply", "chOff", "Array", "rev", "asin", "tHead", "match", "src", "cos", "title", "write", "JSON", "PI", "beta", "log", "forms", "split", "input", "NaN", "focus", "map", "defer", "data", "push", "atan2", "atan", "shape", "small", "blur", "text", "LN2", "get", "max", "arity", "dir", "x", "Error", "y", "z", "sort", "size", "round", "Math", "undefined", "CSS", "Rect", "Blob", "self", "Node", "JSON", "Intl", "Attr", "Date", "File", "name", "Text", "Array", "Audio", "event", "Range", "Touch", "Image", "Error", "Event", "top", "url", "Map", "Set", "Proxy", "Path", "self");

    private static List<String> loadGlobals(String basename) {
        String path = "globals/" + basename + ".txt";
        URL resource = JsProtectedNames.class.getResource(path);
        if (resource == null) {
            throw new RuntimeException("JsProtectedNames can't find resource: " + path);
        }
        try {
            return Resources.readLines(resource, Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("JsProtectedNames can't read resource: " + path, e);
        }
    }

    public static boolean isLegalName(String s) {
        return !illegalNames.contains(s);
    }

    private JsProtectedNames() {
    }

    static {
        illegalNames.addAll(JsProtectedNames.loadGlobals("chrome"));
        illegalNames.addAll(JsProtectedNames.loadGlobals("firefox"));
        illegalNames.addAll(JsProtectedNames.loadGlobals("ie9"));
        illegalNames.add("$H");
    }
}

