/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.js.JsNamer;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsScope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JsPrettyNamer
extends JsNamer {
    public static void exec(JsProgram program, ConfigurationProperties config) throws JsNamer.IllegalNameException {
        new JsPrettyNamer(program, config).execImpl();
    }

    public JsPrettyNamer(JsProgram program, ConfigurationProperties config) {
        super(program, config);
    }

    @Override
    protected void reset() {
    }

    @Override
    protected void visit(JsScope scope) {
        this.changeNames(scope);
    }

    private Set<String> changeNames(JsScope scope) {
        HashSet<String> taken = new HashSet<String>();
        for (JsScope child : scope.getChildren()) {
            taken.addAll(this.changeNames(child));
        }
        HashMap<String, Integer> suffixCounters = new HashMap<String, Integer>();
        for (JsName name : scope.getAllNames()) {
            if (!this.referenced.contains(name)) continue;
            this.rename(name, scope, taken, suffixCounters);
            taken.add(name.getShortIdent());
        }
        return taken;
    }

    private void rename(JsName name, JsScope scope, Set<String> taken, HashMap<String, Integer> suffixCounters) {
        if (!name.isObfuscatable()) {
            name.setShortIdent(name.getIdent());
            return;
        }
        String prefix = name.getShortIdent();
        if (prefix.contains("-")) {
            prefix = prefix.replace("-", "_");
            name.setShortIdent(prefix);
        }
        if (!this.isAvailable(prefix, scope, taken)) {
            String candidate;
            int suffix;
            Integer suffixOrNull = suffixCounters.get(prefix);
            int n = suffix = suffixOrNull == null ? 0 : suffixOrNull;
            while (!this.isAvailable(candidate = prefix + "_" + suffix++, scope, taken)) {
            }
            suffixCounters.put(prefix, suffix);
            name.setShortIdent(candidate);
        }
    }

    private boolean isAvailable(String candidate, JsScope scope, Set<String> taken) {
        if (!this.reserved.isAvailable(candidate)) {
            return false;
        }
        if (taken.contains(candidate)) {
            return false;
        }
        return scope.findExistingUnobfuscatableName(candidate) == null;
    }
}

