/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.js.JsParserException;
import com.google.gwt.dev.js.UncheckedJsParserException;
import com.google.gwt.dev.js.ast.JsArrayAccess;
import com.google.gwt.dev.js.ast.JsArrayLiteral;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsBooleanLiteral;
import com.google.gwt.dev.js.ast.JsBreak;
import com.google.gwt.dev.js.ast.JsCase;
import com.google.gwt.dev.js.ast.JsCatch;
import com.google.gwt.dev.js.ast.JsConditional;
import com.google.gwt.dev.js.ast.JsContinue;
import com.google.gwt.dev.js.ast.JsDebugger;
import com.google.gwt.dev.js.ast.JsDefault;
import com.google.gwt.dev.js.ast.JsDoWhile;
import com.google.gwt.dev.js.ast.JsEmpty;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFor;
import com.google.gwt.dev.js.ast.JsForIn;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsIf;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsLabel;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNew;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsPostfixOperation;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsRegExp;
import com.google.gwt.dev.js.ast.JsReturn;
import com.google.gwt.dev.js.ast.JsRootScope;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsSwitch;
import com.google.gwt.dev.js.ast.JsThisRef;
import com.google.gwt.dev.js.ast.JsThrow;
import com.google.gwt.dev.js.ast.JsTry;
import com.google.gwt.dev.js.ast.JsUnaryOperator;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsWhile;
import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.google.gwt.dev.js.rhino.EvaluatorException;
import com.google.gwt.dev.js.rhino.IRFactory;
import com.google.gwt.dev.js.rhino.Node;
import com.google.gwt.dev.js.rhino.Parser;
import com.google.gwt.dev.js.rhino.TokenStream;
import com.google.gwt.dev.util.collect.Stack;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class JsParser {
    private final Stack<JsScope> scopeStack = new Stack();
    private final Stack<SourceInfo> sourceInfoStack = new Stack();

    public static List<JsStatement> parse(SourceInfo rootSourceInfo, JsScope scope, Reader r) throws IOException, JsParserException {
        return new JsParser().parseImpl(rootSourceInfo, scope, r);
    }

    public static void parseInto(SourceInfo rootSourceInfo, JsScope scope, JsBlock block, Reader r) throws IOException, JsParserException {
        List<JsStatement> childStmts = JsParser.parse(rootSourceInfo, scope, r);
        List<JsStatement> parentStmts = block.getStatements();
        parentStmts.addAll(childStmts);
    }

    private JsParser() {
    }

    List<JsStatement> parseImpl(final SourceInfo rootSourceInfo, JsScope scope, Reader r) throws JsParserException, IOException {
        Context.enter().setErrorReporter(new ErrorReporter(){

            @Override
            public void error(String msg, String loc, int ln, String src, int col) {
                throw new UncheckedJsParserException(new JsParserException(msg, ln, src, col, rootSourceInfo.getFileName()));
            }

            @Override
            public EvaluatorException runtimeError(String msg, String loc, int ln, String src, int col) {
                throw new UncheckedJsParserException(new JsParserException(msg, ln, src, col, rootSourceInfo.getFileName()));
            }

            @Override
            public void warning(String msg, String loc, int ln, String src, int col) {
            }
        });
        try {
            TokenStream ts = new TokenStream(r, rootSourceInfo.getFileName(), rootSourceInfo.getStartLine());
            Parser parser = new Parser(new IRFactory(ts));
            Node topNode = (Node)parser.parse(ts);
            this.pushScope(scope, rootSourceInfo);
            List<JsStatement> stmts = this.mapStatements(topNode);
            this.popScope();
            List<JsStatement> list = stmts;
            return list;
        }
        catch (UncheckedJsParserException e) {
            throw e.getParserException();
        }
        finally {
            Context.exit();
        }
    }

    private JsParserException createParserException(String msg, Node offender) {
        return new JsParserException(msg, offender.getLineno(), null, 0, this.sourceInfoStack.peek().getFileName());
    }

    private JsScope getScope() {
        return this.scopeStack.peek();
    }

    private SourceInfo makeSourceInfo(Node node) {
        SourceInfo parent = this.sourceInfoStack.peek();
        int lineno = node.getLineno();
        if (lineno == -1) {
            return parent;
        }
        return parent.makeChild(SourceOrigin.create(lineno, parent.getFileName()));
    }

    private SourceInfo makeSourceInfoDistinct(Node node) {
        SourceInfo parent = this.sourceInfoStack.peek();
        int lineno = node.getLineno();
        if (lineno == -1) {
            lineno = parent.getStartLine();
        }
        return parent.makeChild(SourceOrigin.create(lineno, parent.getFileName()));
    }

    private JsNode map(Node node) throws JsParserException {
        switch (node.getType()) {
            case 147: {
                JsBlock block = new JsBlock(this.makeSourceInfo(node));
                this.mapStatements(block.getStatements(), node);
                return block;
            }
            case 146: {
                return this.mapDebuggerStatement(node);
            }
            case 132: {
                return null;
            }
            case 140: {
                return this.mapExprStmt(node);
            }
            case 56: {
                return this.mapRegExp(node);
            }
            case 23: {
                return this.mapBinaryOperation(JsBinaryOperator.ADD, node);
            }
            case 24: {
                return this.mapBinaryOperation(JsBinaryOperator.SUB, node);
            }
            case 25: {
                return this.mapBinaryOperation(JsBinaryOperator.MUL, node);
            }
            case 26: {
                return this.mapBinaryOperation(JsBinaryOperator.DIV, node);
            }
            case 27: {
                return this.mapBinaryOperation(JsBinaryOperator.MOD, node);
            }
            case 101: {
                return this.mapBinaryOperation(JsBinaryOperator.AND, node);
            }
            case 100: {
                return this.mapBinaryOperation(JsBinaryOperator.OR, node);
            }
            case 13: {
                return this.mapBinaryOperation(JsBinaryOperator.BIT_AND, node);
            }
            case 11: {
                return this.mapBinaryOperation(JsBinaryOperator.BIT_OR, node);
            }
            case 12: {
                return this.mapBinaryOperation(JsBinaryOperator.BIT_XOR, node);
            }
            case 97: {
                return this.mapAssignmentVariant(node);
            }
            case 103: {
                return this.mapRelationalVariant(node);
            }
            case 102: {
                return this.mapEqualityVariant(node);
            }
            case 104: {
                return this.mapShiftVariant(node);
            }
            case 105: {
                return this.mapUnaryVariant(node);
            }
            case 106: {
                return this.mapIncDecFixity(JsUnaryOperator.INC, node);
            }
            case 107: {
                return this.mapIncDecFixity(JsUnaryOperator.DEC, node);
            }
            case 98: {
                return this.mapConditional(node);
            }
            case 46: {
                SourceInfo info = this.makeSourceInfoDistinct(node);
                info.addCorrelation(info.getCorrelator().by(Correlation.Literal.STRING));
                return new JsStringLiteral(info, node.getString());
            }
            case 45: {
                return this.mapNumber(node);
            }
            case 43: {
                return this.mapCall(node);
            }
            case 39: {
                return this.mapGetProp(node);
            }
            case 40: {
                return this.mapSetProp(node);
            }
            case 31: {
                return this.mapDeleteProp(node);
            }
            case 113: {
                return this.mapIfStatement(node);
            }
            case 118: {
                return this.mapDoOrWhileStatement(true, node);
            }
            case 119: {
                return this.mapDoOrWhileStatement(false, node);
            }
            case 120: {
                return this.mapForStatement(node);
            }
            case 124: {
                return this.mapWithStatement(node);
            }
            case 41: {
                return this.mapGetElem(node);
            }
            case 42: {
                return this.mapSetElem(node);
            }
            case 110: {
                return this.mapFunction(node);
            }
            case 133: {
                return this.mapBlock(node);
            }
            case 10: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG, node);
            }
            case 44: 
            case 61: {
                return this.mapName(node);
            }
            case 5: {
                return this.mapReturn(node);
            }
            case 121: {
                return this.mapBreak(node);
            }
            case 122: {
                return this.mapContinue(node);
            }
            case 135: {
                return this.mapObjectLiteral(node);
            }
            case 134: {
                return this.mapArrayLit(node);
            }
            case 123: {
                return this.mapVar(node);
            }
            case 109: {
                return this.mapPrimary(node);
            }
            case 96: {
                return this.mapBinaryOperation(JsBinaryOperator.COMMA, node);
            }
            case 30: {
                return this.mapNew(node);
            }
            case 62: {
                return this.mapThrowStatement(node);
            }
            case 75: {
                return this.mapTryStatement(node);
            }
            case 115: {
                return this.mapSwitchStatement(node);
            }
            case 136: {
                return this.mapLabel(node);
            }
        }
        int tokenType = node.getType();
        throw this.createParserException("Unexpected top-level token type: " + tokenType, node);
    }

    private JsArrayLiteral mapArrayLit(Node node) throws JsParserException {
        JsArrayLiteral toLit = new JsArrayLiteral(this.makeSourceInfo(node), new JsExpression[0]);
        for (Node from = node.getFirstChild(); from != null; from = from.getNext()) {
            toLit.getExpressions().add(this.mapExpression(from));
        }
        return toLit;
    }

    private JsNameRef mapAsPropertyNameRef(Node nameRefNode) throws JsParserException {
        JsNode unknown = this.map(nameRefNode);
        if (unknown instanceof JsStringLiteral) {
            JsStringLiteral lit = (JsStringLiteral)unknown;
            String litName = lit.getValue();
            return new JsNameRef(this.makeSourceInfo(nameRefNode), litName);
        }
        throw this.createParserException("Expecting a name reference", nameRefNode);
    }

    private JsExpression mapAssignmentVariant(Node asgNode) throws JsParserException {
        switch (asgNode.getIntDatum()) {
            case 128: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG, asgNode);
            }
            case 23: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_ADD, asgNode);
            }
            case 24: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_SUB, asgNode);
            }
            case 25: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_MUL, asgNode);
            }
            case 26: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_DIV, asgNode);
            }
            case 27: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_MOD, asgNode);
            }
            case 13: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_BIT_AND, asgNode);
            }
            case 11: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_BIT_OR, asgNode);
            }
            case 12: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_BIT_XOR, asgNode);
            }
            case 20: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_SHL, asgNode);
            }
            case 21: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_SHR, asgNode);
            }
            case 22: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_SHRU, asgNode);
            }
        }
        throw this.createParserException("Unknown assignment operator variant: " + asgNode.getIntDatum(), asgNode);
    }

    private JsExpression mapBinaryOperation(JsBinaryOperator op, Node node) throws JsParserException {
        Node from1 = node.getFirstChild();
        Node from2 = from1.getNext();
        JsExpression to1 = this.mapExpression(from1);
        JsExpression to2 = this.mapExpression(from2);
        return new JsBinaryOperation(this.makeSourceInfo(node), op, to1, to2);
    }

    private JsBlock mapBlock(Node nodeStmts) throws JsParserException {
        SourceInfo info = this.makeSourceInfo(nodeStmts);
        JsBlock block = new JsBlock(info);
        this.pushSourceInfo(info);
        this.mapStatements(block.getStatements(), nodeStmts);
        this.popSourceInfo();
        return block;
    }

    private JsBreak mapBreak(Node breakNode) {
        Node fromLabel = breakNode.getFirstChild();
        if (fromLabel != null) {
            return new JsBreak(this.makeSourceInfo(breakNode), this.mapName(fromLabel));
        }
        return new JsBreak(this.makeSourceInfo(breakNode));
    }

    private JsInvocation mapCall(Node callNode) throws JsParserException {
        JsInvocation invocation = new JsInvocation(this.makeSourceInfo(callNode));
        Node from = callNode.getFirstChild();
        JsExpression to = this.mapExpression(from);
        invocation.setQualifier(to);
        List<JsExpression> args = invocation.getArguments();
        for (from = from.getNext(); from != null; from = from.getNext()) {
            to = this.mapExpression(from);
            args.add(to);
        }
        return invocation;
    }

    private JsExpression mapConditional(Node condNode) throws JsParserException {
        JsConditional toCond = new JsConditional(this.makeSourceInfo(condNode));
        Node fromTest = condNode.getFirstChild();
        toCond.setTestExpression(this.mapExpression(fromTest));
        Node fromThen = fromTest.getNext();
        toCond.setThenExpression(this.mapExpression(fromThen));
        Node fromElse = fromThen.getNext();
        toCond.setElseExpression(this.mapExpression(fromElse));
        return toCond;
    }

    private JsContinue mapContinue(Node contNode) {
        Node fromLabel = contNode.getFirstChild();
        if (fromLabel != null) {
            return new JsContinue(this.makeSourceInfo(contNode), this.mapName(fromLabel));
        }
        return new JsContinue(this.makeSourceInfo(contNode));
    }

    private JsStatement mapDebuggerStatement(Node node) {
        return new JsDebugger(this.makeSourceInfo(node));
    }

    private JsExpression mapDeleteProp(Node node) throws JsParserException {
        Node from = node.getFirstChild();
        JsExpression to = this.mapExpression(from);
        if (to instanceof JsNameRef) {
            return new JsPrefixOperation(this.makeSourceInfo(node), JsUnaryOperator.DELETE, to);
        }
        if (to instanceof JsArrayAccess) {
            return new JsPrefixOperation(this.makeSourceInfo(node), JsUnaryOperator.DELETE, to);
        }
        throw this.createParserException("'delete' can only operate on property names and array elements", from);
    }

    private JsStatement mapDoOrWhileStatement(boolean isWhile, Node ifNode) throws JsParserException {
        Node fromBody;
        Node fromTestExpr;
        if (isWhile) {
            fromTestExpr = ifNode.getFirstChild();
            fromBody = ifNode.getFirstChild().getNext();
        } else {
            fromBody = ifNode.getFirstChild();
            fromTestExpr = ifNode.getFirstChild().getNext();
        }
        SourceInfo info = this.makeSourceInfo(ifNode);
        this.pushSourceInfo(info);
        JsExpression toTestExpr = this.mapExpression(fromTestExpr);
        JsStatement toBody = this.mapStatement(fromBody);
        this.popSourceInfo();
        if (isWhile) {
            return new JsWhile(info, toTestExpr, toBody);
        }
        return new JsDoWhile(info, toTestExpr, toBody);
    }

    private JsExpression mapEqualityVariant(Node eqNode) throws JsParserException {
        switch (eqNode.getIntDatum()) {
            case 14: {
                return this.mapBinaryOperation(JsBinaryOperator.EQ, eqNode);
            }
            case 15: {
                return this.mapBinaryOperation(JsBinaryOperator.NEQ, eqNode);
            }
            case 53: {
                return this.mapBinaryOperation(JsBinaryOperator.REF_EQ, eqNode);
            }
            case 54: {
                return this.mapBinaryOperation(JsBinaryOperator.REF_NEQ, eqNode);
            }
            case 16: {
                return this.mapBinaryOperation(JsBinaryOperator.LT, eqNode);
            }
            case 17: {
                return this.mapBinaryOperation(JsBinaryOperator.LTE, eqNode);
            }
            case 18: {
                return this.mapBinaryOperation(JsBinaryOperator.GT, eqNode);
            }
            case 19: {
                return this.mapBinaryOperation(JsBinaryOperator.GTE, eqNode);
            }
        }
        throw this.createParserException("Unknown equality operator variant: " + eqNode.getIntDatum(), eqNode);
    }

    private JsExpression mapExpression(Node exprNode) throws JsParserException {
        JsNode unknown = this.map(exprNode);
        if (unknown instanceof JsExpression) {
            return (JsExpression)unknown;
        }
        throw this.createParserException("Expecting an expression", exprNode);
    }

    private JsExprStmt mapExprStmt(Node node) throws JsParserException {
        this.pushSourceInfo(this.makeSourceInfo(node));
        JsExpression expr = this.mapExpression(node.getFirstChild());
        this.popSourceInfo();
        return expr.makeStmt();
    }

    private JsStatement mapForStatement(Node forNode) throws JsParserException {
        Node fromInit = forNode.getFirstChild();
        Node fromTest = fromInit.getNext();
        Node fromIncr = fromTest.getNext();
        Node fromBody = fromIncr.getNext();
        SourceInfo info = this.makeSourceInfo(forNode);
        if (fromBody == null) {
            JsForIn toForIn;
            Node fromIter = forNode.getFirstChild();
            Node fromObjExpr = fromIter.getNext();
            fromBody = fromObjExpr.getNext();
            if (fromIter.getType() == 123) {
                Node fromIterVarName = fromIter.getFirstChild();
                String fromName = fromIterVarName.getString();
                JsName toName = this.getScope().declareName(fromName);
                toForIn = new JsForIn(info, toName);
                Node fromIterInit = fromIterVarName.getFirstChild();
                if (fromIterInit != null) {
                    toForIn.setIterExpr(this.mapOptionalExpression(fromIterInit));
                }
            } else {
                toForIn = new JsForIn(info);
                toForIn.setIterExpr(this.mapExpression(fromIter));
            }
            toForIn.setObjExpr(this.mapExpression(fromObjExpr));
            JsStatement bodyStmt = this.mapStatement(fromBody);
            if (bodyStmt != null) {
                toForIn.setBody(bodyStmt);
            } else {
                toForIn.setBody(new JsEmpty(info));
            }
            return toForIn;
        }
        JsFor toFor = new JsFor(info);
        JsNode initThingy = this.map(fromInit);
        if (initThingy != null) {
            if (initThingy instanceof JsVars) {
                toFor.setInitVars((JsVars)initThingy);
            } else {
                assert (initThingy instanceof JsExpression);
                toFor.setInitExpr((JsExpression)initThingy);
            }
        }
        toFor.setCondition(this.mapOptionalExpression(fromTest));
        toFor.setIncrExpr(this.mapOptionalExpression(fromIncr));
        JsStatement bodyStmt = this.mapStatement(fromBody);
        if (bodyStmt != null) {
            toFor.setBody(bodyStmt);
        } else {
            toFor.setBody(new JsEmpty(info));
        }
        return toFor;
    }

    private JsExpression mapFunction(Node fnNode) throws JsParserException {
        Node fromFnNameNode = fnNode.getFirstChild();
        Node fromParamNode = fnNode.getFirstChild().getNext().getFirstChild();
        Node fromBodyNode = fnNode.getFirstChild().getNext().getNext();
        String fromFnName = fromFnNameNode.getString();
        JsName toFnName = null;
        if (fromFnName != null && fromFnName.length() > 0) {
            toFnName = this.getScope().declareName(fromFnName);
        }
        SourceInfo fnSourceInfo = this.makeSourceInfo(fnNode);
        JsFunction toFn = new JsFunction(fnSourceInfo, this.getScope(), toFnName);
        this.pushScope(toFn.getScope(), fnSourceInfo);
        while (fromParamNode != null) {
            String fromParamName = fromParamNode.getString();
            JsName paramName = toFn.getScope().declareName(fromParamName);
            toFn.getParameters().add(new JsParameter(fnSourceInfo, paramName));
            fromParamNode = fromParamNode.getNext();
        }
        JsBlock toBody = this.mapBlock(fromBodyNode);
        toFn.setBody(toBody);
        this.popScope();
        return toFn;
    }

    private JsArrayAccess mapGetElem(Node getElemNode) throws JsParserException {
        Node from1 = getElemNode.getFirstChild();
        Node from2 = from1.getNext();
        JsExpression to1 = this.mapExpression(from1);
        JsExpression to2 = this.mapExpression(from2);
        return new JsArrayAccess(this.makeSourceInfo(getElemNode), to1, to2);
    }

    private JsNameRef mapGetProp(Node getPropNode) throws JsParserException {
        JsNameRef toNameRef;
        Node from1 = getPropNode.getFirstChild();
        Node from2 = from1.getNext();
        JsExpression toQualifier = this.mapExpression(from1);
        if (from2 != null) {
            toNameRef = this.mapAsPropertyNameRef(from2);
        } else {
            Object obj = getPropNode.getProp(19);
            assert (obj instanceof String);
            toNameRef = new JsNameRef(this.makeSourceInfo(getPropNode), (String)obj);
        }
        toNameRef.setQualifier(toQualifier);
        return toNameRef;
    }

    private JsIf mapIfStatement(Node ifNode) throws JsParserException {
        Node fromTestExpr = ifNode.getFirstChild();
        Node fromThenBlock = ifNode.getFirstChild().getNext();
        Node fromElseBlock = ifNode.getFirstChild().getNext().getNext();
        JsIf toIf = new JsIf(this.makeSourceInfo(ifNode));
        JsExpression toTestExpr = this.mapExpression(fromTestExpr);
        toIf.setIfExpr(toTestExpr);
        toIf.setThenStmt(this.mapStatement(fromThenBlock));
        if (fromElseBlock != null) {
            toIf.setElseStmt(this.mapStatement(fromElseBlock));
        }
        return toIf;
    }

    private JsExpression mapIncDecFixity(JsUnaryOperator op, Node node) throws JsParserException {
        switch (node.getIntDatum()) {
            case 130: {
                return this.mapPrefixOperation(op, node);
            }
            case 131: {
                return this.mapPostfixOperation(op, node);
            }
        }
        throw this.createParserException("Unknown prefix/postfix variant: " + node.getIntDatum(), node);
    }

    private JsLabel mapLabel(Node labelNode) throws JsParserException {
        String fromName = labelNode.getFirstChild().getString();
        JsName toName = this.getScope().declareName(fromName);
        Node fromStmt = labelNode.getFirstChild().getNext();
        JsLabel toLabel = new JsLabel(this.makeSourceInfo(labelNode), toName);
        toLabel.setStmt(this.mapStatement(fromStmt));
        return toLabel;
    }

    private JsNameRef mapName(Node node) {
        String ident = node.getString();
        return new JsNameRef(this.makeSourceInfo(node), ident);
    }

    private JsNew mapNew(Node newNode) throws JsParserException {
        Node fromCtorExpr = newNode.getFirstChild();
        JsNew newExpr = new JsNew(this.makeSourceInfo(newNode), this.mapExpression(fromCtorExpr), new JsExpression[0]);
        List<JsExpression> args = newExpr.getArguments();
        for (Node fromArg = fromCtorExpr.getNext(); fromArg != null; fromArg = fromArg.getNext()) {
            args.add(this.mapExpression(fromArg));
        }
        return newExpr;
    }

    private JsExpression mapNumber(Node numberNode) {
        return new JsNumberLiteral(this.makeSourceInfo(numberNode), numberNode.getDouble());
    }

    private JsExpression mapObjectLiteral(Node objectLiteralNode) throws JsParserException {
        JsObjectLiteral.Builder objectLiteralBuilder = JsObjectLiteral.builder(this.makeSourceInfo(objectLiteralNode));
        for (Node propertyComponent = objectLiteralNode.getFirstChild(); propertyComponent != null; propertyComponent = propertyComponent.getNext()) {
            JsExpression labelExpression = this.mapExpression(propertyComponent);
            Node valueNode = propertyComponent = propertyComponent.getNext();
            if (valueNode == null) {
                throw this.createParserException("Expected an init expression for: " + labelExpression, objectLiteralNode);
            }
            objectLiteralBuilder.add(labelExpression.getSourceInfo(), labelExpression, this.mapExpression(valueNode));
        }
        return objectLiteralBuilder.build();
    }

    private JsExpression mapOptionalExpression(Node exprNode) throws JsParserException {
        JsNode unknown = this.map(exprNode);
        if (unknown != null) {
            if (unknown instanceof JsExpression) {
                return (JsExpression)unknown;
            }
            throw this.createParserException("Expecting an expression or null", exprNode);
        }
        return null;
    }

    private JsExpression mapPostfixOperation(JsUnaryOperator op, Node node) throws JsParserException {
        Node from = node.getFirstChild();
        JsExpression to = this.mapExpression(from);
        return new JsPostfixOperation(this.makeSourceInfo(node), op, to);
    }

    private JsExpression mapPrefixOperation(JsUnaryOperator op, Node node) throws JsParserException {
        Node from = node.getFirstChild();
        JsExpression to = this.mapExpression(from);
        return new JsPrefixOperation(this.makeSourceInfo(node), op, to);
    }

    private JsExpression mapPrimary(Node node) throws JsParserException {
        switch (node.getIntDatum()) {
            case 50: {
                return new JsThisRef(this.makeSourceInfo(node));
            }
            case 52: {
                return JsBooleanLiteral.TRUE;
            }
            case 51: {
                return JsBooleanLiteral.FALSE;
            }
            case 49: {
                return JsNullLiteral.INSTANCE;
            }
            case 74: {
                return new JsNameRef(this.makeSourceInfo(node), JsRootScope.INSTANCE.getUndefined());
            }
        }
        throw this.createParserException("Unknown primary: " + node.getIntDatum(), node);
    }

    private JsNode mapRegExp(Node regExpNode) {
        JsRegExp toRegExp = new JsRegExp(this.makeSourceInfo(regExpNode));
        Node fromPattern = regExpNode.getFirstChild();
        toRegExp.setPattern(fromPattern.getString());
        Node fromFlags = fromPattern.getNext();
        if (fromFlags != null) {
            toRegExp.setFlags(fromFlags.getString());
        }
        return toRegExp;
    }

    private JsExpression mapRelationalVariant(Node relNode) throws JsParserException {
        switch (relNode.getIntDatum()) {
            case 16: {
                return this.mapBinaryOperation(JsBinaryOperator.LT, relNode);
            }
            case 17: {
                return this.mapBinaryOperation(JsBinaryOperator.LTE, relNode);
            }
            case 18: {
                return this.mapBinaryOperation(JsBinaryOperator.GT, relNode);
            }
            case 19: {
                return this.mapBinaryOperation(JsBinaryOperator.GTE, relNode);
            }
            case 64: {
                return this.mapBinaryOperation(JsBinaryOperator.INSTANCEOF, relNode);
            }
            case 63: {
                return this.mapBinaryOperation(JsBinaryOperator.INOP, relNode);
            }
        }
        throw this.createParserException("Unknown relational operator variant: " + relNode.getIntDatum(), relNode);
    }

    private JsReturn mapReturn(Node returnNode) throws JsParserException {
        SourceInfo info = this.makeSourceInfo(returnNode);
        JsReturn toReturn = new JsReturn(info);
        this.pushSourceInfo(info);
        Node from = returnNode.getFirstChild();
        if (from != null) {
            JsExpression to = this.mapExpression(from);
            toReturn.setExpr(to);
        }
        this.popSourceInfo();
        return toReturn;
    }

    private JsExpression mapSetElem(Node setElemNode) throws JsParserException {
        JsArrayAccess lhs = this.mapGetElem(setElemNode);
        Node fromRhs = setElemNode.getFirstChild().getNext().getNext();
        JsExpression toRhs = this.mapExpression(fromRhs);
        return new JsBinaryOperation(this.makeSourceInfo(setElemNode), JsBinaryOperator.ASG, lhs, toRhs);
    }

    private JsExpression mapSetProp(Node getPropNode) throws JsParserException {
        JsNameRef lhs = this.mapGetProp(getPropNode);
        Node fromRhs = getPropNode.getFirstChild().getNext().getNext();
        JsExpression toRhs = this.mapExpression(fromRhs);
        return new JsBinaryOperation(this.makeSourceInfo(getPropNode), JsBinaryOperator.ASG, lhs, toRhs);
    }

    private JsExpression mapShiftVariant(Node shiftNode) throws JsParserException {
        switch (shiftNode.getIntDatum()) {
            case 20: {
                return this.mapBinaryOperation(JsBinaryOperator.SHL, shiftNode);
            }
            case 21: {
                return this.mapBinaryOperation(JsBinaryOperator.SHR, shiftNode);
            }
            case 22: {
                return this.mapBinaryOperation(JsBinaryOperator.SHRU, shiftNode);
            }
        }
        throw this.createParserException("Unknown equality operator variant: " + shiftNode.getIntDatum(), shiftNode);
    }

    private JsStatement mapStatement(Node nodeStmt) throws JsParserException {
        JsNode unknown = this.map(nodeStmt);
        if (unknown != null) {
            if (unknown instanceof JsStatement) {
                return (JsStatement)unknown;
            }
            if (unknown instanceof JsExpression) {
                return ((JsExpression)unknown).makeStmt();
            }
            throw this.createParserException("Expecting a statement", nodeStmt);
        }
        return new JsEmpty(this.makeSourceInfo(nodeStmt));
    }

    private void mapStatements(List<JsStatement> stmts, Node nodeStmts) throws JsParserException {
        for (Node curr = nodeStmts.getFirstChild(); curr != null; curr = curr.getNext()) {
            JsStatement stmt = this.mapStatement(curr);
            if (stmt == null) continue;
            stmts.add(stmt);
        }
    }

    private List<JsStatement> mapStatements(Node nodeStmts) throws JsParserException {
        ArrayList<JsStatement> stmts = new ArrayList<JsStatement>();
        this.mapStatements(stmts, nodeStmts);
        return stmts;
    }

    private JsSwitch mapSwitchStatement(Node switchNode) throws JsParserException {
        SourceInfo info = this.makeSourceInfo(switchNode);
        JsSwitch toSwitch = new JsSwitch(info);
        this.pushSourceInfo(info);
        Node fromSwitchExpr = switchNode.getFirstChild();
        toSwitch.setExpr(this.mapExpression(fromSwitchExpr));
        for (Node fromMember = fromSwitchExpr.getNext(); fromMember != null; fromMember = fromMember.getNext()) {
            if (fromMember.getType() == 116) {
                JsCase toCase = new JsCase(this.makeSourceInfo(fromMember));
                Node fromCaseExpr = fromMember.getFirstChild();
                toCase.setCaseExpr(this.mapExpression(fromCaseExpr));
                Node fromCaseBlock = fromCaseExpr.getNext();
                this.mapStatements(toCase.getStmts(), fromCaseBlock);
                toSwitch.getCases().add(toCase);
                continue;
            }
            assert (fromMember.getType() == 117);
            JsDefault toDefault = new JsDefault(this.makeSourceInfo(fromMember));
            Node fromDefaultBlock = fromMember.getFirstChild();
            this.mapStatements(toDefault.getStmts(), fromDefaultBlock);
            toSwitch.getCases().add(toDefault);
        }
        this.popSourceInfo();
        return toSwitch;
    }

    private JsThrow mapThrowStatement(Node throwNode) throws JsParserException {
        SourceInfo info = this.makeSourceInfo(throwNode);
        this.pushSourceInfo(info);
        Node fromExpr = throwNode.getFirstChild();
        JsThrow toThrow = new JsThrow(info, this.mapExpression(fromExpr));
        this.popSourceInfo();
        return toThrow;
    }

    private JsTry mapTryStatement(Node tryNode) throws JsParserException {
        JsTry toTry = new JsTry(this.makeSourceInfo(tryNode));
        Node fromTryBody = tryNode.getFirstChild();
        toTry.setTryBlock(this.mapBlock(fromTryBody));
        Node fromCatchNodes = fromTryBody.getNext();
        Node fromCatchNode = fromCatchNodes.getFirstChild();
        while (fromCatchNode != null) {
            assert (fromCatchNode.getType() == 125);
            Node fromCatchVarName = fromCatchNode.getFirstChild();
            JsCatch catchBlock = new JsCatch(this.makeSourceInfo(fromCatchNode), this.getScope(), fromCatchVarName.getString());
            fromCatchNode = fromCatchNode.getNext();
            Node fromCondition = fromCatchVarName.getNext();
            JsExpression toCondition = this.mapExpression(fromCondition);
            catchBlock.setCondition(toCondition);
            if (fromCatchNode == null && toCondition instanceof JsBooleanLiteral && ((JsBooleanLiteral)toCondition).getValue()) {
                catchBlock.setCondition(null);
            }
            Node fromCatchBody = fromCondition.getNext();
            this.pushScope(catchBlock.getScope(), catchBlock.getSourceInfo());
            catchBlock.setBody(this.mapBlock(fromCatchBody));
            this.popScope();
            toTry.getCatches().add(catchBlock);
        }
        Node fromFinallyNode = fromCatchNodes.getNext();
        if (fromFinallyNode != null) {
            toTry.setFinallyBlock(this.mapBlock(fromFinallyNode));
        }
        return toTry;
    }

    private JsExpression mapUnaryVariant(Node unOp) throws JsParserException {
        switch (unOp.getIntDatum()) {
            case 24: {
                return this.mapPrefixOperation(JsUnaryOperator.NEG, unOp);
            }
            case 129: {
                return this.mapPrefixOperation(JsUnaryOperator.NOT, unOp);
            }
            case 28: {
                return this.mapPrefixOperation(JsUnaryOperator.BIT_NOT, unOp);
            }
            case 32: {
                return this.mapPrefixOperation(JsUnaryOperator.TYPEOF, unOp);
            }
            case 23: {
                if (unOp.getFirstChild().getType() != 45) {
                    return this.mapPrefixOperation(JsUnaryOperator.POS, unOp);
                }
                return this.mapExpression(unOp.getFirstChild());
            }
            case 132: {
                return this.mapPrefixOperation(JsUnaryOperator.VOID, unOp);
            }
        }
        throw this.createParserException("Unknown unary operator variant: " + unOp.getIntDatum(), unOp);
    }

    private JsVars mapVar(Node varNode) throws JsParserException {
        SourceInfo info = this.makeSourceInfo(varNode);
        this.pushSourceInfo(info);
        JsVars toVars = new JsVars(info, new JsVars.JsVar[0]);
        for (Node fromVar = varNode.getFirstChild(); fromVar != null; fromVar = fromVar.getNext()) {
            String fromName = fromVar.getString();
            JsName toName = this.getScope().declareName(fromName);
            JsVars.JsVar toVar = new JsVars.JsVar(this.makeSourceInfo(fromVar), toName);
            Node fromInit = fromVar.getFirstChild();
            if (fromInit != null) {
                JsExpression toInit = this.mapExpression(fromInit);
                toVar.setInitExpr(toInit);
            }
            toVars.add(toVar);
        }
        this.popSourceInfo();
        return toVars;
    }

    private JsNode mapWithStatement(Node withNode) throws JsParserException {
        throw this.createParserException("Internal error: unexpected token 'with'", withNode);
    }

    private void popScope() {
        this.scopeStack.pop();
        this.sourceInfoStack.pop();
    }

    private void popSourceInfo() {
        this.sourceInfoStack.pop();
    }

    private void pushScope(JsScope scope, SourceInfo sourceInfo) {
        this.scopeStack.push(scope);
        this.sourceInfoStack.push(sourceInfo);
    }

    private void pushSourceInfo(SourceInfo sourceInfo) {
        assert (sourceInfo.getStartLine() >= 0) : "Bad SourceInfo line number";
        this.sourceInfoStack.push(sourceInfo);
    }
}

