/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.js.FreshNameGenerator;
import com.google.gwt.dev.js.JsNamer;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsScope;

public class JsObfuscateNamer
extends JsNamer
implements FreshNameGenerator {
    private static final char[] sBase64Chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '$', '_', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private int maxChildId = 0;
    private int maxId = -1;

    public static FreshNameGenerator exec(JsProgram program) throws JsNamer.IllegalNameException {
        return JsObfuscateNamer.exec(program, null);
    }

    public static FreshNameGenerator exec(JsProgram program, ConfigurationProperties config) throws JsNamer.IllegalNameException {
        JsObfuscateNamer namer = new JsObfuscateNamer(program, config);
        namer.execImpl();
        return namer;
    }

    @Override
    public String getFreshName() {
        String newIdent;
        do {
            newIdent = JsObfuscateNamer.makeObfuscatedIdent(this.maxId++);
        } while (!this.isLegal(this.program.getScope(), newIdent));
        return newIdent;
    }

    public JsObfuscateNamer(JsProgram program, ConfigurationProperties config) {
        super(program, config);
    }

    @Override
    protected void reset() {
        this.maxChildId = 0;
    }

    @Override
    protected void visit(JsScope scope) {
        int mySiblingsMaxId = this.maxChildId;
        this.maxChildId = 0;
        for (JsScope child : scope.getChildren()) {
            this.visit(child);
        }
        int curId = this.maxChildId;
        for (JsName name : scope.getAllNames()) {
            String newIdent;
            if (!this.referenced.contains(name)) continue;
            if (!name.isObfuscatable()) {
                name.setShortIdent(name.getIdent());
                continue;
            }
            while (!this.isLegal(scope, newIdent = JsObfuscateNamer.makeObfuscatedIdent(curId++))) {
            }
            name.setShortIdent(newIdent);
        }
        this.maxChildId = Math.max(mySiblingsMaxId, curId);
        this.maxId = Math.max(this.maxId, this.maxChildId);
    }

    private boolean isLegal(JsScope scope, String newIdent) {
        if (!this.reserved.isAvailable(newIdent)) {
            return false;
        }
        return scope.findExistingUnobfuscatableName(newIdent) == null;
    }

    public static String makeObfuscatedIdent(int id) {
        char[] sIdentBuf = new char[6];
        int i = 0;
        sIdentBuf[i++] = sBase64Chars[id % 54];
        id /= 54;
        while (id != 0) {
            sIdentBuf[i++] = sBase64Chars[id & 0x3F];
            id >>= 6;
        }
        return new String(sIdentBuf, 0, i);
    }
}

