/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.util.Util;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JsNamespaceChooser {
    private final JProgram jprogram;
    private final JsProgram jsprogram;
    private final JavaToJavaScriptMap jjsmap;
    private final Map<String, JsName> packageToNamespace = Maps.newLinkedHashMap();

    public static void exec(JProgram jprogram, JsProgram jsprogram, JavaToJavaScriptMap jjsmap) {
        new JsNamespaceChooser(jprogram, jsprogram, jjsmap).execImpl();
    }

    private JsNamespaceChooser(JProgram jprogram, JsProgram jsprogram, JavaToJavaScriptMap jjsmap) {
        this.jsprogram = jsprogram;
        this.jprogram = jprogram;
        this.jjsmap = jjsmap;
    }

    private void execImpl() {
        List<JsStatement> globalStatements = this.jsprogram.getGlobalBlock().getStatements();
        ArrayList<JsStatement> after = Lists.newArrayList();
        for (JsStatement before : globalStatements) {
            JsExprStmt expressionStatement;
            if (before instanceof JsVars) {
                for (JsVars.JsVar var : (JsVars)before) {
                    JsStatement replacement = this.visitGlobalVar(var);
                    if (replacement == null) continue;
                    after.add(replacement);
                }
                continue;
            }
            if (before instanceof JsExprStmt && (expressionStatement = (JsExprStmt)before).getExpression() instanceof JsFunction) {
                JsExpression transformedFunction = this.visitGlobalFunction((JsFunction)expressionStatement.getExpression());
                expressionStatement.setExpression(transformedFunction);
            }
            after.add(before);
        }
        after.addAll(0, this.createNamespaceInitializers(this.packageToNamespace.values()));
        globalStatements.clear();
        globalStatements.addAll(after);
        new NameFixer().accept(this.jsprogram);
    }

    private JsStatement visitGlobalVar(JsVars.JsVar x) {
        JsName name = x.getName();
        if (!this.moveName(name)) {
            JsVars vars = new JsVars(x.getSourceInfo(), new JsVars.JsVar[0]);
            vars.add(x);
            return vars;
        }
        JsNameRef newName = name.makeRef(x.getSourceInfo());
        JsExpression init = x.getInitExpr();
        if (init == null) {
            return null;
        }
        JsBinaryOperation assign = new JsBinaryOperation(x.getSourceInfo(), JsBinaryOperator.ASG, newName, init);
        return assign.makeStmt();
    }

    private JsExpression visitGlobalFunction(JsFunction func) {
        JsName name = func.getName();
        if (name == null || !this.moveName(name)) {
            return func;
        }
        JsNameRef newName = name.makeRef(func.getSourceInfo());
        JsBinaryOperation assign = new JsBinaryOperation(func.getSourceInfo(), JsBinaryOperator.ASG, newName, func);
        return assign;
    }

    private List<JsStatement> createNamespaceInitializers(Collection<JsName> namespaces) {
        ArrayList<JsStatement> inits = Lists.newArrayList();
        for (JsName name : namespaces) {
            JsVars.JsVar var = new JsVars.JsVar(SourceOrigin.UNKNOWN, name);
            var.setInitExpr(JsObjectLiteral.EMPTY);
            JsVars vars = new JsVars(SourceOrigin.UNKNOWN, new JsVars.JsVar[0]);
            vars.add(var);
            inits.add(vars);
        }
        return inits;
    }

    private boolean moveName(JsName name) {
        if (name.getNamespace() != null) {
            return false;
        }
        if (!name.isObfuscatable()) {
            return false;
        }
        String packageName = this.findPackage(name);
        if (packageName == null) {
            return false;
        }
        if (this.isIndexedName(name)) {
            return false;
        }
        JsName namespace = this.packageToNamespace.get(packageName);
        if (namespace == null) {
            namespace = this.jsprogram.getScope().declareName(this.chooseUnusedName(packageName));
            this.packageToNamespace.put(packageName, namespace);
        }
        name.setNamespace(namespace);
        return true;
    }

    private boolean isIndexedName(JsName name) {
        return this.jprogram != null && (this.jprogram.getIndexedMethods().contains(this.jjsmap.nameToMethod(name)) || this.jprogram.getIndexedFields().contains(this.jjsmap.nameToField(name)));
    }

    private String chooseUnusedName(String packageName) {
        String initials;
        String candidate = initials = JsNamespaceChooser.initialsForPackage(packageName);
        int counter = 1;
        while (this.jsprogram.getScope().findExistingName(candidate) != null) {
            candidate = initials + ++counter;
        }
        return candidate;
    }

    private String findPackage(JsName name) {
        JMethod method = this.jjsmap.nameToMethod(name);
        if (method != null) {
            return JsNamespaceChooser.findPackage(method.getEnclosingType());
        }
        JField field = this.jjsmap.nameToField(name);
        if (field != null) {
            return JsNamespaceChooser.findPackage(field.getEnclosingType());
        }
        return null;
    }

    private static String findPackage(JDeclaredType type) {
        String packageName = Util.getPackageName(type.getName());
        return packageName.isEmpty() ? null : packageName;
    }

    private static String initialsForPackage(String packageName) {
        StringBuilder result = new StringBuilder();
        int end = packageName.length();
        boolean wasDot = true;
        for (int i = 0; i < end; ++i) {
            char c = packageName.charAt(i);
            if (c == '.') {
                wasDot = true;
                continue;
            }
            if (wasDot) {
                result.append(c);
            }
            wasDot = false;
        }
        return result.toString();
    }

    private static class NameFixer
    extends JsModVisitor {
        private NameFixer() {
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            if (x.getQualifier() != null || x.getName() == null) {
                return;
            }
            JsName namespace = x.getName().getNamespace();
            if (namespace == null) {
                return;
            }
            x.setQualifier(new JsNameRef(x.getSourceInfo(), namespace));
            this.didChange = true;
        }
    }
}

