/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.js.ReservedNames;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsForIn;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsLabel;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameOf;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitor;
import java.util.HashSet;
import java.util.Set;

public abstract class JsNamer {
    protected final JsProgram program;
    protected final Set<JsName> referenced;
    protected final ReservedNames reserved;

    private static Set<JsName> collectReferencedNames(JsProgram program) {
        final HashSet<JsName> referenced = new HashSet<JsName>();
        new JsVisitor(){

            @Override
            public void endVisit(JsForIn x, JsContext ctx) {
                this.reference(x.getIterVarName());
            }

            @Override
            public void endVisit(JsFunction x, JsContext ctx) {
                this.reference(x.getName());
            }

            @Override
            public void endVisit(JsLabel x, JsContext ctx) {
                this.reference(x.getName());
            }

            @Override
            public void endVisit(JsNameOf x, JsContext ctx) {
                this.reference(x.getName());
            }

            @Override
            public void endVisit(JsNameRef x, JsContext ctx) {
                this.reference(x.getName());
            }

            @Override
            public void endVisit(JsParameter x, JsContext ctx) {
                this.reference(x.getName());
            }

            @Override
            public void endVisit(JsVars.JsVar x, JsContext ctx) {
                this.reference(x.getName());
            }

            private void reference(JsName name) {
                if (name != null) {
                    referenced.add(name);
                }
            }
        }.accept(program);
        return referenced;
    }

    public JsNamer(JsProgram program, ConfigurationProperties config) {
        this.program = program;
        this.referenced = JsNamer.collectReferencedNames(program);
        this.reserved = new ReservedNames(config);
    }

    protected final void execImpl() throws IllegalNameException {
        this.reset();
        this.visit(this.program.getScope());
        this.reset();
        this.visit(this.program.getObjectScope());
    }

    protected abstract void reset();

    protected abstract void visit(JsScope var1) throws IllegalNameException;

    public static class IllegalNameException
    extends Exception {
        public IllegalNameException(String message) {
            super(message);
        }
    }
}

