/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.js.ast.JsArrayLiteral;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsLiteral;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsPostfixOperation;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsProgramFragment;
import com.google.gwt.dev.js.ast.JsPropertyInitializer;
import com.google.gwt.dev.js.ast.JsRegExp;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.HashMultiset;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multiset;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JsLiteralInterner {
    public static final int INTERN_ARRAY_LITERALS = 1;
    public static final int INTERN_NUMBERS = 2;
    public static final int INTERN_OBJECT_LITERALS = 4;
    public static final int INTERN_REGEXES = 8;
    public static final int INTERN_STRINGS = 16;
    public static final int INTERN_ALL = 31;
    private static final String PREFIX = "$intern_";

    public static Map<JsName, JsLiteral> exec(JProgram jprogram, JsProgram program, int whatToIntern) {
        LiteralInterningVisitor v = new LiteralInterningVisitor(jprogram, program.getScope(), false, JsLiteralInterner.computeOccurrenceCounts(program), whatToIntern);
        v.accept(program);
        HashMap bins = Maps.newHashMap();
        int j = program.getFragmentCount();
        for (int i = 0; i < j; ++i) {
            bins.put(i, Sets.newLinkedHashSet());
        }
        for (Map.Entry entry : v.fragmentAssignment.entrySet()) {
            Set set = (Set)bins.get(entry.getValue());
            assert (set != null);
            set.add((JsLiteral)entry.getKey());
        }
        for (Map.Entry entry : bins.entrySet()) {
            JsLiteralInterner.createVars(program, program.getFragmentBlock((Integer)entry.getKey()), (Collection)entry.getValue(), v.variableNameForInternedLiteral);
        }
        return JsLiteralInterner.reverse(v.variableNameForInternedLiteral);
    }

    public static boolean exec(JsProgram program, JsBlock block, JsScope scope, boolean alwaysIntern) {
        Multiset<JsLiteral> occurrencesPerLiteral = null;
        if (!alwaysIntern) {
            occurrencesPerLiteral = JsLiteralInterner.computeOccurrenceCounts(block);
        }
        LiteralInterningVisitor v = new LiteralInterningVisitor(null, scope, alwaysIntern, occurrencesPerLiteral, 31);
        v.accept(block);
        JsLiteralInterner.createVars(program, block, v.variableNameForInternedLiteral.keySet(), v.variableNameForInternedLiteral);
        return v.didChange();
    }

    private static void createVars(JsProgram program, JsBlock block, Collection<JsLiteral> toCreate, Map<JsLiteral, JsName> names) {
        if (toCreate.size() > 0) {
            SourceInfo sourceInfo = program.createSourceInfoSynthetic(JsLiteralInterner.class);
            JsVars vars = new JsVars(sourceInfo, new JsVars.JsVar[0]);
            for (JsLiteral literal : toCreate) {
                JsVars.JsVar var = new JsVars.JsVar(sourceInfo, names.get(literal));
                var.setInitExpr(literal);
                vars.add(var);
            }
            block.getStatements().add(0, vars);
        }
    }

    private static Multiset<JsLiteral> computeOccurrenceCounts(JsNode node) {
        OccurrenceCounterVisitor oc = new OccurrenceCounterVisitor();
        oc.accept(node);
        return oc.getLiteralCounts();
    }

    private static Map<JsName, JsLiteral> reverse(Map<JsLiteral, JsName> variableNameForInternedLiteral) {
        LinkedHashMap<JsName, JsLiteral> reversed = Maps.newLinkedHashMap();
        for (Map.Entry<JsLiteral, JsName> entry : variableNameForInternedLiteral.entrySet()) {
            reversed.put(entry.getValue(), entry.getKey());
        }
        return reversed;
    }

    private static boolean hasLhsLiteral(JsBinaryOperation x) {
        return x.getOperator().isAssignment() && x.getArg1() instanceof JsLiteral;
    }

    private JsLiteralInterner() {
    }

    private static class LiteralInterningVisitor
    extends JsModVisitor {
        private static final int AVERAGE_ID_LENGTH = 3;
        private static final int INTERNED_LITERAL_DECLARATION_OVERHEAD = 5;
        private static final Integer MINIMUM_NUMBER_OF_OCCURRENCES_TO_INTERN = Integer.parseInt(System.getProperty("gwt.jjs.literalInternerThreshold", "2"));
        private int currentFragment = 0;
        private final Map<JsLiteral, Integer> fragmentAssignment = Maps.newLinkedHashMap();
        private long lastId = 0L;
        private Multiset<JsLiteral> occurrencesPerLiteral;
        private final JProgram program;
        private final JsScope scope;
        private final boolean alwaysIntern;
        private final Map<JsLiteral, JsName> variableNameForInternedLiteral = Maps.newLinkedHashMap();
        private final int whatToIntern;

        public LiteralInterningVisitor(JProgram program, JsScope scope, boolean alwaysIntern, Multiset<JsLiteral> occurrencesPerLiteral, int whatToIntern) {
            assert (alwaysIntern || occurrencesPerLiteral != null);
            this.program = program;
            this.scope = scope;
            this.occurrencesPerLiteral = occurrencesPerLiteral;
            this.whatToIntern = whatToIntern;
            this.alwaysIntern = alwaysIntern;
        }

        @Override
        public void endVisit(JsProgramFragment x, JsContext ctx) {
            ++this.currentFragment;
        }

        @Override
        public boolean visit(JsArrayLiteral x, JsContext ctx) {
            boolean interned = false;
            if ((this.whatToIntern & 1) != 0) {
                interned = this.maybeInternLiteral(x, ctx);
            }
            return !interned;
        }

        @Override
        public boolean visit(JsBinaryOperation x, JsContext ctx) {
            if (!JsLiteralInterner.hasLhsLiteral(x)) {
                x.setArg1(this.accept(x.getArg1()));
            }
            x.setArg2(this.accept(x.getArg2()));
            return false;
        }

        @Override
        public boolean visit(JsPostfixOperation x, JsContext ctx) {
            return !(x.getArg() instanceof JsLiteral);
        }

        @Override
        public boolean visit(JsPrefixOperation x, JsContext ctx) {
            return !(x.getArg() instanceof JsLiteral);
        }

        @Override
        public boolean visit(JsPropertyInitializer x, JsContext ctx) {
            x.setValueExpr(this.accept(x.getValueExpr()));
            return false;
        }

        @Override
        public boolean visit(JsStringLiteral x, JsContext ctx) {
            if ((this.whatToIntern & 0x10) != 0) {
                this.maybeInternLiteral(x, ctx);
            }
            return false;
        }

        @Override
        public boolean visit(JsObjectLiteral x, JsContext ctx) {
            boolean interned = false;
            if ((this.whatToIntern & 4) != 0) {
                interned = this.maybeInternLiteral(x, ctx);
            }
            return !interned;
        }

        @Override
        public boolean visit(JsRegExp x, JsContext ctx) {
            if ((this.whatToIntern & 8) != 0) {
                this.maybeInternLiteral(x, ctx);
            }
            return false;
        }

        @Override
        public boolean visit(JsNumberLiteral x, JsContext ctx) {
            if ((this.whatToIntern & 2) != 0) {
                this.maybeInternLiteral(x, ctx);
            }
            return false;
        }

        private boolean isProfitableToIntern(JsLiteral literal, int occurrences) {
            int uninternedSize;
            int literalSize = literal.toSource().length();
            int internedSize = occurrences * 3 + 5 + literalSize;
            return internedSize < (uninternedSize = occurrences * literalSize);
        }

        private boolean maybeInternLiteral(JsLiteral x, JsContext ctx) {
            Integer currentAssignment;
            JsName name;
            if (!x.isInternable()) {
                return false;
            }
            if (!this.alwaysIntern) {
                int occurrences = this.occurrencesPerLiteral.count(x);
                if (occurrences < MINIMUM_NUMBER_OF_OCCURRENCES_TO_INTERN) {
                    return false;
                }
                boolean alreadyInterned = this.variableNameForInternedLiteral.containsKey(x);
                if (!alreadyInterned && !this.isProfitableToIntern(x, occurrences)) {
                    return false;
                }
            }
            if ((name = this.variableNameForInternedLiteral.get(x)) == null) {
                String ident = JsLiteralInterner.PREFIX + this.lastId++;
                name = this.scope.declareName(ident);
                this.variableNameForInternedLiteral.put(x, name);
            }
            if ((currentAssignment = this.fragmentAssignment.get(x)) == null) {
                this.fragmentAssignment.put(x, this.currentFragment);
            } else if (currentAssignment != this.currentFragment) {
                Preconditions.checkState(this.program != null, "JsLiteralInterner cannot be used with fragmented JsProgram without an accompanying JProgram");
                int newAssignment = this.program.getCommonAncestorFragmentId(currentAssignment, this.currentFragment);
                if (newAssignment != currentAssignment) {
                    this.fragmentAssignment.put(x, newAssignment);
                }
            }
            ctx.replaceMe(name.makeRef(x.getSourceInfo().makeChild()));
            return true;
        }

        @Override
        public boolean visit(JsVars.JsVar x, JsContext ctx) {
            return !x.getName().getIdent().startsWith(JsLiteralInterner.PREFIX);
        }
    }

    private static class OccurrenceCounterVisitor
    extends JsVisitor {
        private Multiset<JsLiteral> countByLiteral = HashMultiset.create();

        private OccurrenceCounterVisitor() {
        }

        public Multiset<JsLiteral> getLiteralCounts() {
            return this.countByLiteral;
        }

        private boolean doVisitLiteral(JsLiteral x) {
            if (x.isInternable()) {
                this.countByLiteral.add(x);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(JsBinaryOperation x, JsContext ctx) {
            if (!JsLiteralInterner.hasLhsLiteral(x)) {
                this.accept(x.getArg1());
            }
            this.accept(x.getArg2());
            return false;
        }

        @Override
        public boolean visit(JsPostfixOperation x, JsContext ctx) {
            return !(x.getArg() instanceof JsLiteral);
        }

        @Override
        public boolean visit(JsPrefixOperation x, JsContext ctx) {
            return !(x.getArg() instanceof JsLiteral);
        }

        @Override
        public boolean visit(JsPropertyInitializer x, JsContext ctx) {
            this.accept(x.getValueExpr());
            return false;
        }

        @Override
        public boolean visit(JsStringLiteral x, JsContext ctx) {
            return this.doVisitLiteral(x);
        }

        @Override
        public boolean visit(JsObjectLiteral x, JsContext ctx) {
            return this.doVisitLiteral(x);
        }

        @Override
        public boolean visit(JsRegExp x, JsContext ctx) {
            return this.doVisitLiteral(x);
        }

        @Override
        public boolean visit(JsNumberLiteral x, JsContext ctx) {
            return this.doVisitLiteral(x);
        }

        @Override
        public boolean visit(JsArrayLiteral x, JsContext ctx) {
            return this.doVisitLiteral(x);
        }

        @Override
        public boolean visit(JsVars.JsVar x, JsContext ctx) {
            return !x.getName().getIdent().startsWith(JsLiteralInterner.PREFIX);
        }
    }
}

