/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.common.InliningMode;
import com.google.gwt.dev.jjs.HasSourceInfo;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.js.JsSafeCloner;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsArrayAccess;
import com.google.gwt.dev.js.ast.JsArrayLiteral;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsBooleanLiteral;
import com.google.gwt.dev.js.ast.JsCatchScope;
import com.google.gwt.dev.js.ast.JsConditional;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsEmpty;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNew;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsPostfixOperation;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsPropertyInitializer;
import com.google.gwt.dev.js.ast.JsRegExp;
import com.google.gwt.dev.js.ast.JsReturn;
import com.google.gwt.dev.js.ast.JsRootScope;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsThisRef;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.util.collect.Stack;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.HashMultiset;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multiset;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class JsInliner {
    private static final String NAME = JsInliner.class.getSimpleName();
    public static final int MAX_INLINE_FN_SIZE = Integer.parseInt(System.getProperty("gwt.jsinlinerMaxFnSize", "23"));
    private static final double MAX_COMPLEXITY_INCREASE = Double.parseDouble(System.getProperty("gwt.jsinlinerRatio", "1.0"));
    private static final int INLINING_BIAS = Integer.parseInt(System.getProperty("gwt.jsinlinerInliningBias", "5"));

    public static OptimizerStats exec(JsProgram program, Collection<JsNode> toInline) {
        SpeedTracerLogger.Event optimizeJsEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE_JS, "optimizer", NAME);
        OptimizerStats stats = JsInliner.execImpl(program, toInline);
        optimizeJsEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    private static boolean affectedBySideEffects(List<JsExpression> list, JsFunction context) {
        JsScope safeScope = null;
        if (context != null && !JsInliner.containsNestedFunctions(context)) {
            safeScope = context.getScope();
        }
        AffectedBySideEffectsVisitor v = new AffectedBySideEffectsVisitor(safeScope);
        v.acceptList(list);
        return v.affectedBySideEffects();
    }

    private static int complexity(JsNode toEstimate) {
        ComplexityEstimator e = new ComplexityEstimator();
        e.accept(toEstimate);
        return e.getComplexity();
    }

    private static boolean containsNestedFunctions(JsFunction func) {
        NestedFunctionVisitor v = new NestedFunctionVisitor();
        v.accept(func.getBody());
        return v.containsNestedFunctions();
    }

    private static OptimizerStats execImpl(JsProgram program, Collection<JsNode> toInline) {
        OptimizerStats stats = new OptimizerStats(NAME);
        SingleInvocationVisitor s = new SingleInvocationVisitor();
        s.accept(program);
        LinkedHashSet<JsNode> candidates = Sets.newLinkedHashSet(toInline);
        candidates.addAll(s.inliningCandidates());
        RedefinedFunctionCollector d = new RedefinedFunctionCollector();
        d.accept(program);
        RecursionCollector rc = new RecursionCollector();
        for (JsNode fn : candidates) {
            rc.accept(fn);
        }
        InliningVisitor v = new InliningVisitor(program, candidates);
        v.blacklist(d.getRedefined());
        v.blacklist(rc.getRecursive());
        v.accept(program);
        if (v.didChange()) {
            stats.recordModified();
        }
        return stats;
    }

    private static boolean hasCommonIdents(List<JsExpression> arguments, JsNode toInline, Collection<String> parameterIdents) {
        boolean checkQualified = false;
        do {
            checkQualified = !checkQualified;
            IdentCollector argCollector = new IdentCollector(checkQualified);
            argCollector.acceptList(arguments);
            IdentCollector statementCollector = new IdentCollector(checkQualified);
            statementCollector.accept(toInline);
            Set<String> idents = argCollector.getIdents();
            if (!checkQualified) {
                idents.removeAll(parameterIdents);
            }
            idents.retainAll(statementCollector.getIdents());
            if (idents.size() <= 0) continue;
            return true;
        } while (checkQualified);
        return false;
    }

    private static boolean hasSideEffects(List<JsExpression> list) {
        for (JsExpression expr : list) {
            if (!expr.hasSideEffects()) continue;
            return true;
        }
        return false;
    }

    private static JsExpression convertToExpression(JsStatement statement) {
        JsExpression expression;
        if (statement instanceof JsExprStmt) {
            JsExprStmt exprStmt = (JsExprStmt)statement;
            expression = exprStmt.getExpression();
        } else if (statement instanceof JsReturn) {
            JsReturn ret = (JsReturn)statement;
            expression = ret.getExpr();
            if (expression == null) {
                expression = new JsNameRef(ret.getSourceInfo(), JsRootScope.INSTANCE.getUndefined());
            }
        } else if (statement instanceof JsVars) {
            JsVars vars = (JsVars)statement;
            expression = JsNullLiteral.INSTANCE;
            for (JsVars.JsVar var : vars) {
                JsExpression init = var.getInitExpr();
                if (init == null) continue;
                SourceInfo sourceInfo = var.getSourceInfo();
                JsBinaryOperation assignment = new JsBinaryOperation(sourceInfo, JsBinaryOperator.ASG);
                assignment.setArg1(var.getName().makeRef(sourceInfo));
                assignment.setArg2(init);
                JsBinaryOperation comma = new JsBinaryOperation(sourceInfo, JsBinaryOperator.COMMA);
                comma.setArg1(expression);
                comma.setArg2(assignment);
                expression = comma;
            }
        } else {
            return null;
        }
        assert (expression != null);
        return JsSafeCloner.clone(expression);
    }

    private static boolean isInlinable(JsFunction caller, JsFunction callee, JsExpression thisExpr, List<JsExpression> arguments, JsNode toInline) {
        List<JsExpression> evalArgs;
        if (arguments.size() != callee.getParameters().size()) {
            return false;
        }
        HashSet<JsName> parameterNames = Sets.newHashSet();
        HashSet<String> parameterIdents = Sets.newHashSet();
        for (JsParameter param : callee.getParameters()) {
            parameterNames.add(param.getName());
            parameterIdents.add(param.getName().getIdent());
        }
        StableNameChecker detector = new StableNameChecker(caller.getScope(), callee.getScope(), parameterNames);
        detector.accept(toInline);
        if (!detector.isStable()) {
            return false;
        }
        if (JsInliner.hasCommonIdents(arguments, toInline, parameterIdents)) {
            return false;
        }
        if (thisExpr == null) {
            evalArgs = arguments;
        } else {
            evalArgs = Lists.newArrayListWithCapacity(1 + arguments.size());
            evalArgs.add(thisExpr);
            evalArgs.addAll(arguments);
        }
        if (JsInliner.isVolatile(evalArgs, caller)) {
            ArrayList<JsName> requiredOrder = Lists.newArrayList();
            if (thisExpr != null && JsInliner.isVolatile(thisExpr, callee)) {
                requiredOrder.add(EvaluationOrderVisitor.THIS_NAME);
            }
            for (int i = 0; i < arguments.size(); ++i) {
                JsExpression e = arguments.get(i);
                JsParameter p = callee.getParameters().get(i);
                if (!JsInliner.isVolatile(e, callee)) continue;
                requiredOrder.add(p.getName());
            }
            assert (requiredOrder.size() > 0);
            EvaluationOrderVisitor orderVisitor = new EvaluationOrderVisitor(requiredOrder, callee);
            orderVisitor.accept(toInline);
            if (!orderVisitor.maintainsOrder()) {
                return false;
            }
        }
        ParameterUsageVisitor v = new ParameterUsageVisitor(thisExpr != null, parameterNames);
        v.accept(toInline);
        return !v.hasViolation();
    }

    private static boolean isReturnStatement(JsStatement statement) {
        return statement instanceof JsReturn;
    }

    private static boolean isVolatile(JsExpression e, JsFunction context) {
        return JsInliner.isVolatile(Collections.singletonList(e), context);
    }

    private static boolean isVolatile(List<JsExpression> list, JsFunction context) {
        return JsInliner.hasSideEffects(list) || JsInliner.affectedBySideEffects(list, context);
    }

    private static JsInvocation tryToUnravelExplicitCall(JsInvocation x) {
        if (!(x.getQualifier() instanceof JsNameRef)) {
            return x;
        }
        JsNameRef ref = (JsNameRef)x.getQualifier();
        if (ref.getName().isObfuscatable() || !"call".equals(ref.getIdent())) {
            return x;
        }
        List<JsExpression> oldArgs = x.getArguments();
        if (oldArgs.size() < 1) {
            return x;
        }
        JsNameRef oldTarget = (JsNameRef)ref.getQualifier();
        JsNameRef newTarget = new JsNameRef(oldTarget.getSourceInfo(), oldTarget.getName());
        newTarget.setQualifier(oldArgs.get(0));
        JsInvocation newCall = new JsInvocation(x.getSourceInfo(), (JsExpression)newTarget, oldArgs.subList(1, oldArgs.size()));
        return newCall;
    }

    private JsInliner() {
    }

    private static class StableNameChecker
    extends JsVisitor {
        private final JsScope calleeScope;
        private final JsScope callerScope;
        private final Collection<JsName> parameterNames;
        private boolean stable = true;

        public StableNameChecker(JsScope callerScope, JsScope calleeScope, Collection<JsName> parameterNames) {
            this.callerScope = callerScope;
            this.calleeScope = calleeScope;
            this.parameterNames = parameterNames;
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            if (x.getQualifier() != null) {
                return;
            }
            JsName callerName = this.callerScope.findExistingName(x.getIdent());
            JsName calleeName = this.calleeScope.findExistingName(x.getIdent());
            if (!(callerName == null && calleeName == null || this.parameterNames.contains(calleeName) || callerName != null && callerName.equals(calleeName) || calleeName != null && calleeName.getEnclosing().equals(this.calleeScope))) {
                this.stable = false;
            }
        }

        public boolean isStable() {
            return this.stable;
        }

        @Override
        public boolean visit(JsObjectLiteral x, JsContext ctx) {
            for (JsPropertyInitializer propertyInitializer : x.getPropertyInitializers()) {
                this.accept(propertyInitializer.getValueExpr());
            }
            return false;
        }
    }

    private static class RefersToNameVisitor
    extends JsVisitor {
        private final Collection<JsName> names;
        private boolean refersToName;

        public RefersToNameVisitor(Collection<JsName> names) {
            this.names = names;
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            JsName name = x.getName();
            if (name != null) {
                this.refersToName = this.refersToName || this.names.contains(name);
            }
        }

        public boolean refersToName() {
            return this.refersToName;
        }
    }

    private static class RedefinedFunctionCollector
    extends JsVisitor {
        private final Map<JsName, JsFunction> nameMap = Maps.newIdentityHashMap();
        private final Set<JsFunction> redefined = Sets.newHashSet();

        private RedefinedFunctionCollector() {
        }

        @Override
        public void endVisit(JsBinaryOperation x, JsContext ctx) {
            if (!x.getOperator().equals(JsBinaryOperator.ASG)) {
                return;
            }
            JsFunction f = JsUtils.isFunction(x.getArg1());
            if (f != null) {
                this.redefined.add(f);
            }
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            JsName name = x.getName();
            if (name == null) {
                return;
            }
            if (this.nameMap.containsKey(name)) {
                this.redefined.add(this.nameMap.get(name));
                this.redefined.add(x);
            } else {
                this.nameMap.put(name, x);
            }
        }

        public Collection<JsFunction> getRedefined() {
            return this.redefined;
        }
    }

    private static class RecursionCollector
    extends JsVisitor {
        private final Stack<JsFunction> functionStack = Stack.create();
        private final Set<JsFunction> recursive = Sets.newHashSet();

        private RecursionCollector() {
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            if (!this.functionStack.pop().equals(x)) {
                throw new InternalCompilerException("Unexpected function popped");
            }
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            JsFunction f = JsUtils.isFunction(x.getQualifier());
            if (this.functionStack.contains(f)) {
                this.recursive.add(f);
            }
        }

        public Set<JsFunction> getRecursive() {
            return this.recursive;
        }

        @Override
        public boolean visit(JsFunction x, JsContext ctx) {
            this.functionStack.push(x);
            return true;
        }
    }

    private static class ParameterUsageVisitor
    extends JsVisitor {
        private final boolean hasThisExpr;
        private final Set<JsName> parameterNames;
        private boolean violation = false;

        public ParameterUsageVisitor(boolean hasThisExpr, Set<JsName> parameterNames) {
            this.hasThisExpr = hasThisExpr;
            this.parameterNames = parameterNames;
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            if (ctx.isLvalue() && this.isParameter(x)) {
                this.violation = true;
            }
        }

        @Override
        public void endVisit(JsThisRef x, JsContext ctx) {
            if (!this.hasThisExpr) {
                this.violation = true;
            }
        }

        public boolean hasViolation() {
            return this.violation;
        }

        private boolean isParameter(JsNameRef ref) {
            if (ref.getQualifier() != null) {
                return false;
            }
            JsName name = ref.getName();
            return this.parameterNames.contains(name);
        }
    }

    private static class NestedFunctionVisitor
    extends JsVisitor {
        private boolean containsNestedFunctions = false;

        private NestedFunctionVisitor() {
        }

        public boolean containsNestedFunctions() {
            return this.containsNestedFunctions;
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            this.containsNestedFunctions = true;
        }
    }

    private static class NameRefReplacerVisitor
    extends JsModVisitor {
        final Map<JsName, JsName> nameReplacements = Maps.newIdentityHashMap();
        final Map<JsName, JsExpression> paramsToArgsMap = Maps.newIdentityHashMap();
        private JsExpression thisExpr;

        public NameRefReplacerVisitor(JsExpression thisExpr, List<JsExpression> arguments, List<JsParameter> parameters) {
            this.thisExpr = thisExpr;
            if (parameters.size() != arguments.size()) {
                throw new InternalCompilerException("Mismatch on parameters and arguments");
            }
            for (int i = 0; i < parameters.size(); ++i) {
                JsParameter p = parameters.get(i);
                JsExpression e = arguments.get(i);
                this.paramsToArgsMap.put(p.getName(), e);
            }
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            if (x.getQualifier() != null) {
                return;
            }
            JsExpression replacement = this.tryGetReplacementExpression(x.getSourceInfo(), x.getName());
            if (replacement != null) {
                ctx.replaceMe(replacement);
            }
        }

        @Override
        public void endVisit(JsThisRef x, JsContext ctx) {
            assert (this.thisExpr != null);
            ctx.replaceMe(this.thisExpr);
        }

        public JsName setReplacementName(JsName name, JsName newName) {
            return this.nameReplacements.put(name, newName);
        }

        private JsExpression tryGetReplacementExpression(SourceInfo sourceInfo, JsName name) {
            if (this.paramsToArgsMap.containsKey(name)) {
                return this.paramsToArgsMap.get(name);
            }
            if (this.nameReplacements.containsKey(name)) {
                return this.nameReplacements.get(name).makeRef(sourceInfo);
            }
            return null;
        }
    }

    private static class SingleInvocationVisitor
    extends JsVisitor {
        private final Map<JsFunction, JsFunction> singleInvocations = Maps.newLinkedHashMap();
        private static final JsFunction MULTIPLE = JsFunction.createSentinel();
        private final Stack<JsFunction> functionStack = new Stack();

        private SingleInvocationVisitor() {
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            if (!this.functionStack.pop().equals(x)) {
                throw new InternalCompilerException("Unexpected function popped");
            }
        }

        public Collection<JsNode> inliningCandidates() {
            LinkedHashSet<JsNode> set = Sets.newLinkedHashSet();
            for (Map.Entry<JsFunction, JsFunction> entry : this.singleInvocations.entrySet()) {
                if (entry.getValue() == MULTIPLE) continue;
                set.add(entry.getValue());
            }
            return set;
        }

        @Override
        public boolean visit(JsFunction x, JsContext ctx) {
            this.functionStack.push(x);
            return true;
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            this.checkFunctionCall(x.getQualifier());
        }

        @Override
        public void endVisit(JsNew x, JsContext ctx) {
            this.checkFunctionCall(x.getConstructorExpression());
        }

        private void checkFunctionCall(JsExpression qualifier) {
            JsFunction function = JsUtils.isFunction(qualifier);
            if (function != null && !this.functionStack.isEmpty()) {
                JsFunction recordedInvoker = this.singleInvocations.get(function);
                if (recordedInvoker == null && this.functionStack.peek() != function) {
                    this.singleInvocations.put(function, this.functionStack.peek());
                } else if (recordedInvoker != MULTIPLE) {
                    this.singleInvocations.put(function, MULTIPLE);
                }
            }
        }
    }

    private static class InvocationCountingVisitor
    extends JsVisitor {
        private boolean removingCounts = false;
        private final Multiset<JsFunction> invocationCount = HashMultiset.create();

        private InvocationCountingVisitor() {
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            this.checkFunctionCall(x.getQualifier());
        }

        @Override
        public void endVisit(JsNew x, JsContext ctx) {
            this.checkFunctionCall(x.getConstructorExpression());
        }

        public int invocationCount(JsFunction f) {
            return this.invocationCount.count(f);
        }

        public void removeCountsFor(JsExpression expr) {
            assert (!this.removingCounts);
            this.removingCounts = true;
            this.accept(expr);
            this.removingCounts = false;
        }

        private void checkFunctionCall(JsExpression qualifier) {
            JsFunction function = JsUtils.isFunction(qualifier);
            if (function == null) {
                return;
            }
            if (this.removingCounts) {
                this.invocationCount.remove(function);
            } else {
                this.invocationCount.add(function);
            }
        }
    }

    private static class InliningVisitor
    extends JsModVisitor {
        private final Set<JsFunction> blacklist = Sets.newHashSet();
        private final Set<JsNode> whitelist;
        private final Stack<JsFunction> inlining = new Stack();
        private final Stack<JsFunction> functionStack = new Stack();
        private final InvocationCountingVisitor invocationCountingVisitor = new InvocationCountingVisitor();
        private final Stack<List<JsName>> newLocalVariableStack = Stack.create();
        private Map<JsScope, Multiset<String>> nextSuffixForIdentifierByScope = Maps.newIdentityHashMap();
        private JsFunction programFunction;

        public InliningVisitor(JsProgram program, Set<JsNode> whitelist) {
            this.whitelist = whitelist;
            this.invocationCountingVisitor.accept(program);
        }

        public void blacklist(Collection<JsFunction> functions) {
            this.blacklist.addAll(functions);
        }

        @Override
        public void endVisit(JsExprStmt x, JsContext ctx) {
            JsBinaryOperation op;
            JsExpression e = x.getExpression();
            if (ctx.canRemove() && !x.getExpression().hasSideEffects()) {
                ctx.removeMe();
                return;
            }
            ArrayList<JsExprStmt> statements = Lists.newArrayList();
            while (e instanceof JsBinaryOperation && (op = (JsBinaryOperation)e).getOperator().equals(JsBinaryOperator.COMMA)) {
                if (op.getArg2().hasSideEffects()) {
                    statements.add(0, op.getArg2().makeStmt());
                }
                e = op.getArg1();
            }
            if (e.hasSideEffects()) {
                statements.add(0, e.makeStmt());
            }
            if (statements.size() == 0) {
                if (ctx.canRemove()) {
                    ctx.removeMe();
                } else {
                    ctx.replaceMe(new JsEmpty(x.getSourceInfo()));
                }
            } else if (x.getExpression() != ((JsExprStmt)statements.get(0)).getExpression()) {
                if (!ctx.canInsert()) {
                    JsBlock b = new JsBlock(x.getSourceInfo());
                    b.getStatements().addAll(statements);
                    ctx.replaceMe(b);
                    return;
                }
                for (JsStatement jsStatement : statements) {
                    ctx.insertBefore(jsStatement);
                }
                ctx.removeMe();
            }
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            if (!this.functionStack.pop().equals(x)) {
                throw new InternalCompilerException("Unexpected function popped");
            }
            JsBlock body = x.getBody();
            List<JsName> newLocalVariables = this.newLocalVariableStack.pop();
            this.addVars(x, body, newLocalVariables);
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            JsFunction callerFunction = this.functionStack.peek();
            JsFunction invokedFunction = JsUtils.isFunction(x.getQualifier());
            if (invokedFunction == null) {
                return;
            }
            if (!invokedFunction.isInliningAllowed() || this.blacklist.contains(invokedFunction)) {
                return;
            }
            if (invokedFunction.getBody().getStatements().size() > MAX_INLINE_FN_SIZE) {
                return;
            }
            if (invokedFunction == callerFunction) {
                this.blacklist.add(invokedFunction);
                return;
            }
            if (this.inlining.contains(invokedFunction)) {
                return;
            }
            this.inlining.push(invokedFunction);
            x = JsInliner.tryToUnravelExplicitCall(x);
            JsExpression op = this.process(x, callerFunction, invokedFunction);
            if (x != op) {
                op = this.accept(op);
                ctx.replaceMe(op);
            }
            if (this.inlining.pop() != invokedFunction) {
                throw new RuntimeException("Unexpected function popped");
            }
        }

        @Override
        public void endVisit(JsProgram x, JsContext ctx) {
            if (!this.functionStack.pop().equals(this.programFunction)) {
                throw new InternalCompilerException("Unexpected function popped");
            }
            assert (this.programFunction.getBody().getStatements().size() == 0) : "Should not have moved statements into program";
            List<JsName> newLocalVariables = this.newLocalVariableStack.pop();
            assert (newLocalVariables.size() == 0) : "Should not have tried to create variables in program";
        }

        @Override
        public boolean visit(JsFunction x, JsContext ctx) {
            this.functionStack.push(x);
            this.newLocalVariableStack.push(Lists.newArrayList());
            return this.whitelist.contains(x);
        }

        @Override
        public boolean visit(JsProgram x, JsContext ctx) {
            this.programFunction = new JsFunction(x.getSourceInfo(), x.getScope());
            this.programFunction.setBody(new JsBlock(x.getSourceInfo()));
            this.functionStack.push(this.programFunction);
            this.newLocalVariableStack.push(Lists.newArrayList());
            return true;
        }

        private void addVars(HasSourceInfo x, JsBlock body, List<JsName> newLocalVariables) {
            JsVars vars;
            if (newLocalVariables.isEmpty()) {
                return;
            }
            List<JsStatement> statements = body.getStatements();
            assert (!statements.isEmpty());
            SourceInfo sourceInfo = x.getSourceInfo();
            if (statements.get(0) instanceof JsVars) {
                vars = (JsVars)statements.get(0);
            } else {
                vars = new JsVars(sourceInfo, new JsVars.JsVar[0]);
                statements.add(0, vars);
            }
            for (JsName name : newLocalVariables) {
                vars.add(new JsVars.JsVar(sourceInfo, name));
            }
        }

        private boolean isInvokedMoreThanOnce(JsFunction f) {
            return this.invocationCountingVisitor.invocationCount(f) > 1;
        }

        private JsExpression process(JsInvocation x, JsFunction callerFunction, JsFunction invokedFunction) {
            List<Object> statements = invokedFunction.getBody() != null ? Lists.newArrayList(invokedFunction.getBody().getStatements()) : Collections.emptyList();
            ArrayList<JsExpression> inlinableBodyAsExpression = Lists.newArrayListWithCapacity(statements.size());
            JsExpression thisExpr = ((JsNameRef)x.getQualifier()).getQualifier();
            ExtrudedNamesCollector extrudedNamesCollector = new ExtrudedNamesCollector(callerFunction.getScope(), invokedFunction.getScope());
            boolean sawReturnStatement = false;
            for (JsStatement statement : statements) {
                if (sawReturnStatement) {
                    return x;
                }
                JsExpression statementAsExpression = JsInliner.convertToExpression(statement);
                if (statementAsExpression == null) {
                    return x;
                }
                if (!(sawReturnStatement |= JsInliner.isReturnStatement(statement)) && !statementAsExpression.hasSideEffects()) continue;
                extrudedNamesCollector.accept(statementAsExpression);
                inlinableBodyAsExpression.add(statementAsExpression);
            }
            List<JsName> extrudedNames = extrudedNamesCollector.getExtrudedNames();
            if (extrudedNames.size() != 0 && callerFunction == this.programFunction) {
                return x;
            }
            if (!sawReturnStatement) {
                inlinableBodyAsExpression.add(new JsNameRef(x.getSourceInfo(), JsRootScope.INSTANCE.getUndefined()));
            }
            assert (inlinableBodyAsExpression.size() > 0);
            SourceInfo sourceInfo = x.getSourceInfo();
            ListIterator i = inlinableBodyAsExpression.listIterator(inlinableBodyAsExpression.size());
            JsExpression op = (JsExpression)i.previous();
            while (i.hasPrevious()) {
                JsBinaryOperation outerOp = new JsBinaryOperation(sourceInfo, JsBinaryOperator.COMMA);
                outerOp.setArg1((JsExpression)i.previous());
                outerOp.setArg2(op);
                op = outerOp;
            }
            if (!JsInliner.isInlinable(callerFunction, invokedFunction, thisExpr, x.getArguments(), op)) {
                return x;
            }
            NameRefReplacerVisitor nameRefReplacer = new NameRefReplacerVisitor(thisExpr, x.getArguments(), invokedFunction.getParameters());
            ListIterator<JsName> nameIterator = extrudedNames.listIterator();
            while (nameIterator.hasNext()) {
                JsName name = nameIterator.next();
                JsName newName = this.getUnusedName(callerFunction.getScope(), invokedFunction.getName() + "_" + name.getIdent(), name.getShortIdent());
                nameRefReplacer.setReplacementName(name, newName);
                nameIterator.set(newName);
            }
            op = nameRefReplacer.accept(op);
            op = new CommaNormalizer(extrudedNames).accept(op);
            if (callerFunction == this.programFunction && extrudedNames.size() > 0) {
                return x;
            }
            if (invokedFunction.getInliningMode() != InliningMode.FORCE_INLINE && this.isTooComplexToInline(x, op) && this.isInvokedMoreThanOnce(invokedFunction)) {
                return x;
            }
            this.newLocalVariableStack.peek().addAll(extrudedNames);
            this.invocationCountingVisitor.removeCountsFor(x);
            this.invocationCountingVisitor.accept(op);
            return op;
        }

        private JsName getUnusedName(JsScope scope, String baseName, String shortIdentifier) {
            String identifier;
            Multiset<String> nextSuffixForIdentifier = this.nextSuffixForIdentifierByScope.get(scope);
            if (nextSuffixForIdentifier == null) {
                nextSuffixForIdentifier = HashMultiset.create();
                this.nextSuffixForIdentifierByScope.put(scope, nextSuffixForIdentifier);
            }
            int suffix = nextSuffixForIdentifier.count(baseName);
            while (scope.findExistingName(identifier = baseName + "_" + suffix++) != null) {
            }
            nextSuffixForIdentifier.setCount(baseName, suffix);
            return scope.declareName(identifier, shortIdentifier);
        }

        private boolean isTooComplexToInline(JsInvocation x, JsExpression op) {
            int originalComplexity = JsInliner.complexity(x);
            int inlinedComplexity = JsInliner.complexity(op);
            return (double)inlinedComplexity / (double)(originalComplexity + INLINING_BIAS) > MAX_COMPLEXITY_INCREASE;
        }
    }

    private static class IdentCollector
    extends JsVisitor {
        private final boolean collectQualified;
        private final Set<String> idents = Sets.newHashSet();

        public IdentCollector(boolean collectQualified) {
            this.collectQualified = collectQualified;
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            boolean hasQualifier;
            boolean bl = hasQualifier = x.getQualifier() != null;
            if (this.collectQualified && !hasQualifier || !this.collectQualified && hasQualifier) {
                return;
            }
            assert (x.getIdent() != null);
            this.idents.add(x.getIdent());
        }

        public Set<String> getIdents() {
            return this.idents;
        }
    }

    private static class ExtrudedNamesCollector
    extends JsVisitor {
        private final JsScope toScope;
        private final JsScope fromScope;
        private final List<JsName> hoistedNames;

        public ExtrudedNamesCollector(JsScope toScope, JsScope fromScope) {
            this.toScope = toScope;
            this.fromScope = fromScope;
            this.hoistedNames = Lists.newArrayList();
        }

        public List<JsName> getExtrudedNames() {
            return this.hoistedNames;
        }

        @Override
        public boolean visit(JsNameRef nameRef, JsContext ctx) {
            JsName name = nameRef.getName();
            JsName fromScopeName = this.fromScope.findExistingName(name.getIdent());
            JsName toScopeName = this.toScope.findExistingName(name.getIdent());
            if (name.getStaticRef() == null && name == fromScopeName && name != toScopeName && !this.hoistedNames.contains(name)) {
                this.hoistedNames.add(name);
            }
            return true;
        }
    }

    private static class EvaluationOrderVisitor
    extends JsVisitor {
        public static final JsName THIS_NAME = new JsCatchScope(JsRootScope.INSTANCE, "this").getAllNames().iterator().next();
        private boolean maintainsOrder = true;
        private final List<JsName> toEvaluate;
        private final List<JsName> unevaluated;
        private final Set<JsName> paramsOrLocals = Sets.newHashSet();

        public EvaluationOrderVisitor(List<JsName> toEvaluate, JsFunction callee) {
            this.toEvaluate = toEvaluate;
            this.unevaluated = Lists.newArrayList(toEvaluate);
            new JsVisitor(){

                @Override
                public void endVisit(JsParameter x, JsContext ctx) {
                    paramsOrLocals.add(x.getName());
                }

                @Override
                public boolean visit(JsVars.JsVar x, JsContext ctx) {
                    paramsOrLocals.add(x.getName());
                    return true;
                }
            }.accept(callee);
        }

        @Override
        public void endVisit(JsBinaryOperation x, JsContext ctx) {
            boolean conditionalEvaluation;
            JsBinaryOperator op = x.getOperator();
            boolean rightStrict = this.refersToRequiredName(x.getArg2());
            boolean bl = conditionalEvaluation = JsBinaryOperator.AND.equals(op) || JsBinaryOperator.OR.equals(op);
            if (rightStrict && conditionalEvaluation) {
                this.maintainsOrder = false;
            }
        }

        @Override
        public void endVisit(JsConditional x, JsContext ctx) {
            boolean thenStrict = this.refersToRequiredName(x.getThenExpression());
            boolean elseStrict = this.refersToRequiredName(x.getElseExpression());
            if (thenStrict || elseStrict) {
                this.maintainsOrder = false;
            }
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            this.maintainsOrder = false;
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            if (this.unevaluated.size() > 0) {
                this.maintainsOrder = false;
            }
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            this.checkName(x.getName());
        }

        @Override
        public void endVisit(JsNew x, JsContext ctx) {
            if (this.unevaluated.size() > 0) {
                this.maintainsOrder = false;
            }
        }

        @Override
        public void endVisit(JsThisRef x, JsContext ctx) {
            this.checkName(THIS_NAME);
        }

        public boolean maintainsOrder() {
            return this.maintainsOrder && this.unevaluated.size() == 0;
        }

        private void checkName(JsName name) {
            if (!this.toEvaluate.contains(name)) {
                if (!this.paramsOrLocals.contains(name) && this.unevaluated.size() > 0) {
                    this.maintainsOrder = false;
                }
                return;
            }
            if (this.unevaluated.size() == 0 || !this.unevaluated.remove(0).equals(name)) {
                this.maintainsOrder = false;
            }
        }

        private boolean refersToRequiredName(JsExpression e) {
            RefersToNameVisitor v = new RefersToNameVisitor(this.toEvaluate);
            v.accept(e);
            return v.refersToName();
        }
    }

    private static class ComplexityEstimator
    extends JsVisitor {
        public static final int AVERAGE_OBFUSCATED_IDENTIFIER_LENGTH = 2;
        private int complexity = 0;

        private ComplexityEstimator() {
        }

        @Override
        public void endVisit(JsArrayAccess x, JsContext ctx) {
            this.complexity += "[]".length();
        }

        @Override
        public void endVisit(JsArrayLiteral x, JsContext ctx) {
            this.complexity += x.getExpressions().size() * ",".length() + "[]".length();
        }

        @Override
        public void endVisit(JsBinaryOperation x, JsContext ctx) {
            this.complexity += x.getOperator().getSymbol().length();
        }

        @Override
        public void endVisit(JsBooleanLiteral x, JsContext ctx) {
            ++this.complexity;
        }

        @Override
        public void endVisit(JsConditional x, JsContext ctx) {
            this.complexity += "?:".length();
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            this.complexity += "function ".length() + x.getParameters().size() * ",".length() + "(){}".length();
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            this.complexity += x.getArguments().size() * ",".length() + "()".length();
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            this.complexity += 2;
        }

        @Override
        public void endVisit(JsNew x, JsContext ctx) {
            this.complexity += "new ".length() + x.getArguments().size() * ",".length() + "()".length();
        }

        @Override
        public void endVisit(JsNullLiteral x, JsContext ctx) {
            this.complexity += "null".length();
        }

        @Override
        public void endVisit(JsNumberLiteral x, JsContext ctx) {
            this.complexity += 2;
        }

        @Override
        public void endVisit(JsObjectLiteral x, JsContext ctx) {
            this.complexity += x.getPropertyInitializers().size() * ",:".length() + "{}".length();
        }

        @Override
        public void endVisit(JsPostfixOperation x, JsContext ctx) {
            this.complexity += x.getOperator().getSymbol().length();
        }

        @Override
        public void endVisit(JsPrefixOperation x, JsContext ctx) {
            this.complexity += x.getOperator().getSymbol().length();
        }

        @Override
        public void endVisit(JsRegExp x, JsContext ctx) {
            this.complexity += x.getPattern().length();
        }

        @Override
        public void endVisit(JsStringLiteral x, JsContext ctx) {
            this.complexity += 2;
        }

        @Override
        public void endVisit(JsThisRef x, JsContext ctx) {
            this.complexity += "this".length();
        }

        public int getComplexity() {
            return this.complexity;
        }
    }

    private static class CommaNormalizer
    extends JsModVisitor {
        private final List<JsName> localVariableNames;

        private static JsBinaryOperation isComma(JsExpression x) {
            if (!(x instanceof JsBinaryOperation)) {
                return null;
            }
            JsBinaryOperation op = (JsBinaryOperation)x;
            return op.getOperator().equals(JsBinaryOperator.COMMA) ? op : null;
        }

        public CommaNormalizer(List<JsName> localVariableNames) {
            this.localVariableNames = localVariableNames;
        }

        @Override
        public void endVisit(JsBinaryOperation x, JsContext ctx) {
            if (CommaNormalizer.isComma(x) == null) {
                return;
            }
            if (!x.getArg1().hasSideEffects()) {
                ctx.replaceMe(x.getArg2());
                return;
            }
            JsBinaryOperation toUpdate = CommaNormalizer.isComma(x.getArg2());
            if (toUpdate == null) {
                JsNameRef nameRef;
                JsNameRef nameRef2;
                JsBinaryOperation op;
                JsBinaryOperation inner = CommaNormalizer.isComma(x.getArg1());
                if (inner != null && !inner.getArg2().hasSideEffects()) {
                    x.setArg1(inner.getArg1());
                    this.didChange = true;
                }
                Object assignmentRef = null;
                JsExpression expr = null;
                JsName returnRef = null;
                if (x.getArg1() instanceof JsBinaryOperation && (op = (JsBinaryOperation)x.getArg1()).getOperator() == JsBinaryOperator.ASG && op.getArg1() instanceof JsNameRef && (nameRef2 = (JsNameRef)op.getArg1()).getQualifier() == null) {
                    assignmentRef = nameRef2.getName();
                    expr = op.getArg2();
                }
                if (x.getArg2() instanceof JsNameRef && (nameRef = (JsNameRef)x.getArg2()).getQualifier() == null) {
                    returnRef = nameRef.getName();
                }
                if (assignmentRef != null && assignmentRef.equals(returnRef) && this.localVariableNames.contains(assignmentRef)) {
                    assert (expr != null);
                    this.localVariableNames.remove(assignmentRef);
                    ctx.replaceMe(expr);
                }
                return;
            }
            while (CommaNormalizer.isComma(toUpdate.getArg1()) != null) {
                toUpdate = (JsBinaryOperation)toUpdate.getArg1();
            }
            JsBinaryOperation newOp = new JsBinaryOperation(x.getSourceInfo(), JsBinaryOperator.COMMA);
            newOp.setArg1(x.getArg1());
            newOp.setArg2(toUpdate.getArg1());
            toUpdate.setArg1(newOp);
            ctx.replaceMe(x.getArg2());
        }
    }

    private static class AffectedBySideEffectsVisitor
    extends JsVisitor {
        private boolean affectedBySideEffects;
        private final JsScope safeScope;

        public AffectedBySideEffectsVisitor(JsScope safeScope) {
            this.safeScope = safeScope;
        }

        public boolean affectedBySideEffects() {
            return this.affectedBySideEffects;
        }

        @Override
        public void endVisit(JsArrayLiteral x, JsContext ctx) {
            this.affectedBySideEffects = true;
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            this.affectedBySideEffects = true;
        }

        @Override
        public void endVisit(JsInvocation x, JsContext ctx) {
            this.affectedBySideEffects = true;
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            if (x.getQualifier() == null && x.getName() != null) {
                if (x.getName() == JsRootScope.INSTANCE.getUndefined()) {
                    return;
                }
                if (x.getName().getEnclosing() == this.safeScope) {
                    return;
                }
            }
            this.affectedBySideEffects = true;
        }

        @Override
        public void endVisit(JsObjectLiteral x, JsContext ctx) {
            this.affectedBySideEffects = true;
        }
    }
}

