/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.JsNamer;
import com.google.gwt.dev.js.JsObfuscateNamer;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.collect.HashMultiset;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multiset;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class JsIncrementalNamer
extends JsNamer {
    @VisibleForTesting
    public static final String RESERVED_IDENT_SUFFIX = "_g$";
    private final JavaToJavaScriptMap jjsmap;
    private final JsIncrementalNamerState state;
    private final boolean minifyFunctionNames;

    public static void exec(JsProgram program, ConfigurationProperties config, JsIncrementalNamerState state, JavaToJavaScriptMap jjsmap, boolean minifyFunctionNames) throws JsNamer.IllegalNameException {
        new JsIncrementalNamer(program, config, state, jjsmap, minifyFunctionNames).execImpl();
    }

    public JsIncrementalNamer(JsProgram program, ConfigurationProperties config, JsIncrementalNamerState state, JavaToJavaScriptMap jjsmap, boolean minifyFunctionNames) {
        super(program, config);
        this.state = state;
        this.jjsmap = jjsmap;
        this.minifyFunctionNames = minifyFunctionNames;
    }

    @Override
    protected void reset() {
    }

    @Override
    protected void visit(JsScope scope) throws JsNamer.IllegalNameException {
        for (JsScope child : scope.getChildren()) {
            this.visit(child);
        }
        for (JsName name : scope.getAllNames()) {
            if (!name.isObfuscatable()) {
                String ident = name.getIdent();
                if (ident.endsWith(RESERVED_IDENT_SUFFIX)) {
                    throw new JsNamer.IllegalNameException("Identifier " + ident + " ends with " + RESERVED_IDENT_SUFFIX + ". This is not allowed since that suffix is used to separate obfuscatable and nonobfuscatable names in per-file compiles.");
                }
                name.setShortIdent(ident);
                continue;
            }
            name.setShortIdent(this.getOrCreateIdent(name));
        }
    }

    private String getOrCreateIdent(JsName name) {
        String originalIdent = name.getIdent();
        String shortIdent = name.getShortIdent();
        if (this.state.renamedIdentByOriginalIdent.containsKey(originalIdent)) {
            return (String)this.state.renamedIdentByOriginalIdent.get(originalIdent);
        }
        if (this.minifyFunctionNames && this.jjsmap != null && this.jjsmap.nameToMethod(name) != null) {
            String obfuscatedIdent = this.makeObfuscatedIdent();
            this.state.usedIdents.add(obfuscatedIdent);
            this.state.renamedIdentByOriginalIdent.put(originalIdent, obfuscatedIdent);
            return obfuscatedIdent;
        }
        String prettyIdent = this.makePrettyName(shortIdent);
        this.state.usedIdents.add(prettyIdent);
        this.state.renamedIdentByOriginalIdent.put(originalIdent, prettyIdent);
        return prettyIdent;
    }

    private String makeObfuscatedIdent() {
        String obfuscatedIdent;
        while (!this.reserved.isAvailable(obfuscatedIdent = JsObfuscateNamer.makeObfuscatedIdent(++this.state.nextObfuscatedId) + RESERVED_IDENT_SUFFIX) || this.state.usedIdents.contains(obfuscatedIdent)) {
        }
        return obfuscatedIdent;
    }

    private String makePrettyName(String shortIdent) {
        String prettyIdent;
        do {
            prettyIdent = shortIdent + "_" + this.state.shortIdentCollisionCounts.count(shortIdent) + RESERVED_IDENT_SUFFIX;
            this.state.shortIdentCollisionCounts.add(shortIdent);
        } while (!this.reserved.isAvailable(prettyIdent) || this.state.usedIdents.contains(prettyIdent));
        return prettyIdent;
    }

    public static class JsIncrementalNamerState
    implements Serializable {
        private int nextObfuscatedId = -1;
        private Map<String, String> renamedIdentByOriginalIdent = Maps.newHashMap();
        private Multiset<String> shortIdentCollisionCounts = HashMultiset.create();
        private Set<String> usedIdents = Sets.newHashSet();

        public void copyFrom(JsIncrementalNamerState that) {
            this.shortIdentCollisionCounts.clear();
            this.renamedIdentByOriginalIdent.clear();
            this.usedIdents.clear();
            this.shortIdentCollisionCounts.addAll(that.shortIdentCollisionCounts);
            this.renamedIdentByOriginalIdent.putAll(that.renamedIdentByOriginalIdent);
            this.usedIdents.addAll(that.usedIdents);
            this.nextObfuscatedId = that.nextObfuscatedId;
        }

        @VisibleForTesting
        public boolean hasSameContent(JsIncrementalNamerState that) {
            return Objects.equal(this.shortIdentCollisionCounts, that.shortIdentCollisionCounts) && Objects.equal(this.renamedIdentByOriginalIdent, that.renamedIdentByOriginalIdent) && Objects.equal(this.usedIdents, that.usedIdents) && Objects.equal(this.nextObfuscatedId, that.nextObfuscatedId);
        }
    }
}

