/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.common.InliningMode;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsVisitor;

public class JsForceInliningChecker {
    private static final String NAME = JsForceInliningChecker.class.getSimpleName();

    public static void check(TreeLogger logger, JavaToJavaScriptMap javaToJavaScriptMap, JsProgram program) throws UnableToCompleteException {
        ForceInliningCheckerVisitor visitor = new ForceInliningCheckerVisitor(logger, javaToJavaScriptMap);
        visitor.accept(program);
        if (visitor.error) {
            throw new UnableToCompleteException();
        }
    }

    private JsForceInliningChecker() {
    }

    private static class ForceInliningCheckerVisitor
    extends JsVisitor {
        private final TreeLogger logger;
        private boolean error = false;
        private JavaToJavaScriptMap javaToJavaScriptMap;

        private ForceInliningCheckerVisitor(TreeLogger logger, JavaToJavaScriptMap javaToJavaScriptMap) {
            this.logger = logger;
            this.javaToJavaScriptMap = javaToJavaScriptMap;
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            if (x.getInliningMode() == InliningMode.FORCE_INLINE) {
                JMethod originalMethod = this.javaToJavaScriptMap.nameToMethod(x.getName());
                String methodName = originalMethod != null ? originalMethod.toString() : x.getName().getShortIdent();
                this.logger.log(TreeLogger.Type.ERROR, "Function " + methodName + " is marked as @ForceInline but it could not be inlined");
                this.error = true;
            }
        }
    }
}

